//inline  Flock::()
//{
//}

inline int Flock::fd() const
{
    return d_fd;
}

inline  std::string const &Flock::filename() const
{
    return d_filename;
}

template <typename Amount, typename Resolution>
inline bool Flock::exclusive(std::chrono::duration<Amount, Resolution> 
                                                                const &time) 
{
    return lockThread(time, LOCK_EX);
}

template <typename Amount, typename Resolution>
inline bool Flock::shared(std::chrono::duration<Amount, Resolution> 
                                                                const &time) 
{
    return lockThread(time, LOCK_SH);
}

// static
inline void Flock::tryLock(Flock *ptr, int lockType)
{
    ptr->notifyLock(lockType);
}

template <typename Amount, typename Resolution>
bool Flock::lockThread(std::chrono::duration<Amount, Resolution> const &time,
                       int flockType)
{
    requireFD();

    std::thread thr{ tryLock, this, flockType };     // try to flock
    thr.detach();

    d_sem.wait_for(time);

    return d_ok;
}

