#
# Script designed to be tested from inside the CamiTK Python interpreter using PythonManager::runScript
# See TestPythonScript.cpp
# 
# The requirements (if any) must defined in the the QRC file
#
import camitk
import numpy

camitk.Application.open(camitk.Core.getTestDataDir() + "/FullHead.mhd")
image = camitk.Application.getTopLevelComponents()[0]
image_data = image.getImageDataAsNumpy()

expected_shape = (94, 256, 256) # in CamiTK/VTK 256x256x94 (VTK is x-first)
actual_shape = image_data.shape
assert numpy.all(actual_shape == expected_shape), f"Should get {expected_shape} instead of {actual_shape} (note that numpy is z-first)"

expected_spacing = numpy.array([0.9375, 0.9375, 1.5], dtype='f')
actual_spacing = image.getSpacing()
assert numpy.all(expected_spacing == actual_spacing), f"Should get {expected_spacing} instead of {actual_spacing}"

assert camitk.Application.closeAll(), f"Close all should return true as no components have been modified"
