#ifndef H_CDW_CDIO_DRIVES
#define H_CDW_CDIO_DRIVES

#include <stdint.h> /* uint32_t needed by <cdio/device.h> */
#include <cdio/cdio.h>
#include <cdio/device.h>

#include "main.h"

/* does not include guard */
#define CDW_CDIO_DRIVES_N_DEVICES_MAX 10




typedef struct {
	char *fullpath;
	cdio_drive_read_cap_t  read_cap;
	cdio_drive_write_cap_t write_cap;
	cdio_drive_misc_cap_t  misc_cap;
	cdio_hwinfo_t hw_info;
} cdw_cdio_drive_t;


cdw_rv_t cdw_cdio_drives_init(void);
void cdw_cdio_drives_clean(void);

const char *cdw_cdio_drives_get_config_drive(void);
const char *cdw_cdio_drives_get_cdio_default_drive(void);
int cdw_cdio_drives_get_cdio_default_drive_ind(void);
int cdw_cdio_drives_get_n_drives(void);


#endif /* H_CDW_CDIO_DRIVES */

