// This file was modified for -*- C++ -*-
// using $RCSfile$ $Revision$


#line 3 "lex.vsl.c"

#define  YY_INT_ALIGNED short int

/* A lexical scanner generated by flex */

#define FLEX_SCANNER
#define YY_FLEX_MAJOR_VERSION 2
#define YY_FLEX_MINOR_VERSION 5
#define YY_FLEX_SUBMINOR_VERSION 34
#if YY_FLEX_SUBMINOR_VERSION > 0
#define FLEX_BETA
#endif

/* First, we deal with  platform-specific or compiler-specific issues. */

/* begin standard C headers. */
#include <stdio.h>
#include <string.h>
#include <errno.h>
#include <stdlib.h>

/* end standard C headers. */

/* flex integer type definitions */

#ifndef FLEXINT_H
#define FLEXINT_H

/* C99 systems have <inttypes.h>. Non-C99 systems may or may not. */

#if defined (__STDC_VERSION__) && __STDC_VERSION__ >= 199901L

/* C99 says to define __STDC_LIMIT_MACROS before including stdint.h,
 * if you want the limit (max/min) macros for int types. 
 */
#ifndef __STDC_LIMIT_MACROS
#define __STDC_LIMIT_MACROS 1
#endif

#include <inttypes.h>
typedef int8_t flex_int8_t;
typedef uint8_t flex_uint8_t;
typedef int16_t flex_int16_t;
typedef uint16_t flex_uint16_t;
typedef int32_t flex_int32_t;
typedef uint32_t flex_uint32_t;
#else
typedef signed char flex_int8_t;
typedef short int flex_int16_t;
typedef int flex_int32_t;
typedef unsigned char flex_uint8_t; 
typedef unsigned short int flex_uint16_t;
typedef unsigned int flex_uint32_t;
#endif /* ! C99 */

/* Limits of integral types. */
#ifndef INT8_MIN
#define INT8_MIN               (-128)
#endif
#ifndef INT16_MIN
#define INT16_MIN              (-32767-1)
#endif
#ifndef INT32_MIN
#define INT32_MIN              (-2147483647-1)
#endif
#ifndef INT8_MAX
#define INT8_MAX               (127)
#endif
#ifndef INT16_MAX
#define INT16_MAX              (32767)
#endif
#ifndef INT32_MAX
#define INT32_MAX              (2147483647)
#endif
#ifndef UINT8_MAX
#define UINT8_MAX              (255U)
#endif
#ifndef UINT16_MAX
#define UINT16_MAX             (65535U)
#endif
#ifndef UINT32_MAX
#define UINT32_MAX             (4294967295U)
#endif

#endif /* ! FLEXINT_H */

#ifdef __cplusplus

/* The "const" storage-class-modifier is valid. */
#define YY_USE_CONST

#else	/* ! __cplusplus */

/* C99 requires __STDC__ to be defined as 1. */
#if defined (__STDC__)

#define YY_USE_CONST

#endif	/* defined (__STDC__) */
#endif	/* ! __cplusplus */

#ifdef YY_USE_CONST
#define vslconst const
#else
#define vslconst
#endif

/* Returned upon end-of-file. */
#define YY_NULL 0

/* Promotes a possibly negative, possibly signed char to an unsigned
 * integer for use as an array index.  If the signed char is negative,
 * we want to instead treat it as an 8-bit unsigned char, hence the
 * double cast.
 */
#define YY_SC_TO_UI(c) ((unsigned int) (unsigned char) c)

/* Enter a start condition.  This macro really ought to take a parameter,
 * but we do it the disgusting crufty way forced on us by the ()-less
 * definition of BEGIN.
 */
#define BEGIN (vsl_start) = 1 + 2 *

/* Translate the current start state into a value that can be later handed
 * to BEGIN to return to the state.  The YYSTATE alias is for lex
 * compatibility.
 */
#define YY_START (((vsl_start) - 1) / 2)
#define YYSTATE YY_START

/* Action number for EOF rule of a given start state. */
#define YY_STATE_EOF(state) (YY_END_OF_BUFFER + state + 1)

/* Special action meaning "start processing a new file". */
#define YY_NEW_FILE vslrestart(vslin  )

#define YY_END_OF_BUFFER_CHAR 0

/* Size of default input buffer. */
#ifndef YY_BUF_SIZE
#define YY_BUF_SIZE 16384
#endif

/* The state buf must be large enough to hold one state per character in the main buffer.
 */
#define YY_STATE_BUF_SIZE   ((YY_BUF_SIZE + 2) * sizeof(vsl_state_type))

#ifndef YY_TYPEDEF_YY_BUFFER_STATE
#define YY_TYPEDEF_YY_BUFFER_STATE
typedef struct vsl_buffer_state *YY_BUFFER_STATE;
#endif

// extern int vslleng;

// extern FILE *vslin, *vslout;

#define EOB_ACT_CONTINUE_SCAN 0
#define EOB_ACT_END_OF_FILE 1
#define EOB_ACT_LAST_MATCH 2

    #define YY_LESS_LINENO(n)
    
/* Return all but the first "n" matched characters back to the input stream. */
#define vslless(n) \
	do \
		{ \
		/* Undo effects of setting up vsltext. */ \
        int vslless_macro_arg = (n); \
        YY_LESS_LINENO(vslless_macro_arg);\
		*vsl_cp = (vsl_hold_char); \
		YY_RESTORE_YY_MORE_OFFSET \
		(vsl_c_buf_p) = vsl_cp = vsl_bp + vslless_macro_arg - YY_MORE_ADJ; \
		YY_DO_BEFORE_ACTION; /* set up vsltext again */ \
		} \
	while ( 0 )

#define unput(c) vslunput( c, (vsltext_ptr)  )

/* The following is because we cannot portably get our hands on size_t
 * (without autoconf's help, which isn't available because we want
 * flex-generated scanners to compile on their own).
 * Given that the standard has decreed that size_t exists since 1989,
 * I guess we can afford to depend on it. Manoj.
 */

#ifndef YY_TYPEDEF_YY_SIZE_T
#define YY_TYPEDEF_YY_SIZE_T
typedef size_t vsl_size_t;
#endif

#ifndef YY_STRUCT_YY_BUFFER_STATE
#define YY_STRUCT_YY_BUFFER_STATE
struct vsl_buffer_state
	{
	FILE *vsl_input_file;

	char *vsl_ch_buf;		/* input buffer */
	char *vsl_buf_pos;		/* current position in input buffer */

	/* Size of input buffer in bytes, not including room for EOB
	 * characters.
	 */
	vsl_size_t vsl_buf_size;

	/* Number of characters read into vsl_ch_buf, not including EOB
	 * characters.
	 */
	int vsl_n_chars;

	/* Whether we "own" the buffer - i.e., we know we created it,
	 * and can realloc() it to grow it, and should free() it to
	 * delete it.
	 */
	int vsl_is_our_buffer;

	/* Whether this is an "interactive" input source; if so, and
	 * if we're using stdio for input, then we want to use getc()
	 * instead of fread(), to make sure we stop fetching input after
	 * each newline.
	 */
	int vsl_is_interactive;

	/* Whether we're considered to be at the beginning of a line.
	 * If so, '^' rules will be active on the next match, otherwise
	 * not.
	 */
	int vsl_at_bol;

    int vsl_bs_lineno; /**< The line count. */
    int vsl_bs_column; /**< The column count. */
    
	/* Whether to try to fill the input buffer when we reach the
	 * end of it.
	 */
	int vsl_fill_buffer;

	int vsl_buffer_status;

#define YY_BUFFER_NEW 0
#define YY_BUFFER_NORMAL 1
	/* When an EOF's been seen but there's still some text to process
	 * then we mark the buffer as YY_EOF_PENDING, to indicate that we
	 * shouldn't try reading from the input source any more.  We might
	 * still have a bunch of tokens to match, though, because of
	 * possible backing-up.
	 *
	 * When we actually see the EOF, we change the status to "new"
	 * (via vslrestart()), so that the user can continue scanning by
	 * just pointing vslin at a new input file.
	 */
#define YY_BUFFER_EOF_PENDING 2

	};
#endif /* !YY_STRUCT_YY_BUFFER_STATE */

/* Stack of input buffers. */
static size_t vsl_buffer_stack_top = 0; /**< index of top of stack. */
static size_t vsl_buffer_stack_max = 0; /**< capacity of stack. */
static YY_BUFFER_STATE * vsl_buffer_stack = 0; /**< Stack as an array. */

/* We provide macros for accessing buffer states in case in the
 * future we want to put the buffer states in a more general
 * "scanner state".
 *
 * Returns the top of the stack, or NULL.
 */
#define YY_CURRENT_BUFFER ( (vsl_buffer_stack) \
                          ? (vsl_buffer_stack)[(vsl_buffer_stack_top)] \
                          : NULL)

/* Same as previous macro, but useful when we know that the buffer stack is not
 * NULL or when we need an lvalue. For internal use only.
 */
#define YY_CURRENT_BUFFER_LVALUE (vsl_buffer_stack)[(vsl_buffer_stack_top)]

/* vsl_hold_char holds the character lost when vsltext is formed. */
static char vsl_hold_char;
static int vsl_n_chars;		/* number of characters read into vsl_ch_buf */
int vslleng;

/* Points to current character in buffer. */
static char *vsl_c_buf_p = (char *) 0;
static int vsl_init = 0;		/* whether we need to initialize */
static int vsl_start = 0;	/* start state number */

/* Flag which is used to allow vslwrap()'s to do buffer switches
 * instead of setting up a fresh vslin.  A bit of a hack ...
 */
static int vsl_did_buffer_switch_on_eof;

void vslrestart (FILE *input_file  );
void vsl_switch_to_buffer (YY_BUFFER_STATE new_buffer  );
YY_BUFFER_STATE vsl_create_buffer (FILE *file,int size  );
void vsl_delete_buffer (YY_BUFFER_STATE b  );
void vsl_flush_buffer (YY_BUFFER_STATE b  );
void vslpush_buffer_state (YY_BUFFER_STATE new_buffer  );
void vslpop_buffer_state (void );

static void vslensure_buffer_stack (void );
static void vsl_load_buffer_state (void );
static void vsl_init_buffer (YY_BUFFER_STATE b,FILE *file  );

#define YY_FLUSH_BUFFER vsl_flush_buffer(YY_CURRENT_BUFFER )

YY_BUFFER_STATE vsl_scan_buffer (char *base,vsl_size_t size  );
YY_BUFFER_STATE vsl_scan_string (vslconst char *vsl_str  );
YY_BUFFER_STATE vsl_scan_bytes (vslconst char *bytes,int len  );

void *vslalloc (vsl_size_t  );
void *vslrealloc (void *,vsl_size_t  );
void vslfree (void *  );

#define vsl_new_buffer vsl_create_buffer

#define vsl_set_interactive(is_interactive) \
	{ \
	if ( ! YY_CURRENT_BUFFER ){ \
        vslensure_buffer_stack (); \
		YY_CURRENT_BUFFER_LVALUE =    \
            vsl_create_buffer(vslin,YY_BUF_SIZE ); \
	} \
	YY_CURRENT_BUFFER_LVALUE->vsl_is_interactive = is_interactive; \
	}

#define vsl_set_bol(at_bol) \
	{ \
	if ( ! YY_CURRENT_BUFFER ){\
        vslensure_buffer_stack (); \
		YY_CURRENT_BUFFER_LVALUE =    \
            vsl_create_buffer(vslin,YY_BUF_SIZE ); \
	} \
	YY_CURRENT_BUFFER_LVALUE->vsl_at_bol = at_bol; \
	}

#define YY_AT_BOL() (YY_CURRENT_BUFFER_LVALUE->vsl_at_bol)

/* Begin user sect3 */

typedef unsigned char YY_CHAR;

FILE *vslin = (FILE *) 0, *vslout = (FILE *) 0;

typedef int vsl_state_type;

extern int vsllineno;

int vsllineno = 1;

// extern char *vsltext;
#define vsltext_ptr vsltext

static vsl_state_type vsl_get_previous_state (void );
static vsl_state_type vsl_try_NUL_trans (vsl_state_type current_state  );
static int vsl_get_next_buffer (void );
static void vsl_fatal_error (vslconst char msg[]  );

/* Done after the current pattern has been matched and before the
 * corresponding action - sets up vsltext.
 */
#define YY_DO_BEFORE_ACTION \
	(vsltext_ptr) = vsl_bp; \
	vslleng = (size_t) (vsl_cp - vsl_bp); \
	(vsl_hold_char) = *vsl_cp; \
	*vsl_cp = '\0'; \
	(vsl_c_buf_p) = vsl_cp;

#define YY_NUM_RULES 44
#define YY_END_OF_BUFFER 45
/* This struct is not used in this scanner,
   but its presence is necessary. */
struct vsl_trans_info
	{
	flex_int32_t vsl_verify;
	flex_int32_t vsl_nxt;
	};
static vslconst flex_int16_t vsl_accept[149] =
    {   0,
       41,   41,   45,   43,   41,   42,   43,   29,   43,   43,
       43,   40,   28,   37,   33,   35,   25,   31,   25,   25,
       25,   25,   25,   25,   25,   25,   25,   30,   32,   41,
       43,   41,    0,    1,    0,   26,    0,    3,    2,   40,
       27,   38,   34,   36,   25,   25,   25,   18,   14,   23,
       25,   25,   19,   25,   25,   41,    0,    0,    4,    0,
        0,    0,    0,    0,    0,    0,    1,    0,   39,    2,
       20,   25,   22,   21,   25,   25,    4,    0,    0,    0,
        0,    0,    0,   16,   25,   15,   25,    0,    0,    0,
        0,    0,    0,   17,   24,    0,    0,    0,    0,    0,

        0,    0,    7,    0,    0,    0,    9,    0,    7,    7,
        0,    0,    0,    0,    0,    0,    0,    0,    0,   10,
        0,    0,    0,    8,    0,    0,    0,    0,    5,    0,
        6,    0,    0,    0,    5,    6,    0,    0,    0,    0,
        0,   12,    0,    0,    0,   13,   11,    0
    } ;

static vslconst flex_int32_t vsl_ec[256] =
    {   0,
        1,    1,    1,    1,    1,    1,    1,    1,    2,    3,
        1,    2,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    2,    4,    5,    6,    1,    1,    7,    1,    1,
        1,    8,    1,    1,    9,   10,   11,   12,   12,   12,
       12,   12,   12,   12,   12,   12,   12,   13,    1,   14,
       15,   16,    1,    1,   17,   17,   17,   17,   17,   17,
       17,   17,   17,   17,   17,   17,   17,   17,   17,   17,
       17,   17,   17,   17,   17,   17,   17,   17,   17,   17,
        1,   18,    1,   19,   17,    1,   20,   17,   21,   22,

       23,   24,   25,   26,   27,   17,   17,   28,   29,   30,
       31,   32,   17,   33,   34,   35,   36,   37,   38,   17,
       17,   17,    1,   39,    1,   40,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,

        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1
    } ;

static vslconst flex_int32_t vsl_meta[41] =
    {   0,
        1,    1,    2,    1,    1,    1,    1,    1,    1,    1,
        1,    3,    1,    1,    1,    1,    3,    1,    1,    3,
        3,    3,    3,    3,    3,    3,    3,    3,    3,    3,
        3,    3,    3,    3,    3,    3,    3,    3,    1,    1
    } ;

static vslconst flex_int16_t vsl_base[159] =
    {   0,
        0,   39,  191,  192,  188,  192,   37,  192,  173,  178,
       35,  175,  173,   32,  192,  170,    0,  192,  154,  155,
      155,   20,  158,  149,  146,  152,  151,  192,  192,   47,
       54,  174,   46,  192,   47,  192,  165,  192,    0,  162,
      192,  192,  192,  192,    0,  151,  138,    0,    0,    0,
      136,  135,    0,  146,  145,   55,    0,  163,    0,  136,
      138,  127,  130,  139,  131,   49,   54,   55,  192,    0,
        0,   39,    0,    0,  130,  126,    0,  137,  127,  133,
      135,  122,  131,    0,  128,    0,  128,  122,  126,  115,
      122,  118,  122,    0,    0,  108,  141,  109,  112,  120,

      115,  116,  135,  109,  115,  113,  192,  110,    0,  130,
      109,   61,  106,   66,  103,   67,   86,   97,   87,  192,
       74,  109,   95,  192,   85,   73,   80,   96,    0,   83,
        0,   63,   67,   70,    0,    0,   58,   69,   60,   56,
       57,  192,   55,   52,   51,  192,  192,  192,  103,   67,
      106,  109,  112,  115,  118,  121,  124,  127
    } ;

static vslconst flex_int16_t vsl_def[159] =
    {   0,
      148,    1,  148,  148,  148,  148,  149,  148,  148,  148,
      148,  148,  148,  148,  148,  148,  150,  148,  150,  150,
      150,  150,  150,  150,  150,  150,  150,  148,  148,  148,
      148,  148,  149,  148,  151,  148,  148,  148,  152,  148,
      148,  148,  148,  148,  150,  150,  150,  150,  150,  150,
      150,  150,  150,  150,  150,  148,   31,   31,  153,  148,
      148,  148,  148,  148,  148,  149,  149,  151,  148,  152,
      150,  150,  150,  150,  150,  150,  153,  148,  148,  148,
      148,  148,  148,  150,  150,  150,  150,  148,  148,  148,
      148,  148,  148,  150,  150,  148,  148,  148,  148,  148,

      148,  148,  154,  148,  148,  148,  148,  148,  154,  154,
      148,  148,  148,  148,  148,  148,  148,  148,  148,  148,
      148,  155,  156,  148,  148,  148,  148,  155,  157,  156,
      158,  148,  148,  148,  157,  158,  148,  148,  148,  148,
      148,  148,  148,  148,  148,  148,  148,    0,  148,  148,
      148,  148,  148,  148,  148,  148,  148,  148
    } ;

static vslconst flex_int16_t vsl_nxt[233] =
    {   0,
        4,    5,    6,    4,    7,    4,    8,    4,    9,   10,
       11,   12,   13,   14,   15,   16,   17,    4,   18,   19,
       17,   17,   20,   21,   17,   17,   22,   23,   17,   24,
       25,   17,   17,   17,   26,   17,   17,   27,   28,   29,
       30,   34,   38,   49,   31,   39,   42,   43,   56,   50,
       34,   67,   57,   34,   35,   58,   56,   59,   34,   67,
       57,   84,  116,   35,   68,   85,   35,  121,  116,   45,
      122,   35,   68,  147,  146,  121,  145,  144,  122,  123,
       60,   61,  143,  142,   62,   63,   64,  123,  141,   65,
      140,  117,  139,  118,  138,  137,  119,  117,  131,  118,

      129,  134,  119,   33,  133,   33,   66,  132,   66,   70,
      131,   70,   77,  129,   77,  109,  127,  109,  128,  126,
      128,  130,  125,  130,  135,  124,  135,  136,  120,  136,
      115,  110,  114,  113,  112,  111,  110,  108,  107,  106,
      105,  104,  103,  102,  101,  100,   99,   98,   97,   96,
       95,   94,   93,   92,   91,   90,   89,   88,   87,   86,
       83,   82,   81,   80,   79,   78,  148,   76,   75,   74,
       73,   72,   71,   40,   69,   32,   55,   54,   53,   52,
       51,   48,   47,   46,   44,   41,   40,   37,   36,   32,
      148,    3,  148,  148,  148,  148,  148,  148,  148,  148,

      148,  148,  148,  148,  148,  148,  148,  148,  148,  148,
      148,  148,  148,  148,  148,  148,  148,  148,  148,  148,
      148,  148,  148,  148,  148,  148,  148,  148,  148,  148,
      148,  148
    } ;

static vslconst flex_int16_t vsl_chk[233] =
    {   0,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        2,    7,   11,   22,    2,   11,   14,   14,   30,   22,
       33,   35,   30,   66,    7,   31,   56,   31,   67,   68,
       56,   72,  112,   33,   35,   72,   66,  114,  116,  150,
      114,   67,   68,  145,  144,  121,  143,  141,  121,  114,
       31,   31,  140,  139,   31,   31,   31,  121,  138,   31,
      137,  112,  134,  112,  133,  132,  112,  116,  130,  116,

      128,  127,  116,  149,  126,  149,  151,  125,  151,  152,
      123,  152,  153,  122,  153,  154,  119,  154,  155,  118,
      155,  156,  117,  156,  157,  115,  157,  158,  113,  158,
      111,  110,  108,  106,  105,  104,  103,  102,  101,  100,
       99,   98,   97,   96,   93,   92,   91,   90,   89,   88,
       87,   85,   83,   82,   81,   80,   79,   78,   76,   75,
       65,   64,   63,   62,   61,   60,   58,   55,   54,   52,
       51,   47,   46,   40,   37,   32,   27,   26,   25,   24,
       23,   21,   20,   19,   16,   13,   12,   10,    9,    5,
        3,  148,  148,  148,  148,  148,  148,  148,  148,  148,

      148,  148,  148,  148,  148,  148,  148,  148,  148,  148,
      148,  148,  148,  148,  148,  148,  148,  148,  148,  148,
      148,  148,  148,  148,  148,  148,  148,  148,  148,  148,
      148,  148
    } ;

static vsl_state_type vsl_last_accepting_state;
static char *vsl_last_accepting_cpos;

extern int vsl_flex_debug;
int vsl_flex_debug = 0;

/* The intent behind this definition is that it'll catch
 * any uses of REJECT which flex missed.
 */
#define REJECT reject_used_but_not_detected
#define vslmore() vslmore_used_but_not_detected
#define YY_MORE_ADJ 0
#define YY_RESTORE_YY_MORE_OFFSET
char *vsltext;
#line 1 "./vsl-lex.L"
/* $Id$ -*- C++ -*- */
/* VSL lexical analysis */
#line 5 "./vsl-lex.L"
// Copyright (C) 1995 Technische Universitaet Braunschweig, Germany.
// Written by Andreas Zeller <zeller@gnu.org>.
// 
// This file is part of DDD.
// 
// DDD is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public
// License as published by the Free Software Foundation; either
// version 3 of the License, or (at your option) any later version.
// 
// DDD is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
// See the GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public
// License along with DDD -- see the file COPYING.
// If not, see <http://www.gnu.org/licenses/>.
// 
// DDD is the data display debugger.
// For details, see the DDD World-Wide-Web page, 
// `http://www.gnu.org/software/ddd/',
// or send a mail to the DDD developers <ddd@gnu.org>.

char VSL_lex_rcsid[] = 
    "$Id$";

// Define BAD_ISTREAM != 0, if istream::open() aborts upon
// non-existing file
#define BAD_ISTREAM 1

#include <stdio.h>
#include <errno.h>
#include "strclass.h"
#include "casts.h"

static const int max_include_nesting = 40;    // max include nesting

static std::istream *streamstack[max_include_nesting]; // File descriptors
static string	namestack[max_include_nesting];	   // File names
static int	linestack[max_include_nesting];	   // File lines
static int	topstack = 0;			   // Next free position

#ifdef FLEX_SCANNER
static YY_BUFFER_STATE bufstack[max_include_nesting]; // Buffer states
#endif

static std::istream *vslstream = &std::cin;

static int vsllinenumber;

static int switchdown(void);
//static int switchup(const char *filename, bool thisdir);

static char pushback[BUFSIZ];
static char *pushback_ptr = pushback;

static const char *searchpath(const char *filename, bool thisDir);

class vslNameSet {
private:
    string _name;
    vslNameSet *_next;

public:
    vslNameSet(const char *name)
	: _name(name), _next(0)
    {}
    ~vslNameSet()	   { reset(); }
    void reset();
    int add(const char *name);

private:
    vslNameSet(const vslNameSet&);
    vslNameSet& operator = (const vslNameSet&);
} vslnameSet("xyzzy");

inline int do_unput(char c) 
{
    if (c != '\0')
	*pushback_ptr++ = c;

    return c;
}

static int do_input(void) 
{
    if (pushback_ptr != pushback)
	return *--pushback_ptr;

    char c;

    vslstream->get(c);
    if (vslstream->eof())
	return 0;

    if (c == '\n')
	vsllinenumber++;
    return c;
}

// Switch to file FILENAME
static int switchup(const char *filename, bool thisdir) 
{
    if (!string(filename).empty())
    {
	// Search file
	filename = searchpath(filename, thisdir);

	// Add to name set; if we already have read it, don't care
	if (vslnameSet.add(filename))
	    return 0;
    }

    if (topstack >= max_include_nesting)
    {
	VSLLib::parse_error("too many #include's");
	return -1;
    }

#ifdef FLEX_SCANNER
    if (YY_CURRENT_BUFFER == 0)
    {
	vslrestart(stdin);
    }

    bufstack[topstack]	  = YY_CURRENT_BUFFER;
#endif

    streamstack[topstack] = vslstream;
    namestack[topstack]	  = vslfilename;
    linestack[topstack]	  = vsllinenumber;
    topstack++;

    vsllinenumber = 1;
    vslfilename = filename;

#ifdef FLEX_SCANNER
    vsl_switch_to_buffer(vsl_new_buffer(stdin, YY_BUF_SIZE));
#endif

    if (string(filename) == "")
    {
	vslstream   = &std::cin;
	vslfilename = "standard input";
    }
    else
    {
#if BAD_ISTREAM
    vslstream = 0;
    FILE *fp = fopen(filename, "r");
    if (fp == 0 || fclose(fp) == EOF) 
    {
#else
    vslstream = new ifstream(filename, ios::in);
    if (!vslstream->readable()) 
    {
#endif
	switchdown();
	VSLLib::parse_error(string(filename) + ": " + strerror(errno));
	return -1;
    }

#if BAD_ISTREAM
    // vslstream can now be opened
    vslstream = new std::ifstream(filename, std::ios::in);
#endif
    }

    if (VSEFlags::verbose)
    {
	std::cout << "(" << vslfilename;
	std::cout.flush();
    }

    return 0;
}

// The way SUN lex wants input
#ifdef input
#undef input
#define input do_input
#endif

#ifdef unput
#undef unput
#define unput do_unput
#endif

// The way FLEX wants input
#ifdef FLEX_SCANNER
#undef YY_INPUT
#define YY_INPUT(buf, result, max_size) \
{\
    int c = do_input(); \
    result = (c == '\0') ? YY_NULL : (buf[0] = c, 1); \
}
#endif

#undef vslwrap
#define YY_SKIP_YYWRAP
extern "C" int vslwrap(void) 
{ 
    if (switchdown())
	return 1;
    return vslstream->eof();
}


// Anything not in the list is a single character
#ifdef ECHO
#undef ECHO
#endif
#define ECHO                 return vsltext[0]


#ifdef FLEX_SCANNER
// #defining YY_BREAK to empty disables warnings about unreachable breaks.
#define YY_BREAK DO_NOT_BREAK
#define DO_NOT_BREAK
#define BREAK break;
#endif // FLEX_SCANNER

/* C Identifiers */
/* C Strings */
/* C Integers */
/* #include Strings */
/* Whitespace */
#line 787 "lex.vsl.c"

#define INITIAL 0

#ifndef YY_NO_UNISTD_H
/* Special case for "unistd.h", since it is non-ANSI. We include it way
 * down here because we want the user's section 1 to have been scanned first.
 * The user has a chance to override it with an option.
 */
#include <unistd.h>
#endif

#ifndef YY_EXTRA_TYPE
#define YY_EXTRA_TYPE void *
#endif

static int vsl_init_globals (void );

/* Macros after this point can all be overridden by user definitions in
 * section 1.
 */

#ifndef YY_SKIP_YYWRAP
#ifdef __cplusplus
extern "C" int vslwrap (void );
#else
extern int vslwrap (void );
#endif
#endif

    static void vslunput (int c,char *buf_ptr  );
    
#ifndef vsltext_ptr
static void vsl_flex_strncpy (char *,vslconst char *,int );
#endif

#ifdef YY_NEED_STRLEN
static int vsl_flex_strlen (vslconst char * );
#endif

#ifndef YY_NO_INPUT

#ifdef __cplusplus
static int vslinput (void );
#else
static int input (void );
#endif

#endif

/* Amount of stuff to slurp up with each read. */
#ifndef YY_READ_BUF_SIZE
#define YY_READ_BUF_SIZE 8192
#endif

/* Copy whatever the last rule matched to the standard output. */
#ifndef ECHO
/* This used to be an fputs(), but since the string might contain NUL's,
 * we now use fwrite().
 */
#define ECHO fwrite( vsltext, vslleng, 1, vslout )
#endif

/* Gets input and stuffs it into "buf".  number of characters read, or YY_NULL,
 * is returned in "result".
 */
#ifndef YY_INPUT
#define YY_INPUT(buf,result,max_size) \
	if ( YY_CURRENT_BUFFER_LVALUE->vsl_is_interactive ) \
		{ \
		int c = '*'; \
		int n; \
		for ( n = 0; n < max_size && \
			     (c = getc( vslin )) != EOF && c != '\n'; ++n ) \
			buf[n] = (char) c; \
		if ( c == '\n' ) \
			buf[n++] = (char) c; \
		if ( c == EOF && ferror( vslin ) ) \
			YY_FATAL_ERROR( "input in flex scanner failed" ); \
		result = n; \
		} \
	else \
		{ \
		errno=0; \
		while ( (result = fread(buf, 1, max_size, vslin))==0 && ferror(vslin)) \
			{ \
			if( errno != EINTR) \
				{ \
				YY_FATAL_ERROR( "input in flex scanner failed" ); \
				break; \
				} \
			errno=0; \
			clearerr(vslin); \
			} \
		}\
\

#endif

/* No semi-colon after return; correct usage is to write "vslterminate();" -
 * we don't want an extra ';' after the "return" because that will cause
 * some compilers to complain about unreachable statements.
 */
#ifndef vslterminate
#define vslterminate() return YY_NULL
#endif

/* Number of entries by which start-condition stack grows. */
#ifndef YY_START_STACK_INCR
#define YY_START_STACK_INCR 25
#endif

/* Report a fatal error. */
#ifndef YY_FATAL_ERROR
#define YY_FATAL_ERROR(msg) vsl_fatal_error( msg )
#endif

/* end tables serialization structures and prototypes */

/* Default declaration of generated scanner - a define so the user can
 * easily add parameters.
 */
#ifndef YY_DECL
#define YY_DECL_IS_OURS 1

extern int vsllex (void);

#define YY_DECL int vsllex (void)
#endif /* !YY_DECL */

/* Code executed at the beginning of each rule, after vsltext and vslleng
 * have been set up.
 */
#ifndef YY_USER_ACTION
#define YY_USER_ACTION
#endif

/* Code executed at the end of each rule. */
#ifndef YY_BREAK
#define YY_BREAK break;
#endif

#define YY_RULE_SETUP \
	if ( vslleng > 0 ) \
		YY_CURRENT_BUFFER_LVALUE->vsl_at_bol = \
				(vsltext[vslleng - 1] == '\n'); \
	YY_USER_ACTION

/** The main scanner function which does all the work.
 */
YY_DECL
{
	register vsl_state_type vsl_current_state;
	register char *vsl_cp, *vsl_bp;
	register int vsl_act;
    
#line 246 "./vsl-lex.L"


#line 946 "lex.vsl.c"

	if ( !(vsl_init) )
		{
		(vsl_init) = 1;

#ifdef YY_USER_INIT
		YY_USER_INIT;
#endif

		if ( ! (vsl_start) )
			(vsl_start) = 1;	/* first start state */

		if ( ! vslin )
			vslin = stdin;

		if ( ! vslout )
			vslout = stdout;

		if ( ! YY_CURRENT_BUFFER ) {
			vslensure_buffer_stack ();
			YY_CURRENT_BUFFER_LVALUE =
				vsl_create_buffer(vslin,YY_BUF_SIZE );
		}

		vsl_load_buffer_state( );
		}

	while ( 1 )		/* loops until end-of-file is reached */
		{
		vsl_cp = (vsl_c_buf_p);

		/* Support of vsltext. */
		*vsl_cp = (vsl_hold_char);

		/* vsl_bp points to the position in vsl_ch_buf of the start of
		 * the current run.
		 */
		vsl_bp = vsl_cp;

		vsl_current_state = (vsl_start);
		vsl_current_state += YY_AT_BOL();
vsl_match:
		do
			{
			register YY_CHAR vsl_c = vsl_ec[YY_SC_TO_UI(*vsl_cp)];
			if ( vsl_accept[vsl_current_state] )
				{
				(vsl_last_accepting_state) = vsl_current_state;
				(vsl_last_accepting_cpos) = vsl_cp;
				}
			while ( vsl_chk[vsl_base[vsl_current_state] + vsl_c] != vsl_current_state )
				{
				vsl_current_state = (int) vsl_def[vsl_current_state];
				if ( vsl_current_state >= 149 )
					vsl_c = vsl_meta[(unsigned int) vsl_c];
				}
			vsl_current_state = vsl_nxt[vsl_base[vsl_current_state] + (unsigned int) vsl_c];
			++vsl_cp;
			}
		while ( vsl_base[vsl_current_state] != 192 );

vsl_find_action:
		vsl_act = vsl_accept[vsl_current_state];
		if ( vsl_act == 0 )
			{ /* have to back up */
			vsl_cp = (vsl_last_accepting_cpos);
			vsl_current_state = (vsl_last_accepting_state);
			vsl_act = vsl_accept[vsl_current_state];
			}

		YY_DO_BEFORE_ACTION;

do_action:	/* This label is used only to access EOF actions. */

		switch ( vsl_act )
	{ /* beginning of action switch */
			case 0: /* must back up */
			/* undo the effects of YY_DO_BEFORE_ACTION */
			*vsl_cp = (vsl_hold_char);
			vsl_cp = (vsl_last_accepting_cpos);
			vsl_current_state = (vsl_last_accepting_state);
			goto vsl_find_action;

case 1:
YY_RULE_SETUP
#line 248 "./vsl-lex.L"
return VSL_STRING;		// string
	YY_BREAK
case 2:
YY_RULE_SETUP
#line 250 "./vsl-lex.L"
BREAK				// C++ comment
	YY_BREAK
case 3:
YY_RULE_SETUP
#line 251 "./vsl-lex.L"
{				// C comment
			// aus `man lex`
			loop:
			while (vslinput() != '*');
			switch (vslinput())
				{
				case '/': break;
				case '*': unput('*');
				default : goto loop;
				}
			BREAK
		}
	YY_BREAK
case 4:
YY_RULE_SETUP
#line 263 "./vsl-lex.L"
BREAK			// Unix exec() tag
	YY_BREAK
case 5:
YY_RULE_SETUP
#line 265 "./vsl-lex.L"
{			// #include "..."
			char buf[BUFSIZ];
			strcpy(buf, (char *)vsltext);
			char *start = buf;
			while (*start != '\"') 
				start++;
			char *end = ++start;
			while (*end != '\"') 
				end++;
			*end = '\0';
			switchup(start, true);
			BREAK
		}
	YY_BREAK
case 6:
YY_RULE_SETUP
#line 278 "./vsl-lex.L"
{			// #include <...>
			char buf[BUFSIZ];
			strcpy(buf, (char *)vsltext);
			char *start = buf;
			while (*start != '<') 
				start++;
			char *end = ++start;
			while (*end != '>') 
				end++;
			*end = '\0';
			switchup(start, false);
			BREAK
		}
	YY_BREAK
case 7:
YY_RULE_SETUP
#line 291 "./vsl-lex.L"
{			// #line LINE ["FILE"]
			string buf((char *)vsltext);
			buf = buf.after("line");
			char *s = CONST_CAST(char *,buf.chars());
			int line = strtol(s, &s, 10);
			if (s == buf.chars())
			    VSLLib::parse_error("illegal #line number");
			else
			    vsllinenumber = line;

			buf = buf.after('"');
			if (!buf.empty())
			{
			    buf = buf.before('"');
			    if (buf == "")
				VSLLib::parse_error("illegal #line file");
			    else
				vslfilename = uncook(buf);
			}
			BREAK
		}
	YY_BREAK
case 8:
YY_RULE_SETUP
#line 313 "./vsl-lex.L"
return OVERRIDE;		// Other manipulators
	YY_BREAK
case 9:
YY_RULE_SETUP
#line 314 "./vsl-lex.L"
return OVERRIDE;
	YY_BREAK
case 10:
YY_RULE_SETUP
#line 315 "./vsl-lex.L"
return REPLACE;
	YY_BREAK
case 11:
YY_RULE_SETUP
#line 316 "./vsl-lex.L"
return OVERRIDE;	// Other manipulators
	YY_BREAK
case 12:
YY_RULE_SETUP
#line 317 "./vsl-lex.L"
return OVERRIDE;
	YY_BREAK
case 13:
YY_RULE_SETUP
#line 318 "./vsl-lex.L"
return REPLACE;
	YY_BREAK
case 14:
YY_RULE_SETUP
#line 320 "./vsl-lex.L"
return IF;			// Tokens
	YY_BREAK
case 15:
YY_RULE_SETUP
#line 321 "./vsl-lex.L"
return THEN;
	YY_BREAK
case 16:
YY_RULE_SETUP
#line 322 "./vsl-lex.L"
return ELSE;
	YY_BREAK
case 17:
YY_RULE_SETUP
#line 323 "./vsl-lex.L"
return ELSIF;
	YY_BREAK
case 18:
YY_RULE_SETUP
#line 324 "./vsl-lex.L"
return FI;
	YY_BREAK
case 19:
YY_RULE_SETUP
#line 325 "./vsl-lex.L"
return OR;
	YY_BREAK
case 20:
YY_RULE_SETUP
#line 326 "./vsl-lex.L"
return AND;
	YY_BREAK
case 21:
YY_RULE_SETUP
#line 327 "./vsl-lex.L"
return NOT;
	YY_BREAK
case 22:
YY_RULE_SETUP
#line 328 "./vsl-lex.L"
return LET;
	YY_BREAK
case 23:
YY_RULE_SETUP
#line 329 "./vsl-lex.L"
return IN;
	YY_BREAK
case 24:
YY_RULE_SETUP
#line 330 "./vsl-lex.L"
return WHERE;
	YY_BREAK
case 25:
YY_RULE_SETUP
#line 331 "./vsl-lex.L"
return IDENTIFIER;
	YY_BREAK
case 26:
YY_RULE_SETUP
#line 333 "./vsl-lex.L"
return ARROW;
	YY_BREAK
case 27:
YY_RULE_SETUP
#line 334 "./vsl-lex.L"
return CONS;
	YY_BREAK
case 28:
YY_RULE_SETUP
#line 335 "./vsl-lex.L"
return APPEND;
	YY_BREAK
case 29:
YY_RULE_SETUP
#line 336 "./vsl-lex.L"
return HALIGN;
	YY_BREAK
case 30:
YY_RULE_SETUP
#line 337 "./vsl-lex.L"
return VALIGN;
	YY_BREAK
case 31:
YY_RULE_SETUP
#line 338 "./vsl-lex.L"
return UALIGN;
	YY_BREAK
case 32:
YY_RULE_SETUP
#line 339 "./vsl-lex.L"
return TALIGN;
	YY_BREAK
case 33:
YY_RULE_SETUP
#line 340 "./vsl-lex.L"
return EQ;
	YY_BREAK
case 34:
YY_RULE_SETUP
#line 341 "./vsl-lex.L"
return NE;
	YY_BREAK
case 35:
YY_RULE_SETUP
#line 342 "./vsl-lex.L"
return GT;
	YY_BREAK
case 36:
YY_RULE_SETUP
#line 343 "./vsl-lex.L"
return GE;
	YY_BREAK
case 37:
YY_RULE_SETUP
#line 344 "./vsl-lex.L"
return LT;
	YY_BREAK
case 38:
YY_RULE_SETUP
#line 345 "./vsl-lex.L"
return LE;
	YY_BREAK
case 39:
YY_RULE_SETUP
#line 347 "./vsl-lex.L"
return THREEDOTS;
	YY_BREAK
case 40:
YY_RULE_SETUP
#line 349 "./vsl-lex.L"
return INTEGER;
	YY_BREAK
case 41:
YY_RULE_SETUP
#line 351 "./vsl-lex.L"
BREAK				// Whitespace (ignore)
	YY_BREAK
case 42:
/* rule 42 can match eol */
YY_RULE_SETUP
#line 352 "./vsl-lex.L"
BREAK				// Likewise
	YY_BREAK
case 43:
YY_RULE_SETUP
#line 353 "./vsl-lex.L"
return vsltext[0];		// All other characters
	YY_BREAK
case 44:
YY_RULE_SETUP
#line 354 "./vsl-lex.L"
ECHO;
	YY_BREAK
#line 1306 "lex.vsl.c"
case YY_STATE_EOF(INITIAL):
	vslterminate();

	case YY_END_OF_BUFFER:
		{
		/* Amount of text matched not including the EOB char. */
		int vsl_amount_of_matched_text = (int) (vsl_cp - (vsltext_ptr)) - 1;

		/* Undo the effects of YY_DO_BEFORE_ACTION. */
		*vsl_cp = (vsl_hold_char);
		YY_RESTORE_YY_MORE_OFFSET

		if ( YY_CURRENT_BUFFER_LVALUE->vsl_buffer_status == YY_BUFFER_NEW )
			{
			/* We're scanning a new file or input source.  It's
			 * possible that this happened because the user
			 * just pointed vslin at a new source and called
			 * vsllex().  If so, then we have to assure
			 * consistency between YY_CURRENT_BUFFER and our
			 * globals.  Here is the right place to do so, because
			 * this is the first action (other than possibly a
			 * back-up) that will match for the new input source.
			 */
			(vsl_n_chars) = YY_CURRENT_BUFFER_LVALUE->vsl_n_chars;
			YY_CURRENT_BUFFER_LVALUE->vsl_input_file = vslin;
			YY_CURRENT_BUFFER_LVALUE->vsl_buffer_status = YY_BUFFER_NORMAL;
			}

		/* Note that here we test for vsl_c_buf_p "<=" to the position
		 * of the first EOB in the buffer, since vsl_c_buf_p will
		 * already have been incremented past the NUL character
		 * (since all states make transitions on EOB to the
		 * end-of-buffer state).  Contrast this with the test
		 * in input().
		 */
		if ( (vsl_c_buf_p) <= &YY_CURRENT_BUFFER_LVALUE->vsl_ch_buf[(vsl_n_chars)] )
			{ /* This was really a NUL. */
			vsl_state_type vsl_next_state;

			(vsl_c_buf_p) = (vsltext_ptr) + vsl_amount_of_matched_text;

			vsl_current_state = vsl_get_previous_state(  );

			/* Okay, we're now positioned to make the NUL
			 * transition.  We couldn't have
			 * vsl_get_previous_state() go ahead and do it
			 * for us because it doesn't know how to deal
			 * with the possibility of jamming (and we don't
			 * want to build jamming into it because then it
			 * will run more slowly).
			 */

			vsl_next_state = vsl_try_NUL_trans( vsl_current_state );

			vsl_bp = (vsltext_ptr) + YY_MORE_ADJ;

			if ( vsl_next_state )
				{
				/* Consume the NUL. */
				vsl_cp = ++(vsl_c_buf_p);
				vsl_current_state = vsl_next_state;
				goto vsl_match;
				}

			else
				{
				vsl_cp = (vsl_c_buf_p);
				goto vsl_find_action;
				}
			}

		else switch ( vsl_get_next_buffer(  ) )
			{
			case EOB_ACT_END_OF_FILE:
				{
				(vsl_did_buffer_switch_on_eof) = 0;

				if ( vslwrap( ) )
					{
					/* Note: because we've taken care in
					 * vsl_get_next_buffer() to have set up
					 * vsltext, we can now set up
					 * vsl_c_buf_p so that if some total
					 * hoser (like flex itself) wants to
					 * call the scanner after we return the
					 * YY_NULL, it'll still work - another
					 * YY_NULL will get returned.
					 */
					(vsl_c_buf_p) = (vsltext_ptr) + YY_MORE_ADJ;

					vsl_act = YY_STATE_EOF(YY_START);
					goto do_action;
					}

				else
					{
					if ( ! (vsl_did_buffer_switch_on_eof) )
						YY_NEW_FILE;
					}
				break;
				}

			case EOB_ACT_CONTINUE_SCAN:
				(vsl_c_buf_p) =
					(vsltext_ptr) + vsl_amount_of_matched_text;

				vsl_current_state = vsl_get_previous_state(  );

				vsl_cp = (vsl_c_buf_p);
				vsl_bp = (vsltext_ptr) + YY_MORE_ADJ;
				goto vsl_match;

			case EOB_ACT_LAST_MATCH:
				(vsl_c_buf_p) =
				&YY_CURRENT_BUFFER_LVALUE->vsl_ch_buf[(vsl_n_chars)];

				vsl_current_state = vsl_get_previous_state(  );

				vsl_cp = (vsl_c_buf_p);
				vsl_bp = (vsltext_ptr) + YY_MORE_ADJ;
				goto vsl_find_action;
			}
		break;
		}

	default:
		YY_FATAL_ERROR(
			"fatal flex scanner internal error--no action found" );
	} /* end of action switch */
		} /* end of scanning one token */
} /* end of vsllex */

/* vsl_get_next_buffer - try to read in a new buffer
 *
 * Returns a code representing an action:
 *	EOB_ACT_LAST_MATCH -
 *	EOB_ACT_CONTINUE_SCAN - continue scanning from current position
 *	EOB_ACT_END_OF_FILE - end of file
 */
static int vsl_get_next_buffer (void)
{
    	register char *dest = YY_CURRENT_BUFFER_LVALUE->vsl_ch_buf;
	register char *source = (vsltext_ptr);
	register int number_to_move, i;
	int ret_val;

	if ( (vsl_c_buf_p) > &YY_CURRENT_BUFFER_LVALUE->vsl_ch_buf[(vsl_n_chars) + 1] )
		YY_FATAL_ERROR(
		"fatal flex scanner internal error--end of buffer missed" );

	if ( YY_CURRENT_BUFFER_LVALUE->vsl_fill_buffer == 0 )
		{ /* Don't try to fill the buffer, so this is an EOF. */
		if ( (vsl_c_buf_p) - (vsltext_ptr) - YY_MORE_ADJ == 1 )
			{
			/* We matched a single character, the EOB, so
			 * treat this as a final EOF.
			 */
			return EOB_ACT_END_OF_FILE;
			}

		else
			{
			/* We matched some text prior to the EOB, first
			 * process it.
			 */
			return EOB_ACT_LAST_MATCH;
			}
		}

	/* Try to read more data. */

	/* First move last chars to start of buffer. */
	number_to_move = (int) ((vsl_c_buf_p) - (vsltext_ptr)) - 1;

	for ( i = 0; i < number_to_move; ++i )
		*(dest++) = *(source++);

	if ( YY_CURRENT_BUFFER_LVALUE->vsl_buffer_status == YY_BUFFER_EOF_PENDING )
		/* don't do the read, it's not guaranteed to return an EOF,
		 * just force an EOF
		 */
		YY_CURRENT_BUFFER_LVALUE->vsl_n_chars = (vsl_n_chars) = 0;

	else
		{
			int num_to_read =
			YY_CURRENT_BUFFER_LVALUE->vsl_buf_size - number_to_move - 1;

		while ( num_to_read <= 0 )
			{ /* Not enough room in the buffer - grow it. */

			/* just a shorter name for the current buffer */
			YY_BUFFER_STATE b = YY_CURRENT_BUFFER;

			int vsl_c_buf_p_offset =
				(int) ((vsl_c_buf_p) - b->vsl_ch_buf);

			if ( b->vsl_is_our_buffer )
				{
				int new_size = b->vsl_buf_size * 2;

				if ( new_size <= 0 )
					b->vsl_buf_size += b->vsl_buf_size / 8;
				else
					b->vsl_buf_size *= 2;

				b->vsl_ch_buf = (char *)
					/* Include room in for 2 EOB chars. */
					vslrealloc((void *) b->vsl_ch_buf,b->vsl_buf_size + 2  );
				}
			else
				/* Can't grow it, we don't own it. */
				b->vsl_ch_buf = 0;

			if ( ! b->vsl_ch_buf )
				YY_FATAL_ERROR(
				"fatal error - scanner input buffer overflow" );

			(vsl_c_buf_p) = &b->vsl_ch_buf[vsl_c_buf_p_offset];

			num_to_read = YY_CURRENT_BUFFER_LVALUE->vsl_buf_size -
						number_to_move - 1;

			}

		if ( num_to_read > YY_READ_BUF_SIZE )
			num_to_read = YY_READ_BUF_SIZE;

		/* Read in more data. */
		YY_INPUT( (&YY_CURRENT_BUFFER_LVALUE->vsl_ch_buf[number_to_move]),
			(vsl_n_chars), (size_t) num_to_read );

		YY_CURRENT_BUFFER_LVALUE->vsl_n_chars = (vsl_n_chars);
		}

	if ( (vsl_n_chars) == 0 )
		{
		if ( number_to_move == YY_MORE_ADJ )
			{
			ret_val = EOB_ACT_END_OF_FILE;
			vslrestart(vslin  );
			}

		else
			{
			ret_val = EOB_ACT_LAST_MATCH;
			YY_CURRENT_BUFFER_LVALUE->vsl_buffer_status =
				YY_BUFFER_EOF_PENDING;
			}
		}

	else
		ret_val = EOB_ACT_CONTINUE_SCAN;

	if ((vsl_size_t) ((vsl_n_chars) + number_to_move) > YY_CURRENT_BUFFER_LVALUE->vsl_buf_size) {
		/* Extend the array by 50%, plus the number we really need. */
		vsl_size_t new_size = (vsl_n_chars) + number_to_move + ((vsl_n_chars) >> 1);
		YY_CURRENT_BUFFER_LVALUE->vsl_ch_buf = (char *) vslrealloc((void *) YY_CURRENT_BUFFER_LVALUE->vsl_ch_buf,new_size  );
		if ( ! YY_CURRENT_BUFFER_LVALUE->vsl_ch_buf )
			YY_FATAL_ERROR( "out of dynamic memory in vsl_get_next_buffer()" );
	}

	(vsl_n_chars) += number_to_move;
	YY_CURRENT_BUFFER_LVALUE->vsl_ch_buf[(vsl_n_chars)] = YY_END_OF_BUFFER_CHAR;
	YY_CURRENT_BUFFER_LVALUE->vsl_ch_buf[(vsl_n_chars) + 1] = YY_END_OF_BUFFER_CHAR;

	(vsltext_ptr) = &YY_CURRENT_BUFFER_LVALUE->vsl_ch_buf[0];

	return ret_val;
}

/* vsl_get_previous_state - get the state just before the EOB char was reached */

    static vsl_state_type vsl_get_previous_state (void)
{
	register vsl_state_type vsl_current_state;
	register char *vsl_cp;
    
	vsl_current_state = (vsl_start);
	vsl_current_state += YY_AT_BOL();

	for ( vsl_cp = (vsltext_ptr) + YY_MORE_ADJ; vsl_cp < (vsl_c_buf_p); ++vsl_cp )
		{
		register YY_CHAR vsl_c = (*vsl_cp ? vsl_ec[YY_SC_TO_UI(*vsl_cp)] : 1);
		if ( vsl_accept[vsl_current_state] )
			{
			(vsl_last_accepting_state) = vsl_current_state;
			(vsl_last_accepting_cpos) = vsl_cp;
			}
		while ( vsl_chk[vsl_base[vsl_current_state] + vsl_c] != vsl_current_state )
			{
			vsl_current_state = (int) vsl_def[vsl_current_state];
			if ( vsl_current_state >= 149 )
				vsl_c = vsl_meta[(unsigned int) vsl_c];
			}
		vsl_current_state = vsl_nxt[vsl_base[vsl_current_state] + (unsigned int) vsl_c];
		}

	return vsl_current_state;
}

/* vsl_try_NUL_trans - try to make a transition on the NUL character
 *
 * synopsis
 *	next_state = vsl_try_NUL_trans( current_state );
 */
    static vsl_state_type vsl_try_NUL_trans  (vsl_state_type vsl_current_state )
{
	register int vsl_is_jam;
    	register char *vsl_cp = (vsl_c_buf_p);

	register YY_CHAR vsl_c = 1;
	if ( vsl_accept[vsl_current_state] )
		{
		(vsl_last_accepting_state) = vsl_current_state;
		(vsl_last_accepting_cpos) = vsl_cp;
		}
	while ( vsl_chk[vsl_base[vsl_current_state] + vsl_c] != vsl_current_state )
		{
		vsl_current_state = (int) vsl_def[vsl_current_state];
		if ( vsl_current_state >= 149 )
			vsl_c = vsl_meta[(unsigned int) vsl_c];
		}
	vsl_current_state = vsl_nxt[vsl_base[vsl_current_state] + (unsigned int) vsl_c];
	vsl_is_jam = (vsl_current_state == 148);

	return vsl_is_jam ? 0 : vsl_current_state;
}

    static void vslunput (int c, register char * vsl_bp )
{
	register char *vsl_cp;
    
    vsl_cp = (vsl_c_buf_p);

	/* undo effects of setting up vsltext */
	*vsl_cp = (vsl_hold_char);

	if ( vsl_cp < YY_CURRENT_BUFFER_LVALUE->vsl_ch_buf + 2 )
		{ /* need to shift things up to make room */
		/* +2 for EOB chars. */
		register int number_to_move = (vsl_n_chars) + 2;
		register char *dest = &YY_CURRENT_BUFFER_LVALUE->vsl_ch_buf[
					YY_CURRENT_BUFFER_LVALUE->vsl_buf_size + 2];
		register char *source =
				&YY_CURRENT_BUFFER_LVALUE->vsl_ch_buf[number_to_move];

		while ( source > YY_CURRENT_BUFFER_LVALUE->vsl_ch_buf )
			*--dest = *--source;

		vsl_cp += (int) (dest - source);
		vsl_bp += (int) (dest - source);
		YY_CURRENT_BUFFER_LVALUE->vsl_n_chars =
			(vsl_n_chars) = YY_CURRENT_BUFFER_LVALUE->vsl_buf_size;

		if ( vsl_cp < YY_CURRENT_BUFFER_LVALUE->vsl_ch_buf + 2 )
			YY_FATAL_ERROR( "flex scanner push-back overflow" );
		}

	*--vsl_cp = (char) c;

	(vsltext_ptr) = vsl_bp;
	(vsl_hold_char) = *vsl_cp;
	(vsl_c_buf_p) = vsl_cp;
}

#ifndef YY_NO_INPUT
#ifdef __cplusplus
    static int vslinput (void)
#else
    static int input  (void)
#endif

{
	int c;
    
	*(vsl_c_buf_p) = (vsl_hold_char);

	if ( *(vsl_c_buf_p) == YY_END_OF_BUFFER_CHAR )
		{
		/* vsl_c_buf_p now points to the character we want to return.
		 * If this occurs *before* the EOB characters, then it's a
		 * valid NUL; if not, then we've hit the end of the buffer.
		 */
		if ( (vsl_c_buf_p) < &YY_CURRENT_BUFFER_LVALUE->vsl_ch_buf[(vsl_n_chars)] )
			/* This was really a NUL. */
			*(vsl_c_buf_p) = '\0';

		else
			{ /* need more input */
			int offset = (vsl_c_buf_p) - (vsltext_ptr);
			++(vsl_c_buf_p);

			switch ( vsl_get_next_buffer(  ) )
				{
				case EOB_ACT_LAST_MATCH:
					/* This happens because vsl_g_n_b()
					 * sees that we've accumulated a
					 * token and flags that we need to
					 * try matching the token before
					 * proceeding.  But for input(),
					 * there's no matching to consider.
					 * So convert the EOB_ACT_LAST_MATCH
					 * to EOB_ACT_END_OF_FILE.
					 */

					/* Reset buffer status. */
					vslrestart(vslin );

					/*FALLTHROUGH*/

				case EOB_ACT_END_OF_FILE:
					{
					if ( vslwrap( ) )
						return EOF;

					if ( ! (vsl_did_buffer_switch_on_eof) )
						YY_NEW_FILE;
#ifdef __cplusplus
					return vslinput();
#else
					return input();
#endif
					}

				case EOB_ACT_CONTINUE_SCAN:
					(vsl_c_buf_p) = (vsltext_ptr) + offset;
					break;
				}
			}
		}

	c = *(unsigned char *) (vsl_c_buf_p);	/* cast for 8-bit char's */
	*(vsl_c_buf_p) = '\0';	/* preserve vsltext */
	(vsl_hold_char) = *++(vsl_c_buf_p);

	YY_CURRENT_BUFFER_LVALUE->vsl_at_bol = (c == '\n');

	return c;
}
#endif	/* ifndef YY_NO_INPUT */

/** Immediately switch to a different input stream.
 * @param input_file A readable stream.
 * 
 * @note This function does not reset the start condition to @c INITIAL .
 */
    void vslrestart  (FILE * input_file )
{
    
	if ( ! YY_CURRENT_BUFFER ){
        vslensure_buffer_stack ();
		YY_CURRENT_BUFFER_LVALUE =
            vsl_create_buffer(vslin,YY_BUF_SIZE );
	}

	vsl_init_buffer(YY_CURRENT_BUFFER,input_file );
	vsl_load_buffer_state( );
}

/** Switch to a different input buffer.
 * @param new_buffer The new input buffer.
 * 
 */
    void vsl_switch_to_buffer  (YY_BUFFER_STATE  new_buffer )
{
    
	/* TODO. We should be able to replace this entire function body
	 * with
	 *		vslpop_buffer_state();
	 *		vslpush_buffer_state(new_buffer);
     */
	vslensure_buffer_stack ();
	if ( YY_CURRENT_BUFFER == new_buffer )
		return;

	if ( YY_CURRENT_BUFFER )
		{
		/* Flush out information for old buffer. */
		*(vsl_c_buf_p) = (vsl_hold_char);
		YY_CURRENT_BUFFER_LVALUE->vsl_buf_pos = (vsl_c_buf_p);
		YY_CURRENT_BUFFER_LVALUE->vsl_n_chars = (vsl_n_chars);
		}

	YY_CURRENT_BUFFER_LVALUE = new_buffer;
	vsl_load_buffer_state( );

	/* We don't actually know whether we did this switch during
	 * EOF (vslwrap()) processing, but the only time this flag
	 * is looked at is after vslwrap() is called, so it's safe
	 * to go ahead and always set it.
	 */
	(vsl_did_buffer_switch_on_eof) = 1;
}

static void vsl_load_buffer_state  (void)
{
    	(vsl_n_chars) = YY_CURRENT_BUFFER_LVALUE->vsl_n_chars;
	(vsltext_ptr) = (vsl_c_buf_p) = YY_CURRENT_BUFFER_LVALUE->vsl_buf_pos;
	vslin = YY_CURRENT_BUFFER_LVALUE->vsl_input_file;
	(vsl_hold_char) = *(vsl_c_buf_p);
}

/** Allocate and initialize an input buffer state.
 * @param file A readable stream.
 * @param size The character buffer size in bytes. When in doubt, use @c YY_BUF_SIZE.
 * 
 * @return the allocated buffer state.
 */
    YY_BUFFER_STATE vsl_create_buffer  (FILE * file, int  size )
{
	YY_BUFFER_STATE b;
    
	b = (YY_BUFFER_STATE) vslalloc(sizeof( struct vsl_buffer_state )  );
	if ( ! b )
		YY_FATAL_ERROR( "out of dynamic memory in vsl_create_buffer()" );

	b->vsl_buf_size = size;

	/* vsl_ch_buf has to be 2 characters longer than the size given because
	 * we need to put in 2 end-of-buffer characters.
	 */
	b->vsl_ch_buf = (char *) vslalloc(b->vsl_buf_size + 2  );
	if ( ! b->vsl_ch_buf )
		YY_FATAL_ERROR( "out of dynamic memory in vsl_create_buffer()" );

	b->vsl_is_our_buffer = 1;

	vsl_init_buffer(b,file );

	return b;
}

/** Destroy the buffer.
 * @param b a buffer created with vsl_create_buffer()
 * 
 */
    void vsl_delete_buffer (YY_BUFFER_STATE  b )
{
    
	if ( ! b )
		return;

	if ( b == YY_CURRENT_BUFFER ) /* Not sure if we should pop here. */
		YY_CURRENT_BUFFER_LVALUE = (YY_BUFFER_STATE) 0;

	if ( b->vsl_is_our_buffer )
		vslfree((void *) b->vsl_ch_buf  );

	vslfree((void *) b  );
}

#ifndef __cplusplus
extern int isatty (int );
#endif /* __cplusplus */
    
/* Initializes or reinitializes a buffer.
 * This function is sometimes called more than once on the same buffer,
 * such as during a vslrestart() or at EOF.
 */
    static void vsl_init_buffer  (YY_BUFFER_STATE  b, FILE * file )

{
	int oerrno = errno;
    
	vsl_flush_buffer(b );

	b->vsl_input_file = file;
	b->vsl_fill_buffer = 1;

    /* If b is the current buffer, then vsl_init_buffer was _probably_
     * called from vslrestart() or through vsl_get_next_buffer.
     * In that case, we don't want to reset the lineno or column.
     */
    if (b != YY_CURRENT_BUFFER){
        b->vsl_bs_lineno = 1;
        b->vsl_bs_column = 0;
    }

        b->vsl_is_interactive = file ? (isatty( fileno(file) ) > 0) : 0;
    
	errno = oerrno;
}

/** Discard all buffered characters. On the next scan, YY_INPUT will be called.
 * @param b the buffer state to be flushed, usually @c YY_CURRENT_BUFFER.
 * 
 */
    void vsl_flush_buffer (YY_BUFFER_STATE  b )
{
    	if ( ! b )
		return;

	b->vsl_n_chars = 0;

	/* We always need two end-of-buffer characters.  The first causes
	 * a transition to the end-of-buffer state.  The second causes
	 * a jam in that state.
	 */
	b->vsl_ch_buf[0] = YY_END_OF_BUFFER_CHAR;
	b->vsl_ch_buf[1] = YY_END_OF_BUFFER_CHAR;

	b->vsl_buf_pos = &b->vsl_ch_buf[0];

	b->vsl_at_bol = 1;
	b->vsl_buffer_status = YY_BUFFER_NEW;

	if ( b == YY_CURRENT_BUFFER )
		vsl_load_buffer_state( );
}

/** Pushes the new state onto the stack. The new state becomes
 *  the current state. This function will allocate the stack
 *  if necessary.
 *  @param new_buffer The new state.
 *  
 */
void vslpush_buffer_state (YY_BUFFER_STATE new_buffer )
{
    	if (new_buffer == NULL)
		return;

	vslensure_buffer_stack();

	/* This block is copied from vsl_switch_to_buffer. */
	if ( YY_CURRENT_BUFFER )
		{
		/* Flush out information for old buffer. */
		*(vsl_c_buf_p) = (vsl_hold_char);
		YY_CURRENT_BUFFER_LVALUE->vsl_buf_pos = (vsl_c_buf_p);
		YY_CURRENT_BUFFER_LVALUE->vsl_n_chars = (vsl_n_chars);
		}

	/* Only push if top exists. Otherwise, replace top. */
	if (YY_CURRENT_BUFFER)
		(vsl_buffer_stack_top)++;
	YY_CURRENT_BUFFER_LVALUE = new_buffer;

	/* copied from vsl_switch_to_buffer. */
	vsl_load_buffer_state( );
	(vsl_did_buffer_switch_on_eof) = 1;
}

/** Removes and deletes the top of the stack, if present.
 *  The next element becomes the new top.
 *  
 */
void vslpop_buffer_state (void)
{
    	if (!YY_CURRENT_BUFFER)
		return;

	vsl_delete_buffer(YY_CURRENT_BUFFER );
	YY_CURRENT_BUFFER_LVALUE = NULL;
	if ((vsl_buffer_stack_top) > 0)
		--(vsl_buffer_stack_top);

	if (YY_CURRENT_BUFFER) {
		vsl_load_buffer_state( );
		(vsl_did_buffer_switch_on_eof) = 1;
	}
}

/* Allocates the stack if it does not exist.
 *  Guarantees space for at least one push.
 */
static void vslensure_buffer_stack (void)
{
	int num_to_alloc;
    
	if (!(vsl_buffer_stack)) {

		/* First allocation is just for 2 elements, since we don't know if this
		 * scanner will even need a stack. We use 2 instead of 1 to avoid an
		 * immediate realloc on the next call.
         */
		num_to_alloc = 1;
		(vsl_buffer_stack) = (struct vsl_buffer_state**)vslalloc
								(num_to_alloc * sizeof(struct vsl_buffer_state*)
								);
		if ( ! (vsl_buffer_stack) )
			YY_FATAL_ERROR( "out of dynamic memory in vslensure_buffer_stack()" );
								  
		memset((vsl_buffer_stack), 0, num_to_alloc * sizeof(struct vsl_buffer_state*));
				
		(vsl_buffer_stack_max) = num_to_alloc;
		(vsl_buffer_stack_top) = 0;
		return;
	}

	if ((vsl_buffer_stack_top) >= ((vsl_buffer_stack_max)) - 1){

		/* Increase the buffer to prepare for a possible push. */
		int grow_size = 8 /* arbitrary grow size */;

		num_to_alloc = (vsl_buffer_stack_max) + grow_size;
		(vsl_buffer_stack) = (struct vsl_buffer_state**)vslrealloc
								((vsl_buffer_stack),
								num_to_alloc * sizeof(struct vsl_buffer_state*)
								);
		if ( ! (vsl_buffer_stack) )
			YY_FATAL_ERROR( "out of dynamic memory in vslensure_buffer_stack()" );

		/* zero only the new slots.*/
		memset((vsl_buffer_stack) + (vsl_buffer_stack_max), 0, grow_size * sizeof(struct vsl_buffer_state*));
		(vsl_buffer_stack_max) = num_to_alloc;
	}
}

/** Setup the input buffer state to scan directly from a user-specified character buffer.
 * @param base the character buffer
 * @param size the size in bytes of the character buffer
 * 
 * @return the newly allocated buffer state object. 
 */
YY_BUFFER_STATE vsl_scan_buffer  (char * base, vsl_size_t  size )
{
	YY_BUFFER_STATE b;
    
	if ( size < 2 ||
	     base[size-2] != YY_END_OF_BUFFER_CHAR ||
	     base[size-1] != YY_END_OF_BUFFER_CHAR )
		/* They forgot to leave room for the EOB's. */
		return 0;

	b = (YY_BUFFER_STATE) vslalloc(sizeof( struct vsl_buffer_state )  );
	if ( ! b )
		YY_FATAL_ERROR( "out of dynamic memory in vsl_scan_buffer()" );

	b->vsl_buf_size = size - 2;	/* "- 2" to take care of EOB's */
	b->vsl_buf_pos = b->vsl_ch_buf = base;
	b->vsl_is_our_buffer = 0;
	b->vsl_input_file = 0;
	b->vsl_n_chars = b->vsl_buf_size;
	b->vsl_is_interactive = 0;
	b->vsl_at_bol = 1;
	b->vsl_fill_buffer = 0;
	b->vsl_buffer_status = YY_BUFFER_NEW;

	vsl_switch_to_buffer(b  );

	return b;
}

/** Setup the input buffer state to scan a string. The next call to vsllex() will
 * scan from a @e copy of @a str.
 * @param vslstr a NUL-terminated string to scan
 * 
 * @return the newly allocated buffer state object.
 * @note If you want to scan bytes that may contain NUL values, then use
 *       vsl_scan_bytes() instead.
 */
YY_BUFFER_STATE vsl_scan_string (vslconst char * vslstr )
{
    
	return vsl_scan_bytes(vslstr,strlen(vslstr) );
}

/** Setup the input buffer state to scan the given bytes. The next call to vsllex() will
 * scan from a @e copy of @a bytes.
 * @param bytes the byte buffer to scan
 * @param len the number of bytes in the buffer pointed to by @a bytes.
 * 
 * @return the newly allocated buffer state object.
 */
YY_BUFFER_STATE vsl_scan_bytes  (vslconst char * vslbytes, int  _vslbytes_len )
{
	YY_BUFFER_STATE b;
	char *buf;
	vsl_size_t n;
	int i;
    
	/* Get memory for full buffer, including space for trailing EOB's. */
	n = _vslbytes_len + 2;
	buf = (char *) vslalloc(n  );
	if ( ! buf )
		YY_FATAL_ERROR( "out of dynamic memory in vsl_scan_bytes()" );

	for ( i = 0; i < _vslbytes_len; ++i )
		buf[i] = vslbytes[i];

	buf[_vslbytes_len] = buf[_vslbytes_len+1] = YY_END_OF_BUFFER_CHAR;

	b = vsl_scan_buffer(buf,n );
	if ( ! b )
		YY_FATAL_ERROR( "bad buffer in vsl_scan_bytes()" );

	/* It's okay to grow etc. this buffer, and we should throw it
	 * away when we're done.
	 */
	b->vsl_is_our_buffer = 1;

	return b;
}

#ifndef YY_EXIT_FAILURE
#define YY_EXIT_FAILURE 2
#endif

static void vsl_fatal_error (vslconst char* msg )
{
    	(void) fprintf( stderr, "%s\n", msg );
	exit( YY_EXIT_FAILURE );
}

/* Redefine vslless() so it works in section 3 code. */

#undef vslless
#define vslless(n) \
	do \
		{ \
		/* Undo effects of setting up vsltext. */ \
        int vslless_macro_arg = (n); \
        YY_LESS_LINENO(vslless_macro_arg);\
		vsltext[vslleng] = (vsl_hold_char); \
		(vsl_c_buf_p) = vsltext + vslless_macro_arg; \
		(vsl_hold_char) = *(vsl_c_buf_p); \
		*(vsl_c_buf_p) = '\0'; \
		vslleng = vslless_macro_arg; \
		} \
	while ( 0 )

/* Accessor  methods (get/set functions) to struct members. */

/** Get the current line number.
 * 
 */
int vslget_lineno  (void)
{
        
    return vsllineno;
}

/** Get the input stream.
 * 
 */
FILE *vslget_in  (void)
{
        return vslin;
}

/** Get the output stream.
 * 
 */
FILE *vslget_out  (void)
{
        return vslout;
}

/** Get the length of the current token.
 * 
 */
int vslget_leng  (void)
{
        return vslleng;
}

/** Get the current token.
 * 
 */

char *vslget_text  (void)
{
        return vsltext;
}

/** Set the current line number.
 * @param line_number
 * 
 */
void vslset_lineno (int  line_number )
{
    
    vsllineno = line_number;
}

/** Set the input stream. This does not discard the current
 * input buffer.
 * @param in_str A readable stream.
 * 
 * @see vsl_switch_to_buffer
 */
void vslset_in (FILE *  in_str )
{
        vslin = in_str ;
}

void vslset_out (FILE *  out_str )
{
        vslout = out_str ;
}

int vslget_debug  (void)
{
        return vsl_flex_debug;
}

void vslset_debug (int  bdebug )
{
        vsl_flex_debug = bdebug ;
}

static int vsl_init_globals (void)
{
        /* Initialization is the same as for the non-reentrant scanner.
     * This function is called from vsllex_destroy(), so don't allocate here.
     */

    (vsl_buffer_stack) = 0;
    (vsl_buffer_stack_top) = 0;
    (vsl_buffer_stack_max) = 0;
    (vsl_c_buf_p) = (char *) 0;
    (vsl_init) = 0;
    (vsl_start) = 0;

/* Defined in main.c */
#ifdef YY_STDINIT
    vslin = stdin;
    vslout = stdout;
#else
    vslin = (FILE *) 0;
    vslout = (FILE *) 0;
#endif

    /* For future reference: Set errno on error, since we are called by
     * vsllex_init()
     */
    return 0;
}

/* vsllex_destroy is for both reentrant and non-reentrant scanners. */
int vsllex_destroy  (void)
{
    
    /* Pop the buffer stack, destroying each element. */
	while(YY_CURRENT_BUFFER){
		vsl_delete_buffer(YY_CURRENT_BUFFER  );
		YY_CURRENT_BUFFER_LVALUE = NULL;
		vslpop_buffer_state();
	}

	/* Destroy the stack itself. */
	vslfree((vsl_buffer_stack) );
	(vsl_buffer_stack) = NULL;

    /* Reset the globals. This is important in a non-reentrant scanner so the next time
     * vsllex() is called, initialization will occur. */
    vsl_init_globals( );

    return 0;
}

/*
 * Internal utility routines.
 */

#ifndef vsltext_ptr
static void vsl_flex_strncpy (char* s1, vslconst char * s2, int n )
{
	register int i;
	for ( i = 0; i < n; ++i )
		s1[i] = s2[i];
}
#endif

#ifdef YY_NEED_STRLEN
static int vsl_flex_strlen (vslconst char * s )
{
	register int n;
	for ( n = 0; s[n]; ++n )
		;

	return n;
}
#endif

void *vslalloc (vsl_size_t  size )
{
	return (void *) malloc( size );
}

void *vslrealloc  (void * ptr, vsl_size_t  size )
{
	/* The cast to (char *) in the following accommodates both
	 * implementations that use char* generic pointers, and those
	 * that use void* generic pointers.  It works with the latter
	 * because both ANSI C and C++ allow castless assignment from
	 * any pointer type to void*, and deal with argument conversions
	 * as though doing an assignment.
	 */
	return (void *) realloc( (char *) ptr, size );
}

void vslfree (void * ptr )
{
	free( (char *) ptr );	/* see vslrealloc() for (char *) cast */
}

#define YYTABLES_NAME "vsltables"

#line 354 "./vsl-lex.L"


// Delete name set
void vslNameSet::reset()
{ 
    if (_next) 
	delete _next; 
    _next = 0; 
}

// Add to name set; if already there, return -1
int vslNameSet::add(const char *name)
{
    if (strcmp(_name.chars(), name) == 0)
	return -1;

    if (_next)
	return _next->add(name);

    _next = new vslNameSet(name);
    return 0;
}

// Clear name set
static void switchreset()
{
    vslnameSet.reset();
}


// Return to original file
static int switchdown(void) 
{
    if (topstack <= 0)
	return -1;
	
    if (vslstream != 0)
    {
	if (VSEFlags::verbose)
	{
	    std::cout << ")";
	    std::cout.flush();
	}
	delete vslstream;
    }

    topstack--;
    vslstream	 = streamstack[topstack];
    vslfilename	 = namestack[topstack];
    vsllinenumber = linestack[topstack];

#ifdef FLEX_SCANNER
    if (YY_CURRENT_BUFFER != 0)
	vsl_delete_buffer(YY_CURRENT_BUFFER);
    vsl_switch_to_buffer(bufstack[topstack]);
#endif

    return 0;
}

#ifndef VSL_INCLUDE_PATH
#define VSL_INCLUDE_PATH "/usr/local/lib/vsl-include"
#endif

static string dirname(const string& file)
{
    if (file.contains('/'))
	return file.before('/', -1);
    else
	return ".";
}

// Search file in directories -I, $VSL_INCLUDE.
// If THISDIR == true, also search in current directory,
// If not found, return FILENAME.
static const char *searchpath(const char *filename, bool thisDir)
{
    char includeList[BUFSIZ];

    // If "-I" is given, use this path
    const char *s = VSEFlags::include_search_path;
    if (s == 0 || s[0] == '\0')
    {
	// Otherwise: Use environment or default path
	s = getenv("VSL_INCLUDE");
	if (s == 0)
	{
	    static string path = 
		string(VSL_INCLUDE_PATH) +
		":/usr/local/vse/vsl-include"
		":/usr/vse/vsl-include"
		":/usr/local/lib/vse/vsl-include"
		":/usr/lib/vse/vsl-include"
		":/usr/local/lib/vsl-include"
		":/usr/lib/vsl-include";
	    
	    s = path.chars();
	}
    }

    // If this dir to be searched, prepend directory name of current file.
    if (thisDir)
    {
	string dir = dirname(vslfilename);
	dir += ":";
	strcpy(includeList, dir.chars());
    }
    else
    {
	strcpy(includeList, "");
    }
    strncat(includeList, s, BUFSIZ - 2);

    // Check dirs; if file can be opened, return full path
    for (char *p = strtok(includeList, ":"); 
	 p != 0; 
	 p = strtok((char *)0, ":"))
    {
	static char path[BUFSIZ];
	strcpy(path, p);
	strcat(path, "/");
	strcat(path, filename);

	FILE *fp = fopen(path, "r");
	if (fp != 0 && fclose(fp) != EOF)
	{
	    // Remove "./" prefix
	    if (path[0] == '.' && path[1] == '/')
		return path + 2;
	    else
		return path;
	}
    }

    return filename;
}

