esnacc-ng Code of Conduct
=========================

The esnacc-ng project is made up of many thousands of users (knowingly and
unknowingly), and worked on by a number of developers.  These people fall all
along the spectrum of professional to volunteer, and come from all over the
world.

Diversity is a great strength, and the esnacc-ng project is lucky to have a
large and diverse set of contributors of all manner of technical strengths.
However, when such a diverse group of people works together there are bound
to be communication issues.  To keep all communications useful and productive,
it is important that we establish some ground rules for community participation.
These rules apply to *everyone*.

This list is not meant to be exhaustive or comprehensive enumeration of every
action that is or isn't acceptable.  The overriding rule is always, "be
reasonable, and understand that a human is at the other end."

This list applies to all of the esnacc-ng communcation mediums, be they IRC,
mailing lists, git commit messages, code, code comments, bug database entries,
and any other area where esnacc-ng folks are communicating.

If you believe someone is violating the code of conduct, please report it
immediately to conduct@esnacc.org.  If you believe someone is in immediate
physical danger, it is important that you contact law enforcement before
involving the esnacc-ng community.

Good Ideas
----------

* DO be friendly and patient.  Not everyone is as familiar with the
  technologies.  We were all new, once.

* DO be welcoming and inclusive.  We want to be a community that benefits from
  the old addage of diversity breeding strength.  The more diverse our views,
  the more effective we can be.

* DO be considerate.  We all have rushing deadlines, and important features to
  provide.  Our work builds on the work of others.  And others work builds on
  our work.  However, we will not succeed if we blindly push ahead with poorly
  planned or thought out features.  We are all communicating in English, but it
  may not be our primary language.

* DO be respectful.  No two people can be in agreement 100% of the time.  This
  is just a fact of human nature.  It is NEVER acceptable to turn disagreement
  into personal attacks.  It is important to remember that when people feel
  threatened or afraid they stop contributing.  It is important that we always
  let people feel respected, and safe when dealing with members of the
  community.

* DO be careful with words.  ASN.1 is typically a tool for industry
  professionals.  As such, we have a higher concentration of professionals who
  contribute.  It is expected that all contributors behave "professionally" at
  all times.  This does not mean that every idea or contribution will be
  desirable or should be accepted.  It DOES mean that when an idea is a failing
  one, we calmly and respectfully explain such and move on.  Insults, put downs,
  and other exclusionary behavior aren't acceptable.  This includes, but is not
  limited to violent threats, offensive language directed at an individual,
  discriminatory jokes, sexually explicit material, violent material, unwelcome
  sexual attention, advocating any of the above behavior.


Do not's
--------

* DO NOT assume that the person on the other end speaks english natively.  Words
  that might not make sense, and words which are inflammatory in one culture,
  are not so in another.  If a particular word choice is not understandable, ask
  for clarification before assuming any offense was meant.

* DO NOT insult or threaten any individual.  Sometimes patches contain code
  which has a quite foul odor [1].  It is okay to tell someone that their code
  cannot be accepted for technical reasons.  It is NEVER okay to personally
  insult someone because of their submission.

* DO NOT post or publish materials "you wouldn't want your mother to see."  This
  means if you be ashamed of your post if someone read it, you probably
  shouldn't post it.


Questions
---------

Don't hesitate to ask for any clarification of the above.  The goal is to
encourage additional participation in the development of esnacc-ng.

This document was partially derived from the Django Code of Conduct [2].


1: https://en.wikipedia.org/wiki/Code_smell
2: https://www.djangoproject.com/conduct/
