//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armservicebus

import "time"

// AccessKeys - Namespace/ServiceBus Connection String
type AccessKeys struct {
	// READ-ONLY; Primary connection string of the alias if GEO DR is enabled
	AliasPrimaryConnectionString *string `json:"aliasPrimaryConnectionString,omitempty" azure:"ro"`

	// READ-ONLY; Secondary connection string of the alias if GEO DR is enabled
	AliasSecondaryConnectionString *string `json:"aliasSecondaryConnectionString,omitempty" azure:"ro"`

	// READ-ONLY; A string that describes the authorization rule.
	KeyName *string `json:"keyName,omitempty" azure:"ro"`

	// READ-ONLY; Primary connection string of the created namespace authorization rule.
	PrimaryConnectionString *string `json:"primaryConnectionString,omitempty" azure:"ro"`

	// READ-ONLY; A base64-encoded 256-bit primary key for signing and validating the SAS token.
	PrimaryKey *string `json:"primaryKey,omitempty" azure:"ro"`

	// READ-ONLY; Secondary connection string of the created namespace authorization rule.
	SecondaryConnectionString *string `json:"secondaryConnectionString,omitempty" azure:"ro"`

	// READ-ONLY; A base64-encoded 256-bit primary key for signing and validating the SAS token.
	SecondaryKey *string `json:"secondaryKey,omitempty" azure:"ro"`
}

// Action - Represents the filter actions which are allowed for the transformation of a message that have been matched by
// a filter expression.
type Action struct {
	// This property is reserved for future use. An integer value showing the compatibility level, currently hard-coded to 20.
	CompatibilityLevel *int32 `json:"compatibilityLevel,omitempty"`

	// Value that indicates whether the rule action requires preprocessing.
	RequiresPreprocessing *bool `json:"requiresPreprocessing,omitempty"`

	// SQL expression. e.g. MyProperty='ABC'
	SQLExpression *string `json:"sqlExpression,omitempty"`
}

// ArmDisasterRecovery - Single item in List or Get Alias(Disaster Recovery configuration) operation
type ArmDisasterRecovery struct {
	// Properties required to the Create Or Update Alias(Disaster Recovery configurations)
	Properties *ArmDisasterRecoveryProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The geo-location where the resource lives
	Location *string `json:"location,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The system meta data relating to this resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.EventHub/Namespaces" or "Microsoft.EventHub/Namespaces/EventHubs"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ArmDisasterRecoveryListResult - The result of the List Alias(Disaster Recovery configuration) operation.
type ArmDisasterRecoveryListResult struct {
	// List of Alias(Disaster Recovery configurations)
	Value []*ArmDisasterRecovery `json:"value,omitempty"`

	// READ-ONLY; Link to the next set of results. Not empty if Value contains incomplete list of Alias(Disaster Recovery configuration)
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// ArmDisasterRecoveryProperties - Properties required to the Create Or Update Alias(Disaster Recovery configurations)
type ArmDisasterRecoveryProperties struct {
	// Primary/Secondary eventhub namespace name, which is part of GEO DR pairing
	AlternateName *string `json:"alternateName,omitempty"`

	// ARM Id of the Primary/Secondary eventhub namespace name, which is part of GEO DR pairing
	PartnerNamespace *string `json:"partnerNamespace,omitempty"`

	// READ-ONLY; Number of entities pending to be replicated.
	PendingReplicationOperationsCount *int64 `json:"pendingReplicationOperationsCount,omitempty" azure:"ro"`

	// READ-ONLY; Provisioning state of the Alias(Disaster Recovery configuration) - possible values 'Accepted' or 'Succeeded'
	// or 'Failed'
	ProvisioningState *ProvisioningStateDR `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; role of namespace in GEO DR - possible values 'Primary' or 'PrimaryNotReplicating' or 'Secondary'
	Role *RoleDisasterRecovery `json:"role,omitempty" azure:"ro"`
}

// CheckNameAvailability - Description of a Check Name availability request properties.
type CheckNameAvailability struct {
	// REQUIRED; The Name to check the namespace name availability and The namespace name can contain only letters, numbers, and
	// hyphens. The namespace must start with a letter, and it must end with a letter or
	// number.
	Name *string `json:"name,omitempty"`
}

// CheckNameAvailabilityResult - Description of a Check Name availability request properties.
type CheckNameAvailabilityResult struct {
	// Value indicating namespace is availability, true if the namespace is available; otherwise, false.
	NameAvailable *bool `json:"nameAvailable,omitempty"`

	// The reason for unavailability of a namespace.
	Reason *UnavailableReason `json:"reason,omitempty"`

	// READ-ONLY; The detailed info regarding the reason associated with the namespace.
	Message *string `json:"message,omitempty" azure:"ro"`
}

// ConnectionState information.
type ConnectionState struct {
	// Description of the connection state.
	Description *string `json:"description,omitempty"`

	// Status of the connection.
	Status *PrivateLinkConnectionStatus `json:"status,omitempty"`
}

// CorrelationFilter - Represents the correlation filter expression.
type CorrelationFilter struct {
	// Content type of the message.
	ContentType *string `json:"contentType,omitempty"`

	// Identifier of the correlation.
	CorrelationID *string `json:"correlationId,omitempty"`

	// Application specific label.
	Label *string `json:"label,omitempty"`

	// Identifier of the message.
	MessageID *string `json:"messageId,omitempty"`

	// dictionary object for custom filters
	Properties map[string]*string `json:"properties,omitempty"`

	// Address of the queue to reply to.
	ReplyTo *string `json:"replyTo,omitempty"`

	// Session identifier to reply to.
	ReplyToSessionID *string `json:"replyToSessionId,omitempty"`

	// Value that indicates whether the rule action requires preprocessing.
	RequiresPreprocessing *bool `json:"requiresPreprocessing,omitempty"`

	// Session identifier.
	SessionID *string `json:"sessionId,omitempty"`

	// Address to send to.
	To *string `json:"to,omitempty"`
}

// DisasterRecoveryConfigsClientBreakPairingOptions contains the optional parameters for the DisasterRecoveryConfigsClient.BreakPairing
// method.
type DisasterRecoveryConfigsClientBreakPairingOptions struct {
	// placeholder for future optional parameters
}

// DisasterRecoveryConfigsClientCheckNameAvailabilityOptions contains the optional parameters for the DisasterRecoveryConfigsClient.CheckNameAvailability
// method.
type DisasterRecoveryConfigsClientCheckNameAvailabilityOptions struct {
	// placeholder for future optional parameters
}

// DisasterRecoveryConfigsClientCreateOrUpdateOptions contains the optional parameters for the DisasterRecoveryConfigsClient.CreateOrUpdate
// method.
type DisasterRecoveryConfigsClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// DisasterRecoveryConfigsClientDeleteOptions contains the optional parameters for the DisasterRecoveryConfigsClient.Delete
// method.
type DisasterRecoveryConfigsClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// DisasterRecoveryConfigsClientFailOverOptions contains the optional parameters for the DisasterRecoveryConfigsClient.FailOver
// method.
type DisasterRecoveryConfigsClientFailOverOptions struct {
	// Parameters required to create an Alias(Disaster Recovery configuration)
	Parameters *FailoverProperties
}

// DisasterRecoveryConfigsClientGetAuthorizationRuleOptions contains the optional parameters for the DisasterRecoveryConfigsClient.GetAuthorizationRule
// method.
type DisasterRecoveryConfigsClientGetAuthorizationRuleOptions struct {
	// placeholder for future optional parameters
}

// DisasterRecoveryConfigsClientGetOptions contains the optional parameters for the DisasterRecoveryConfigsClient.Get method.
type DisasterRecoveryConfigsClientGetOptions struct {
	// placeholder for future optional parameters
}

// DisasterRecoveryConfigsClientListAuthorizationRulesOptions contains the optional parameters for the DisasterRecoveryConfigsClient.ListAuthorizationRules
// method.
type DisasterRecoveryConfigsClientListAuthorizationRulesOptions struct {
	// placeholder for future optional parameters
}

// DisasterRecoveryConfigsClientListKeysOptions contains the optional parameters for the DisasterRecoveryConfigsClient.ListKeys
// method.
type DisasterRecoveryConfigsClientListKeysOptions struct {
	// placeholder for future optional parameters
}

// DisasterRecoveryConfigsClientListOptions contains the optional parameters for the DisasterRecoveryConfigsClient.List method.
type DisasterRecoveryConfigsClientListOptions struct {
	// placeholder for future optional parameters
}

// Encryption - Properties to configure Encryption
type Encryption struct {
	// Enumerates the possible value of keySource for Encryption
	KeySource *KeySource `json:"keySource,omitempty"`

	// Properties of KeyVault
	KeyVaultProperties []*KeyVaultProperties `json:"keyVaultProperties,omitempty"`

	// Enable Infrastructure Encryption (Double Encryption)
	RequireInfrastructureEncryption *bool `json:"requireInfrastructureEncryption,omitempty"`
}

// ErrorAdditionalInfo - The resource management error additional info.
type ErrorAdditionalInfo struct {
	// READ-ONLY; The additional info.
	Info interface{} `json:"info,omitempty" azure:"ro"`

	// READ-ONLY; The additional info type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ErrorResponse - The resource management error response.
type ErrorResponse struct {
	// The error object.
	Error *ErrorResponseError `json:"error,omitempty"`
}

// ErrorResponseError - The error object.
type ErrorResponseError struct {
	// READ-ONLY; The error additional info.
	AdditionalInfo []*ErrorAdditionalInfo `json:"additionalInfo,omitempty" azure:"ro"`

	// READ-ONLY; The error code.
	Code *string `json:"code,omitempty" azure:"ro"`

	// READ-ONLY; The error details.
	Details []*ErrorResponse `json:"details,omitempty" azure:"ro"`

	// READ-ONLY; The error message.
	Message *string `json:"message,omitempty" azure:"ro"`

	// READ-ONLY; The error target.
	Target *string `json:"target,omitempty" azure:"ro"`
}

// FailoverProperties - Safe failover is to indicate the service should wait for pending replication to finish before switching
// to the secondary.
type FailoverProperties struct {
	// Safe failover is to indicate the service should wait for pending replication to finish before switching to the secondary.
	Properties *FailoverPropertiesProperties `json:"properties,omitempty"`
}

// FailoverPropertiesProperties - Safe failover is to indicate the service should wait for pending replication to finish before
// switching to the secondary.
type FailoverPropertiesProperties struct {
	// Safe failover is to indicate the service should wait for pending replication to finish before switching to the secondary.
	IsSafeFailover *bool `json:"IsSafeFailover,omitempty"`
}

// Identity - Properties to configure User Assigned Identities for Bring your Own Keys
type Identity struct {
	// Type of managed service identity.
	Type *ManagedServiceIdentityType `json:"type,omitempty"`

	// Properties for User Assigned Identities
	UserAssignedIdentities map[string]*UserAssignedIdentity `json:"userAssignedIdentities,omitempty"`

	// READ-ONLY; ObjectId from the KeyVault
	PrincipalID *string `json:"principalId,omitempty" azure:"ro"`

	// READ-ONLY; TenantId from the KeyVault
	TenantID *string `json:"tenantId,omitempty" azure:"ro"`
}

// KeyVaultProperties - Properties to configure keyVault Properties
type KeyVaultProperties struct {
	Identity *UserAssignedIdentityProperties `json:"identity,omitempty"`

	// Name of the Key from KeyVault
	KeyName *string `json:"keyName,omitempty"`

	// Uri of KeyVault
	KeyVaultURI *string `json:"keyVaultUri,omitempty"`

	// Version of KeyVault
	KeyVersion *string `json:"keyVersion,omitempty"`
}

// MessageCountDetails - Message Count Details.
type MessageCountDetails struct {
	// READ-ONLY; Number of active messages in the queue, topic, or subscription.
	ActiveMessageCount *int64 `json:"activeMessageCount,omitempty" azure:"ro"`

	// READ-ONLY; Number of messages that are dead lettered.
	DeadLetterMessageCount *int64 `json:"deadLetterMessageCount,omitempty" azure:"ro"`

	// READ-ONLY; Number of scheduled messages.
	ScheduledMessageCount *int64 `json:"scheduledMessageCount,omitempty" azure:"ro"`

	// READ-ONLY; Number of messages transferred into dead letters.
	TransferDeadLetterMessageCount *int64 `json:"transferDeadLetterMessageCount,omitempty" azure:"ro"`

	// READ-ONLY; Number of messages transferred to another queue, topic, or subscription.
	TransferMessageCount *int64 `json:"transferMessageCount,omitempty" azure:"ro"`
}

// MigrationConfigListResult - The result of the List migrationConfigurations operation.
type MigrationConfigListResult struct {
	// List of Migration Configs
	Value []*MigrationConfigProperties `json:"value,omitempty"`

	// READ-ONLY; Link to the next set of results. Not empty if Value contains incomplete list of migrationConfigurations
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// MigrationConfigProperties - Single item in List or Get Migration Config operation
type MigrationConfigProperties struct {
	// Properties required to the Create Migration Configuration
	Properties *MigrationConfigPropertiesProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The geo-location where the resource lives
	Location *string `json:"location,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The system meta data relating to this resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.EventHub/Namespaces" or "Microsoft.EventHub/Namespaces/EventHubs"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// MigrationConfigPropertiesProperties - Properties required to the Create Migration Configuration
type MigrationConfigPropertiesProperties struct {
	// REQUIRED; Name to access Standard Namespace after migration
	PostMigrationName *string `json:"postMigrationName,omitempty"`

	// REQUIRED; Existing premium Namespace ARM Id name which has no entities, will be used for migration
	TargetNamespace *string `json:"targetNamespace,omitempty"`

	// READ-ONLY; State in which Standard to Premium Migration is, possible values : Unknown, Reverting, Completing, Initiating,
	// Syncing, Active
	MigrationState *string `json:"migrationState,omitempty" azure:"ro"`

	// READ-ONLY; Number of entities pending to be replicated.
	PendingReplicationOperationsCount *int64 `json:"pendingReplicationOperationsCount,omitempty" azure:"ro"`

	// READ-ONLY; Provisioning state of Migration Configuration
	ProvisioningState *string `json:"provisioningState,omitempty" azure:"ro"`
}

// MigrationConfigsClientBeginCreateAndStartMigrationOptions contains the optional parameters for the MigrationConfigsClient.BeginCreateAndStartMigration
// method.
type MigrationConfigsClientBeginCreateAndStartMigrationOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// MigrationConfigsClientCompleteMigrationOptions contains the optional parameters for the MigrationConfigsClient.CompleteMigration
// method.
type MigrationConfigsClientCompleteMigrationOptions struct {
	// placeholder for future optional parameters
}

// MigrationConfigsClientDeleteOptions contains the optional parameters for the MigrationConfigsClient.Delete method.
type MigrationConfigsClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// MigrationConfigsClientGetOptions contains the optional parameters for the MigrationConfigsClient.Get method.
type MigrationConfigsClientGetOptions struct {
	// placeholder for future optional parameters
}

// MigrationConfigsClientListOptions contains the optional parameters for the MigrationConfigsClient.List method.
type MigrationConfigsClientListOptions struct {
	// placeholder for future optional parameters
}

// MigrationConfigsClientRevertOptions contains the optional parameters for the MigrationConfigsClient.Revert method.
type MigrationConfigsClientRevertOptions struct {
	// placeholder for future optional parameters
}

// NWRuleSetIPRules - Description of NetWorkRuleSet - IpRules resource.
type NWRuleSetIPRules struct {
	// The IP Filter Action
	Action *NetworkRuleIPAction `json:"action,omitempty"`

	// IP Mask
	IPMask *string `json:"ipMask,omitempty"`
}

// NWRuleSetVirtualNetworkRules - Description of VirtualNetworkRules - NetworkRules resource.
type NWRuleSetVirtualNetworkRules struct {
	// Value that indicates whether to ignore missing VNet Service Endpoint
	IgnoreMissingVnetServiceEndpoint *bool `json:"ignoreMissingVnetServiceEndpoint,omitempty"`

	// Subnet properties
	Subnet *Subnet `json:"subnet,omitempty"`
}

// NamespacesClientBeginCreateOrUpdateOptions contains the optional parameters for the NamespacesClient.BeginCreateOrUpdate
// method.
type NamespacesClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// NamespacesClientBeginDeleteOptions contains the optional parameters for the NamespacesClient.BeginDelete method.
type NamespacesClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// NamespacesClientCheckNameAvailabilityOptions contains the optional parameters for the NamespacesClient.CheckNameAvailability
// method.
type NamespacesClientCheckNameAvailabilityOptions struct {
	// placeholder for future optional parameters
}

// NamespacesClientCreateOrUpdateAuthorizationRuleOptions contains the optional parameters for the NamespacesClient.CreateOrUpdateAuthorizationRule
// method.
type NamespacesClientCreateOrUpdateAuthorizationRuleOptions struct {
	// placeholder for future optional parameters
}

// NamespacesClientCreateOrUpdateNetworkRuleSetOptions contains the optional parameters for the NamespacesClient.CreateOrUpdateNetworkRuleSet
// method.
type NamespacesClientCreateOrUpdateNetworkRuleSetOptions struct {
	// placeholder for future optional parameters
}

// NamespacesClientDeleteAuthorizationRuleOptions contains the optional parameters for the NamespacesClient.DeleteAuthorizationRule
// method.
type NamespacesClientDeleteAuthorizationRuleOptions struct {
	// placeholder for future optional parameters
}

// NamespacesClientGetAuthorizationRuleOptions contains the optional parameters for the NamespacesClient.GetAuthorizationRule
// method.
type NamespacesClientGetAuthorizationRuleOptions struct {
	// placeholder for future optional parameters
}

// NamespacesClientGetNetworkRuleSetOptions contains the optional parameters for the NamespacesClient.GetNetworkRuleSet method.
type NamespacesClientGetNetworkRuleSetOptions struct {
	// placeholder for future optional parameters
}

// NamespacesClientGetOptions contains the optional parameters for the NamespacesClient.Get method.
type NamespacesClientGetOptions struct {
	// placeholder for future optional parameters
}

// NamespacesClientListAuthorizationRulesOptions contains the optional parameters for the NamespacesClient.ListAuthorizationRules
// method.
type NamespacesClientListAuthorizationRulesOptions struct {
	// placeholder for future optional parameters
}

// NamespacesClientListByResourceGroupOptions contains the optional parameters for the NamespacesClient.ListByResourceGroup
// method.
type NamespacesClientListByResourceGroupOptions struct {
	// placeholder for future optional parameters
}

// NamespacesClientListKeysOptions contains the optional parameters for the NamespacesClient.ListKeys method.
type NamespacesClientListKeysOptions struct {
	// placeholder for future optional parameters
}

// NamespacesClientListNetworkRuleSetsOptions contains the optional parameters for the NamespacesClient.ListNetworkRuleSets
// method.
type NamespacesClientListNetworkRuleSetsOptions struct {
	// placeholder for future optional parameters
}

// NamespacesClientListOptions contains the optional parameters for the NamespacesClient.List method.
type NamespacesClientListOptions struct {
	// placeholder for future optional parameters
}

// NamespacesClientRegenerateKeysOptions contains the optional parameters for the NamespacesClient.RegenerateKeys method.
type NamespacesClientRegenerateKeysOptions struct {
	// placeholder for future optional parameters
}

// NamespacesClientUpdateOptions contains the optional parameters for the NamespacesClient.Update method.
type NamespacesClientUpdateOptions struct {
	// placeholder for future optional parameters
}

// NetworkRuleSet - Description of NetworkRuleSet resource.
type NetworkRuleSet struct {
	// NetworkRuleSet properties
	Properties *NetworkRuleSetProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The geo-location where the resource lives
	Location *string `json:"location,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The system meta data relating to this resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.EventHub/Namespaces" or "Microsoft.EventHub/Namespaces/EventHubs"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// NetworkRuleSetListResult - The response of the List NetworkRuleSet operation.
type NetworkRuleSetListResult struct {
	// Link to the next set of results. Not empty if Value contains incomplete list of NetworkRuleSet.
	NextLink *string `json:"nextLink,omitempty"`

	// Result of the List NetworkRuleSet operation.
	Value []*NetworkRuleSet `json:"value,omitempty"`
}

// NetworkRuleSetProperties - NetworkRuleSet properties
type NetworkRuleSetProperties struct {
	// Default Action for Network Rule Set
	DefaultAction *DefaultAction `json:"defaultAction,omitempty"`

	// List of IpRules
	IPRules []*NWRuleSetIPRules `json:"ipRules,omitempty"`

	// This determines if traffic is allowed over public network. By default it is enabled.
	PublicNetworkAccess *PublicNetworkAccessFlag `json:"publicNetworkAccess,omitempty"`

	// Value that indicates whether Trusted Service Access is Enabled or not.
	TrustedServiceAccessEnabled *bool `json:"trustedServiceAccessEnabled,omitempty"`

	// List VirtualNetwork Rules
	VirtualNetworkRules []*NWRuleSetVirtualNetworkRules `json:"virtualNetworkRules,omitempty"`
}

// Operation - A Service Bus REST API operation
type Operation struct {
	// Display of the operation
	Display *OperationDisplay `json:"display,omitempty"`

	// Indicates whether the operation is a data action
	IsDataAction *bool `json:"isDataAction,omitempty"`

	// Origin of the operation
	Origin *string `json:"origin,omitempty"`

	// Properties of the operation
	Properties interface{} `json:"properties,omitempty"`

	// READ-ONLY; Operation name: {provider}/{resource}/{operation}
	Name *string `json:"name,omitempty" azure:"ro"`
}

// OperationDisplay - Operation display payload
type OperationDisplay struct {
	// READ-ONLY; Localized friendly description for the operation
	Description *string `json:"description,omitempty" azure:"ro"`

	// READ-ONLY; Localized friendly name for the operation
	Operation *string `json:"operation,omitempty" azure:"ro"`

	// READ-ONLY; Resource provider of the operation
	Provider *string `json:"provider,omitempty" azure:"ro"`

	// READ-ONLY; Resource of the operation
	Resource *string `json:"resource,omitempty" azure:"ro"`
}

// OperationListResult - Result of the request to list ServiceBus operations. It contains a list of operations and a URL link
// to get the next set of results.
type OperationListResult struct {
	// READ-ONLY; URL to get the next set of operation list results if there are any.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; List of ServiceBus operations supported by the Microsoft.ServiceBus resource provider.
	Value []*Operation `json:"value,omitempty" azure:"ro"`
}

// OperationsClientListOptions contains the optional parameters for the OperationsClient.List method.
type OperationsClientListOptions struct {
	// placeholder for future optional parameters
}

// PrivateEndpoint information.
type PrivateEndpoint struct {
	// The ARM identifier for Private Endpoint.
	ID *string `json:"id,omitempty"`
}

// PrivateEndpointConnection - Properties of the PrivateEndpointConnection.
type PrivateEndpointConnection struct {
	// Properties of the PrivateEndpointConnection.
	Properties *PrivateEndpointConnectionProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The geo-location where the resource lives
	Location *string `json:"location,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The system meta data relating to this resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.EventHub/Namespaces" or "Microsoft.EventHub/Namespaces/EventHubs"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// PrivateEndpointConnectionListResult - Result of the list of all private endpoint connections operation.
type PrivateEndpointConnectionListResult struct {
	// A link for the next page of private endpoint connection resources.
	NextLink *string `json:"nextLink,omitempty"`

	// A collection of private endpoint connection resources.
	Value []*PrivateEndpointConnection `json:"value,omitempty"`
}

// PrivateEndpointConnectionProperties - Properties of the private endpoint connection resource.
type PrivateEndpointConnectionProperties struct {
	// The Private Endpoint resource for this Connection.
	PrivateEndpoint *PrivateEndpoint `json:"privateEndpoint,omitempty"`

	// Details about the state of the connection.
	PrivateLinkServiceConnectionState *ConnectionState `json:"privateLinkServiceConnectionState,omitempty"`

	// Provisioning state of the Private Endpoint Connection.
	ProvisioningState *EndPointProvisioningState `json:"provisioningState,omitempty"`
}

// PrivateEndpointConnectionsClientBeginDeleteOptions contains the optional parameters for the PrivateEndpointConnectionsClient.BeginDelete
// method.
type PrivateEndpointConnectionsClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// PrivateEndpointConnectionsClientCreateOrUpdateOptions contains the optional parameters for the PrivateEndpointConnectionsClient.CreateOrUpdate
// method.
type PrivateEndpointConnectionsClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// PrivateEndpointConnectionsClientGetOptions contains the optional parameters for the PrivateEndpointConnectionsClient.Get
// method.
type PrivateEndpointConnectionsClientGetOptions struct {
	// placeholder for future optional parameters
}

// PrivateEndpointConnectionsClientListOptions contains the optional parameters for the PrivateEndpointConnectionsClient.List
// method.
type PrivateEndpointConnectionsClientListOptions struct {
	// placeholder for future optional parameters
}

// PrivateLinkResource - Information of the private link resource.
type PrivateLinkResource struct {
	// Fully qualified identifier of the resource.
	ID *string `json:"id,omitempty"`

	// Name of the resource
	Name *string `json:"name,omitempty"`

	// Properties of the private link resource.
	Properties *PrivateLinkResourceProperties `json:"properties,omitempty"`

	// Type of the resource
	Type *string `json:"type,omitempty"`
}

// PrivateLinkResourceProperties - Properties of PrivateLinkResource
type PrivateLinkResourceProperties struct {
	GroupID *string `json:"groupId,omitempty"`

	// Required Members
	RequiredMembers []*string `json:"requiredMembers,omitempty"`

	// Required Zone Names
	RequiredZoneNames []*string `json:"requiredZoneNames,omitempty"`
}

// PrivateLinkResourcesClientGetOptions contains the optional parameters for the PrivateLinkResourcesClient.Get method.
type PrivateLinkResourcesClientGetOptions struct {
	// placeholder for future optional parameters
}

// PrivateLinkResourcesListResult - Result of the List private link resources operation.
type PrivateLinkResourcesListResult struct {
	// A link for the next page of private link resources.
	NextLink *string `json:"nextLink,omitempty"`

	// A collection of private link resources
	Value []*PrivateLinkResource `json:"value,omitempty"`
}

// ProxyResource - Common fields that are returned in the response for all Azure Resource Manager resources
type ProxyResource struct {
	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The geo-location where the resource lives
	Location *string `json:"location,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.EventHub/Namespaces" or "Microsoft.EventHub/Namespaces/EventHubs"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// QueuesClientCreateOrUpdateAuthorizationRuleOptions contains the optional parameters for the QueuesClient.CreateOrUpdateAuthorizationRule
// method.
type QueuesClientCreateOrUpdateAuthorizationRuleOptions struct {
	// placeholder for future optional parameters
}

// QueuesClientCreateOrUpdateOptions contains the optional parameters for the QueuesClient.CreateOrUpdate method.
type QueuesClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// QueuesClientDeleteAuthorizationRuleOptions contains the optional parameters for the QueuesClient.DeleteAuthorizationRule
// method.
type QueuesClientDeleteAuthorizationRuleOptions struct {
	// placeholder for future optional parameters
}

// QueuesClientDeleteOptions contains the optional parameters for the QueuesClient.Delete method.
type QueuesClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// QueuesClientGetAuthorizationRuleOptions contains the optional parameters for the QueuesClient.GetAuthorizationRule method.
type QueuesClientGetAuthorizationRuleOptions struct {
	// placeholder for future optional parameters
}

// QueuesClientGetOptions contains the optional parameters for the QueuesClient.Get method.
type QueuesClientGetOptions struct {
	// placeholder for future optional parameters
}

// QueuesClientListAuthorizationRulesOptions contains the optional parameters for the QueuesClient.ListAuthorizationRules
// method.
type QueuesClientListAuthorizationRulesOptions struct {
	// placeholder for future optional parameters
}

// QueuesClientListByNamespaceOptions contains the optional parameters for the QueuesClient.ListByNamespace method.
type QueuesClientListByNamespaceOptions struct {
	// Skip is only used if a previous operation returned a partial result. If a previous response contains a nextLink element,
	// the value of the nextLink element will include a skip parameter that specifies
	// a starting point to use for subsequent calls.
	Skip *int32
	// May be used to limit the number of results to the most recent N usageDetails.
	Top *int32
}

// QueuesClientListKeysOptions contains the optional parameters for the QueuesClient.ListKeys method.
type QueuesClientListKeysOptions struct {
	// placeholder for future optional parameters
}

// QueuesClientRegenerateKeysOptions contains the optional parameters for the QueuesClient.RegenerateKeys method.
type QueuesClientRegenerateKeysOptions struct {
	// placeholder for future optional parameters
}

// RegenerateAccessKeyParameters - Parameters supplied to the Regenerate Authorization Rule operation, specifies which key
// needs to be reset.
type RegenerateAccessKeyParameters struct {
	// REQUIRED; The access key to regenerate.
	KeyType *KeyType `json:"keyType,omitempty"`

	// Optional, if the key value provided, is reset for KeyType value or autogenerate Key value set for keyType
	Key *string `json:"key,omitempty"`
}

// Resource - The Resource definition for other than namespace.
type Resource struct {
	// READ-ONLY; Resource Id
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ResourceNamespacePatch - The Resource definition.
type ResourceNamespacePatch struct {
	// Resource location
	Location *string `json:"location,omitempty"`

	// Resource tags
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Resource Id
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type
	Type *string `json:"type,omitempty" azure:"ro"`
}

// Rule - Description of Rule Resource.
type Rule struct {
	// Properties of Rule resource
	Properties *Ruleproperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The geo-location where the resource lives
	Location *string `json:"location,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The system meta data relating to this resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.EventHub/Namespaces" or "Microsoft.EventHub/Namespaces/EventHubs"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// RuleListResult - The response of the List rule operation.
type RuleListResult struct {
	// Link to the next set of results. Not empty if Value contains incomplete list of rules
	NextLink *string `json:"nextLink,omitempty"`

	// Result of the List Rules operation.
	Value []*Rule `json:"value,omitempty"`
}

// Ruleproperties - Description of Rule Resource.
type Ruleproperties struct {
	// Represents the filter actions which are allowed for the transformation of a message that have been matched by a filter
	// expression.
	Action *Action `json:"action,omitempty"`

	// Properties of correlationFilter
	CorrelationFilter *CorrelationFilter `json:"correlationFilter,omitempty"`

	// Filter type that is evaluated against a BrokeredMessage.
	FilterType *FilterType `json:"filterType,omitempty"`

	// Properties of sqlFilter
	SQLFilter *SQLFilter `json:"sqlFilter,omitempty"`
}

// RulesClientCreateOrUpdateOptions contains the optional parameters for the RulesClient.CreateOrUpdate method.
type RulesClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// RulesClientDeleteOptions contains the optional parameters for the RulesClient.Delete method.
type RulesClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// RulesClientGetOptions contains the optional parameters for the RulesClient.Get method.
type RulesClientGetOptions struct {
	// placeholder for future optional parameters
}

// RulesClientListBySubscriptionsOptions contains the optional parameters for the RulesClient.ListBySubscriptions method.
type RulesClientListBySubscriptionsOptions struct {
	// Skip is only used if a previous operation returned a partial result. If a previous response contains a nextLink element,
	// the value of the nextLink element will include a skip parameter that specifies
	// a starting point to use for subsequent calls.
	Skip *int32
	// May be used to limit the number of results to the most recent N usageDetails.
	Top *int32
}

// SBAuthorizationRule - Description of a namespace authorization rule.
type SBAuthorizationRule struct {
	// AuthorizationRule properties.
	Properties *SBAuthorizationRuleProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The geo-location where the resource lives
	Location *string `json:"location,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The system meta data relating to this resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.EventHub/Namespaces" or "Microsoft.EventHub/Namespaces/EventHubs"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// SBAuthorizationRuleListResult - The response to the List Namespace operation.
type SBAuthorizationRuleListResult struct {
	// Link to the next set of results. Not empty if Value contains incomplete list of Authorization Rules.
	NextLink *string `json:"nextLink,omitempty"`

	// Result of the List Authorization Rules operation.
	Value []*SBAuthorizationRule `json:"value,omitempty"`
}

// SBAuthorizationRuleProperties - AuthorizationRule properties.
type SBAuthorizationRuleProperties struct {
	// REQUIRED; The rights associated with the rule.
	Rights []*AccessRights `json:"rights,omitempty"`
}

// SBClientAffineProperties - Properties specific to client affine subscriptions.
type SBClientAffineProperties struct {
	// Indicates the Client ID of the application that created the client-affine subscription.
	ClientID *string `json:"clientId,omitempty"`

	// For client-affine subscriptions, this value indicates whether the subscription is durable or not.
	IsDurable *bool `json:"isDurable,omitempty"`

	// For client-affine subscriptions, this value indicates whether the subscription is shared or not.
	IsShared *bool `json:"isShared,omitempty"`
}

// SBNamespace - Description of a namespace resource.
type SBNamespace struct {
	// REQUIRED; The Geo-location where the resource lives
	Location *string `json:"location,omitempty"`

	// Properties of BYOK Identity description
	Identity *Identity `json:"identity,omitempty"`

	// Properties of the namespace.
	Properties *SBNamespaceProperties `json:"properties,omitempty"`

	// Properties of SKU
	SKU *SBSKU `json:"sku,omitempty"`

	// Resource tags
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Resource Id
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The system meta data relating to this resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; Resource type
	Type *string `json:"type,omitempty" azure:"ro"`
}

// SBNamespaceListResult - The response of the List Namespace operation.
type SBNamespaceListResult struct {
	// Link to the next set of results. Not empty if Value contains incomplete list of Namespaces.
	NextLink *string `json:"nextLink,omitempty"`

	// Result of the List Namespace operation.
	Value []*SBNamespace `json:"value,omitempty"`
}

// SBNamespaceProperties - Properties of the namespace.
type SBNamespaceProperties struct {
	// Alternate name for namespace
	AlternateName *string `json:"alternateName,omitempty"`

	// This property disables SAS authentication for the Service Bus namespace.
	DisableLocalAuth *bool `json:"disableLocalAuth,omitempty"`

	// Properties of BYOK Encryption description
	Encryption *Encryption `json:"encryption,omitempty"`

	// The minimum TLS version for the cluster to support, e.g. '1.2'
	MinimumTLSVersion *TLSVersion `json:"minimumTlsVersion,omitempty"`

	// List of private endpoint connections.
	PrivateEndpointConnections []*PrivateEndpointConnection `json:"privateEndpointConnections,omitempty"`

	// This determines if traffic is allowed over public network. By default it is enabled.
	PublicNetworkAccess *PublicNetworkAccess `json:"publicNetworkAccess,omitempty"`

	// Enabling this property creates a Premium Service Bus Namespace in regions supported availability zones.
	ZoneRedundant *bool `json:"zoneRedundant,omitempty"`

	// READ-ONLY; The time the namespace was created
	CreatedAt *time.Time `json:"createdAt,omitempty" azure:"ro"`

	// READ-ONLY; Identifier for Azure Insights metrics
	MetricID *string `json:"metricId,omitempty" azure:"ro"`

	// READ-ONLY; Provisioning state of the namespace.
	ProvisioningState *string `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; Endpoint you can use to perform Service Bus operations.
	ServiceBusEndpoint *string `json:"serviceBusEndpoint,omitempty" azure:"ro"`

	// READ-ONLY; Status of the namespace.
	Status *string `json:"status,omitempty" azure:"ro"`

	// READ-ONLY; The time the namespace was updated.
	UpdatedAt *time.Time `json:"updatedAt,omitempty" azure:"ro"`
}

// SBNamespaceUpdateParameters - Description of a namespace resource.
type SBNamespaceUpdateParameters struct {
	// Properties of BYOK Identity description
	Identity *Identity `json:"identity,omitempty"`

	// Resource location
	Location *string `json:"location,omitempty"`

	// Properties of the namespace.
	Properties *SBNamespaceUpdateProperties `json:"properties,omitempty"`

	// Properties of SKU
	SKU *SBSKU `json:"sku,omitempty"`

	// Resource tags
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Resource Id
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type
	Type *string `json:"type,omitempty" azure:"ro"`
}

// SBNamespaceUpdateProperties - Properties of the namespace.
type SBNamespaceUpdateProperties struct {
	// Alternate name for namespace
	AlternateName *string `json:"alternateName,omitempty"`

	// This property disables SAS authentication for the Service Bus namespace.
	DisableLocalAuth *bool `json:"disableLocalAuth,omitempty"`

	// Properties of BYOK Encryption description
	Encryption *Encryption `json:"encryption,omitempty"`

	// List of private endpoint connections.
	PrivateEndpointConnections []*PrivateEndpointConnection `json:"privateEndpointConnections,omitempty"`

	// READ-ONLY; The time the namespace was created
	CreatedAt *time.Time `json:"createdAt,omitempty" azure:"ro"`

	// READ-ONLY; Identifier for Azure Insights metrics
	MetricID *string `json:"metricId,omitempty" azure:"ro"`

	// READ-ONLY; Provisioning state of the namespace.
	ProvisioningState *string `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; Endpoint you can use to perform Service Bus operations.
	ServiceBusEndpoint *string `json:"serviceBusEndpoint,omitempty" azure:"ro"`

	// READ-ONLY; Status of the namespace.
	Status *string `json:"status,omitempty" azure:"ro"`

	// READ-ONLY; The time the namespace was updated.
	UpdatedAt *time.Time `json:"updatedAt,omitempty" azure:"ro"`
}

// SBQueue - Description of queue Resource.
type SBQueue struct {
	// Queue Properties
	Properties *SBQueueProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The geo-location where the resource lives
	Location *string `json:"location,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The system meta data relating to this resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.EventHub/Namespaces" or "Microsoft.EventHub/Namespaces/EventHubs"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// SBQueueListResult - The response to the List Queues operation.
type SBQueueListResult struct {
	// Link to the next set of results. Not empty if Value contains incomplete list of queues.
	NextLink *string `json:"nextLink,omitempty"`

	// Result of the List Queues operation.
	Value []*SBQueue `json:"value,omitempty"`
}

// SBQueueProperties - The Queue Properties definition.
type SBQueueProperties struct {
	// ISO 8061 timeSpan idle interval after which the queue is automatically deleted. The minimum duration is 5 minutes.
	AutoDeleteOnIdle *string `json:"autoDeleteOnIdle,omitempty"`

	// A value that indicates whether this queue has dead letter support when a message expires.
	DeadLetteringOnMessageExpiration *bool `json:"deadLetteringOnMessageExpiration,omitempty"`

	// ISO 8601 default message timespan to live value. This is the duration after which the message expires, starting from when
	// the message is sent to Service Bus. This is the default value used when
	// TimeToLive is not set on a message itself.
	DefaultMessageTimeToLive *string `json:"defaultMessageTimeToLive,omitempty"`

	// ISO 8601 timeSpan structure that defines the duration of the duplicate detection history. The default value is 10 minutes.
	DuplicateDetectionHistoryTimeWindow *string `json:"duplicateDetectionHistoryTimeWindow,omitempty"`

	// Value that indicates whether server-side batched operations are enabled.
	EnableBatchedOperations *bool `json:"enableBatchedOperations,omitempty"`

	// A value that indicates whether Express Entities are enabled. An express queue holds a message in memory temporarily before
	// writing it to persistent storage.
	EnableExpress *bool `json:"enableExpress,omitempty"`

	// A value that indicates whether the queue is to be partitioned across multiple message brokers.
	EnablePartitioning *bool `json:"enablePartitioning,omitempty"`

	// Queue/Topic name to forward the Dead Letter message
	ForwardDeadLetteredMessagesTo *string `json:"forwardDeadLetteredMessagesTo,omitempty"`

	// Queue/Topic name to forward the messages
	ForwardTo *string `json:"forwardTo,omitempty"`

	// ISO 8601 timespan duration of a peek-lock; that is, the amount of time that the message is locked for other receivers.
	// The maximum value for LockDuration is 5 minutes; the default value is 1 minute.
	LockDuration *string `json:"lockDuration,omitempty"`

	// The maximum delivery count. A message is automatically deadlettered after this number of deliveries. default value is 10.
	MaxDeliveryCount *int32 `json:"maxDeliveryCount,omitempty"`

	// Maximum size (in KB) of the message payload that can be accepted by the queue. This property is only used in Premium today
	// and default is 1024.
	MaxMessageSizeInKilobytes *int64 `json:"maxMessageSizeInKilobytes,omitempty"`

	// The maximum size of the queue in megabytes, which is the size of memory allocated for the queue. Default is 1024.
	MaxSizeInMegabytes *int32 `json:"maxSizeInMegabytes,omitempty"`

	// A value indicating if this queue requires duplicate detection.
	RequiresDuplicateDetection *bool `json:"requiresDuplicateDetection,omitempty"`

	// A value that indicates whether the queue supports the concept of sessions.
	RequiresSession *bool `json:"requiresSession,omitempty"`

	// Enumerates the possible values for the status of a messaging entity.
	Status *EntityStatus `json:"status,omitempty"`

	// READ-ONLY; Last time a message was sent, or the last time there was a receive request to this queue.
	AccessedAt *time.Time `json:"accessedAt,omitempty" azure:"ro"`

	// READ-ONLY; Message Count Details.
	CountDetails *MessageCountDetails `json:"countDetails,omitempty" azure:"ro"`

	// READ-ONLY; The exact time the message was created.
	CreatedAt *time.Time `json:"createdAt,omitempty" azure:"ro"`

	// READ-ONLY; The number of messages in the queue.
	MessageCount *int64 `json:"messageCount,omitempty" azure:"ro"`

	// READ-ONLY; The size of the queue, in bytes.
	SizeInBytes *int64 `json:"sizeInBytes,omitempty" azure:"ro"`

	// READ-ONLY; The exact time the message was updated.
	UpdatedAt *time.Time `json:"updatedAt,omitempty" azure:"ro"`
}

// SBSKU - SKU of the namespace.
type SBSKU struct {
	// REQUIRED; Name of this SKU.
	Name *SKUName `json:"name,omitempty"`

	// The specified messaging units for the tier. For Premium tier, capacity are 1,2 and 4.
	Capacity *int32 `json:"capacity,omitempty"`

	// The billing tier of this particular SKU.
	Tier *SKUTier `json:"tier,omitempty"`
}

// SBSubscription - Description of subscription resource.
type SBSubscription struct {
	// Properties of subscriptions resource.
	Properties *SBSubscriptionProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The geo-location where the resource lives
	Location *string `json:"location,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The system meta data relating to this resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.EventHub/Namespaces" or "Microsoft.EventHub/Namespaces/EventHubs"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// SBSubscriptionListResult - The response to the List Subscriptions operation.
type SBSubscriptionListResult struct {
	// Link to the next set of results. Not empty if Value contains incomplete list of subscriptions.
	NextLink *string `json:"nextLink,omitempty"`

	// Result of the List Subscriptions operation.
	Value []*SBSubscription `json:"value,omitempty"`
}

// SBSubscriptionProperties - Description of Subscription Resource.
type SBSubscriptionProperties struct {
	// ISO 8061 timeSpan idle interval after which the topic is automatically deleted. The minimum duration is 5 minutes.
	AutoDeleteOnIdle *string `json:"autoDeleteOnIdle,omitempty"`

	// Properties specific to client affine subscriptions.
	ClientAffineProperties *SBClientAffineProperties `json:"clientAffineProperties,omitempty"`

	// Value that indicates whether a subscription has dead letter support on filter evaluation exceptions.
	DeadLetteringOnFilterEvaluationExceptions *bool `json:"deadLetteringOnFilterEvaluationExceptions,omitempty"`

	// Value that indicates whether a subscription has dead letter support when a message expires.
	DeadLetteringOnMessageExpiration *bool `json:"deadLetteringOnMessageExpiration,omitempty"`

	// ISO 8061 Default message timespan to live value. This is the duration after which the message expires, starting from when
	// the message is sent to Service Bus. This is the default value used when
	// TimeToLive is not set on a message itself.
	DefaultMessageTimeToLive *string `json:"defaultMessageTimeToLive,omitempty"`

	// ISO 8601 timeSpan structure that defines the duration of the duplicate detection history. The default value is 10 minutes.
	DuplicateDetectionHistoryTimeWindow *string `json:"duplicateDetectionHistoryTimeWindow,omitempty"`

	// Value that indicates whether server-side batched operations are enabled.
	EnableBatchedOperations *bool `json:"enableBatchedOperations,omitempty"`

	// Queue/Topic name to forward the Dead Letter message
	ForwardDeadLetteredMessagesTo *string `json:"forwardDeadLetteredMessagesTo,omitempty"`

	// Queue/Topic name to forward the messages
	ForwardTo *string `json:"forwardTo,omitempty"`

	// Value that indicates whether the subscription has an affinity to the client id.
	IsClientAffine *bool `json:"isClientAffine,omitempty"`

	// ISO 8061 lock duration timespan for the subscription. The default value is 1 minute.
	LockDuration *string `json:"lockDuration,omitempty"`

	// Number of maximum deliveries.
	MaxDeliveryCount *int32 `json:"maxDeliveryCount,omitempty"`

	// Value indicating if a subscription supports the concept of sessions.
	RequiresSession *bool `json:"requiresSession,omitempty"`

	// Enumerates the possible values for the status of a messaging entity.
	Status *EntityStatus `json:"status,omitempty"`

	// READ-ONLY; Last time there was a receive request to this subscription.
	AccessedAt *time.Time `json:"accessedAt,omitempty" azure:"ro"`

	// READ-ONLY; Message count details
	CountDetails *MessageCountDetails `json:"countDetails,omitempty" azure:"ro"`

	// READ-ONLY; Exact time the message was created.
	CreatedAt *time.Time `json:"createdAt,omitempty" azure:"ro"`

	// READ-ONLY; Number of messages.
	MessageCount *int64 `json:"messageCount,omitempty" azure:"ro"`

	// READ-ONLY; The exact time the message was updated.
	UpdatedAt *time.Time `json:"updatedAt,omitempty" azure:"ro"`
}

// SBTopic - Description of topic resource.
type SBTopic struct {
	// Properties of topic resource.
	Properties *SBTopicProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The geo-location where the resource lives
	Location *string `json:"location,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The system meta data relating to this resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.EventHub/Namespaces" or "Microsoft.EventHub/Namespaces/EventHubs"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// SBTopicListResult - The response to the List Topics operation.
type SBTopicListResult struct {
	// Link to the next set of results. Not empty if Value contains incomplete list of topics.
	NextLink *string `json:"nextLink,omitempty"`

	// Result of the List Topics operation.
	Value []*SBTopic `json:"value,omitempty"`
}

// SBTopicProperties - The Topic Properties definition.
type SBTopicProperties struct {
	// ISO 8601 timespan idle interval after which the topic is automatically deleted. The minimum duration is 5 minutes.
	AutoDeleteOnIdle *string `json:"autoDeleteOnIdle,omitempty"`

	// ISO 8601 Default message timespan to live value. This is the duration after which the message expires, starting from when
	// the message is sent to Service Bus. This is the default value used when
	// TimeToLive is not set on a message itself.
	DefaultMessageTimeToLive *string `json:"defaultMessageTimeToLive,omitempty"`

	// ISO8601 timespan structure that defines the duration of the duplicate detection history. The default value is 10 minutes.
	DuplicateDetectionHistoryTimeWindow *string `json:"duplicateDetectionHistoryTimeWindow,omitempty"`

	// Value that indicates whether server-side batched operations are enabled.
	EnableBatchedOperations *bool `json:"enableBatchedOperations,omitempty"`

	// Value that indicates whether Express Entities are enabled. An express topic holds a message in memory temporarily before
	// writing it to persistent storage.
	EnableExpress *bool `json:"enableExpress,omitempty"`

	// Value that indicates whether the topic to be partitioned across multiple message brokers is enabled.
	EnablePartitioning *bool `json:"enablePartitioning,omitempty"`

	// Maximum size (in KB) of the message payload that can be accepted by the topic. This property is only used in Premium today
	// and default is 1024.
	MaxMessageSizeInKilobytes *int64 `json:"maxMessageSizeInKilobytes,omitempty"`

	// Maximum size of the topic in megabytes, which is the size of the memory allocated for the topic. Default is 1024.
	MaxSizeInMegabytes *int32 `json:"maxSizeInMegabytes,omitempty"`

	// Value indicating if this topic requires duplicate detection.
	RequiresDuplicateDetection *bool `json:"requiresDuplicateDetection,omitempty"`

	// Enumerates the possible values for the status of a messaging entity.
	Status *EntityStatus `json:"status,omitempty"`

	// Value that indicates whether the topic supports ordering.
	SupportOrdering *bool `json:"supportOrdering,omitempty"`

	// READ-ONLY; Last time the message was sent, or a request was received, for this topic.
	AccessedAt *time.Time `json:"accessedAt,omitempty" azure:"ro"`

	// READ-ONLY; Message count details
	CountDetails *MessageCountDetails `json:"countDetails,omitempty" azure:"ro"`

	// READ-ONLY; Exact time the message was created.
	CreatedAt *time.Time `json:"createdAt,omitempty" azure:"ro"`

	// READ-ONLY; Size of the topic, in bytes.
	SizeInBytes *int64 `json:"sizeInBytes,omitempty" azure:"ro"`

	// READ-ONLY; Number of subscriptions.
	SubscriptionCount *int32 `json:"subscriptionCount,omitempty" azure:"ro"`

	// READ-ONLY; The exact time the message was updated.
	UpdatedAt *time.Time `json:"updatedAt,omitempty" azure:"ro"`
}

// SQLFilter - Represents a filter which is a composition of an expression and an action that is executed in the pub/sub pipeline.
type SQLFilter struct {
	// This property is reserved for future use. An integer value showing the compatibility level, currently hard-coded to 20.
	CompatibilityLevel *int32 `json:"compatibilityLevel,omitempty"`

	// Value that indicates whether the rule action requires preprocessing.
	RequiresPreprocessing *bool `json:"requiresPreprocessing,omitempty"`

	// The SQL expression. e.g. MyProperty='ABC'
	SQLExpression *string `json:"sqlExpression,omitempty"`
}

// SQLRuleAction - Represents set of actions written in SQL language-based syntax that is performed against a ServiceBus.Messaging.BrokeredMessage
type SQLRuleAction struct {
	// This property is reserved for future use. An integer value showing the compatibility level, currently hard-coded to 20.
	CompatibilityLevel *int32 `json:"compatibilityLevel,omitempty"`

	// Value that indicates whether the rule action requires preprocessing.
	RequiresPreprocessing *bool `json:"requiresPreprocessing,omitempty"`

	// SQL expression. e.g. MyProperty='ABC'
	SQLExpression *string `json:"sqlExpression,omitempty"`
}

// Subnet - Properties supplied for Subnet
type Subnet struct {
	// REQUIRED; Resource ID of Virtual Network Subnet
	ID *string `json:"id,omitempty"`
}

// SubscriptionsClientCreateOrUpdateOptions contains the optional parameters for the SubscriptionsClient.CreateOrUpdate method.
type SubscriptionsClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// SubscriptionsClientDeleteOptions contains the optional parameters for the SubscriptionsClient.Delete method.
type SubscriptionsClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// SubscriptionsClientGetOptions contains the optional parameters for the SubscriptionsClient.Get method.
type SubscriptionsClientGetOptions struct {
	// placeholder for future optional parameters
}

// SubscriptionsClientListByTopicOptions contains the optional parameters for the SubscriptionsClient.ListByTopic method.
type SubscriptionsClientListByTopicOptions struct {
	// Skip is only used if a previous operation returned a partial result. If a previous response contains a nextLink element,
	// the value of the nextLink element will include a skip parameter that specifies
	// a starting point to use for subsequent calls.
	Skip *int32
	// May be used to limit the number of results to the most recent N usageDetails.
	Top *int32
}

// SystemData - Metadata pertaining to creation and last modification of the resource.
type SystemData struct {
	// The timestamp of resource creation (UTC).
	CreatedAt *time.Time `json:"createdAt,omitempty"`

	// The identity that created the resource.
	CreatedBy *string `json:"createdBy,omitempty"`

	// The type of identity that created the resource.
	CreatedByType *CreatedByType `json:"createdByType,omitempty"`

	// The type of identity that last modified the resource.
	LastModifiedAt *time.Time `json:"lastModifiedAt,omitempty"`

	// The identity that last modified the resource.
	LastModifiedBy *string `json:"lastModifiedBy,omitempty"`

	// The type of identity that last modified the resource.
	LastModifiedByType *CreatedByType `json:"lastModifiedByType,omitempty"`
}

// TopicsClientCreateOrUpdateAuthorizationRuleOptions contains the optional parameters for the TopicsClient.CreateOrUpdateAuthorizationRule
// method.
type TopicsClientCreateOrUpdateAuthorizationRuleOptions struct {
	// placeholder for future optional parameters
}

// TopicsClientCreateOrUpdateOptions contains the optional parameters for the TopicsClient.CreateOrUpdate method.
type TopicsClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// TopicsClientDeleteAuthorizationRuleOptions contains the optional parameters for the TopicsClient.DeleteAuthorizationRule
// method.
type TopicsClientDeleteAuthorizationRuleOptions struct {
	// placeholder for future optional parameters
}

// TopicsClientDeleteOptions contains the optional parameters for the TopicsClient.Delete method.
type TopicsClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// TopicsClientGetAuthorizationRuleOptions contains the optional parameters for the TopicsClient.GetAuthorizationRule method.
type TopicsClientGetAuthorizationRuleOptions struct {
	// placeholder for future optional parameters
}

// TopicsClientGetOptions contains the optional parameters for the TopicsClient.Get method.
type TopicsClientGetOptions struct {
	// placeholder for future optional parameters
}

// TopicsClientListAuthorizationRulesOptions contains the optional parameters for the TopicsClient.ListAuthorizationRules
// method.
type TopicsClientListAuthorizationRulesOptions struct {
	// placeholder for future optional parameters
}

// TopicsClientListByNamespaceOptions contains the optional parameters for the TopicsClient.ListByNamespace method.
type TopicsClientListByNamespaceOptions struct {
	// Skip is only used if a previous operation returned a partial result. If a previous response contains a nextLink element,
	// the value of the nextLink element will include a skip parameter that specifies
	// a starting point to use for subsequent calls.
	Skip *int32
	// May be used to limit the number of results to the most recent N usageDetails.
	Top *int32
}

// TopicsClientListKeysOptions contains the optional parameters for the TopicsClient.ListKeys method.
type TopicsClientListKeysOptions struct {
	// placeholder for future optional parameters
}

// TopicsClientRegenerateKeysOptions contains the optional parameters for the TopicsClient.RegenerateKeys method.
type TopicsClientRegenerateKeysOptions struct {
	// placeholder for future optional parameters
}

// TrackedResource - The Resource definition.
type TrackedResource struct {
	// REQUIRED; The Geo-location where the resource lives
	Location *string `json:"location,omitempty"`

	// Resource tags
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Resource Id
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type
	Type *string `json:"type,omitempty" azure:"ro"`
}

// UserAssignedIdentity - Recognized Dictionary value.
type UserAssignedIdentity struct {
	// READ-ONLY; Client Id of user assigned identity
	ClientID *string `json:"clientId,omitempty" azure:"ro"`

	// READ-ONLY; Principal Id of user assigned identity
	PrincipalID *string `json:"principalId,omitempty" azure:"ro"`
}

type UserAssignedIdentityProperties struct {
	// ARM ID of user Identity selected for encryption
	UserAssignedIdentity *string `json:"userAssignedIdentity,omitempty"`
}
