/*
 * Copyright (C) 2025 Michael Brown <mbrown@fensystems.co.uk>.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 *
 * You can also choose to distribute this program under the terms of
 * the Unmodified Binary Distribution Licence (as given in the file
 * COPYING.UBDL), provided that you have satisfied its requirements.
 */

FILE_LICENCE ( GPL2_OR_LATER_OR_UBDL );

/** @file
 *
 * EFI signature list self-tests
 *
 */

/* Forcibly enable assertions */
#undef NDEBUG

#include <string.h>
#include <assert.h>
#include <ipxe/test.h>
#include <ipxe/efi/efi_siglist.h>
#include "asn1_test.h"

/** Define inline data */
#define DATA(...) { __VA_ARGS__ }

/** Define inline expected digest */
#define DIGEST(...) { { __VA_ARGS__ } }

/** Two certificates, one PEM, one DER, created by efisecdb */
ASN1 ( efisecdb, &efisig_image_type,
       DATA ( 0xa1, 0x59, 0xc0, 0xa5, 0xe4, 0x94, 0xa7, 0x4a, 0x87, 0xb5,
	      0xab, 0x15, 0x5c, 0x2b, 0xf0, 0x72, 0x94, 0x01, 0x00, 0x00,
	      0x00, 0x00, 0x00, 0x00, 0x78, 0x01, 0x00, 0x00, 0xaf, 0x1e,
	      0xbb, 0xc0, 0x33, 0x74, 0xa2, 0x4c, 0x93, 0xf2, 0xe9, 0x74,
	      0x1b, 0x90, 0x98, 0x6c, 0x30, 0x82, 0x01, 0x64, 0x30, 0x82,
	      0x01, 0x0e, 0xa0, 0x03, 0x02, 0x01, 0x02, 0x02, 0x01, 0x01,
	      0x30, 0x0d, 0x06, 0x09, 0x2a, 0x86, 0x48, 0x86, 0xf7, 0x0d,
	      0x01, 0x01, 0x0b, 0x05, 0x00, 0x30, 0x10, 0x31, 0x0e, 0x30,
	      0x0c, 0x06, 0x03, 0x55, 0x04, 0x03, 0x0c, 0x05, 0x74, 0x65,
	      0x73, 0x74, 0x32, 0x30, 0x1e, 0x17, 0x0d, 0x32, 0x35, 0x30,
	      0x33, 0x31, 0x31, 0x31, 0x31, 0x31, 0x37, 0x32, 0x36, 0x5a,
	      0x17, 0x0d, 0x32, 0x35, 0x30, 0x34, 0x31, 0x30, 0x31, 0x31,
	      0x31, 0x37, 0x32, 0x36, 0x5a, 0x30, 0x10, 0x31, 0x0e, 0x30,
	      0x0c, 0x06, 0x03, 0x55, 0x04, 0x03, 0x0c, 0x05, 0x74, 0x65,
	      0x73, 0x74, 0x32, 0x30, 0x5c, 0x30, 0x0d, 0x06, 0x09, 0x2a,
	      0x86, 0x48, 0x86, 0xf7, 0x0d, 0x01, 0x01, 0x01, 0x05, 0x00,
	      0x03, 0x4b, 0x00, 0x30, 0x48, 0x02, 0x41, 0x00, 0xc6, 0x75,
	      0x2e, 0xc8, 0x09, 0x37, 0x14, 0xd3, 0xc0, 0xa5, 0x88, 0x3e,
	      0x0d, 0xf9, 0x6f, 0x9f, 0xf2, 0xab, 0x3a, 0xe4, 0x6c, 0x0e,
	      0x2b, 0x78, 0x3c, 0xe9, 0x1a, 0x52, 0x66, 0xbc, 0x7b, 0x7f,
	      0xbe, 0xaa, 0xcd, 0x23, 0x68, 0x76, 0x26, 0x95, 0x45, 0x42,
	      0xb5, 0xc6, 0x16, 0x2e, 0x3b, 0x33, 0x9d, 0x82, 0x6e, 0x6a,
	      0xcf, 0xa5, 0x72, 0x71, 0x40, 0xff, 0xdc, 0x1d, 0x77, 0xe6,
	      0x6f, 0x87, 0x02, 0x03, 0x01, 0x00, 0x01, 0xa3, 0x53, 0x30,
	      0x51, 0x30, 0x1d, 0x06, 0x03, 0x55, 0x1d, 0x0e, 0x04, 0x16,
	      0x04, 0x14, 0x1c, 0x11, 0x40, 0xcc, 0x63, 0xab, 0xad, 0x6a,
	      0xa8, 0x83, 0x17, 0xbb, 0xc5, 0xc6, 0x94, 0x29, 0xe1, 0xad,
	      0x4e, 0x21, 0x30, 0x1f, 0x06, 0x03, 0x55, 0x1d, 0x23, 0x04,
	      0x18, 0x30, 0x16, 0x80, 0x14, 0x1c, 0x11, 0x40, 0xcc, 0x63,
	      0xab, 0xad, 0x6a, 0xa8, 0x83, 0x17, 0xbb, 0xc5, 0xc6, 0x94,
	      0x29, 0xe1, 0xad, 0x4e, 0x21, 0x30, 0x0f, 0x06, 0x03, 0x55,
	      0x1d, 0x13, 0x01, 0x01, 0xff, 0x04, 0x05, 0x30, 0x03, 0x01,
	      0x01, 0xff, 0x30, 0x0d, 0x06, 0x09, 0x2a, 0x86, 0x48, 0x86,
	      0xf7, 0x0d, 0x01, 0x01, 0x0b, 0x05, 0x00, 0x03, 0x41, 0x00,
	      0x57, 0xa3, 0x3a, 0x9c, 0x83, 0xae, 0x94, 0x4c, 0xcd, 0x06,
	      0x86, 0x9b, 0x25, 0x70, 0x87, 0x61, 0xfe, 0xbf, 0xb4, 0xa6,
	      0x52, 0x0b, 0x37, 0x37, 0x85, 0xbb, 0xea, 0x79, 0x2b, 0x0b,
	      0xc4, 0x29, 0x03, 0x8d, 0xa0, 0x26, 0xc2, 0xb4, 0x25, 0x1c,
	      0x87, 0x08, 0xcb, 0x94, 0xee, 0x61, 0x48, 0xa4, 0xe1, 0x77,
	      0xa6, 0x24, 0x2d, 0x15, 0x1b, 0x15, 0x62, 0x6a, 0x0f, 0x28,
	      0x7c, 0xcc, 0xa6, 0xaf, 0xa1, 0x59, 0xc0, 0xa5, 0xe4, 0x94,
	      0xa7, 0x4a, 0x87, 0xb5, 0xab, 0x15, 0x5c, 0x2b, 0xf0, 0x72,
	      0x4a, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2e, 0x02,
	      0x00, 0x00, 0xaf, 0x1e, 0xbb, 0xc0, 0x33, 0x74, 0xa2, 0x4c,
	      0x93, 0xf2, 0xe9, 0x74, 0x1b, 0x90, 0x98, 0x6c, 0x2d, 0x2d,
	      0x2d, 0x2d, 0x2d, 0x42, 0x45, 0x47, 0x49, 0x4e, 0x20, 0x43,
	      0x45, 0x52, 0x54, 0x49, 0x46, 0x49, 0x43, 0x41, 0x54, 0x45,
	      0x2d, 0x2d, 0x2d, 0x2d, 0x2d, 0x0a, 0x4d, 0x49, 0x49, 0x42,
	      0x5a, 0x44, 0x43, 0x43, 0x41, 0x51, 0x36, 0x67, 0x41, 0x77,
	      0x49, 0x42, 0x41, 0x67, 0x49, 0x42, 0x41, 0x54, 0x41, 0x4e,
	      0x42, 0x67, 0x6b, 0x71, 0x68, 0x6b, 0x69, 0x47, 0x39, 0x77,
	      0x30, 0x42, 0x41, 0x51, 0x73, 0x46, 0x41, 0x44, 0x41, 0x51,
	      0x4d, 0x51, 0x34, 0x77, 0x44, 0x41, 0x59, 0x44, 0x56, 0x51,
	      0x51, 0x44, 0x44, 0x41, 0x56, 0x30, 0x5a, 0x58, 0x4e, 0x30,
	      0x0a, 0x4d, 0x54, 0x41, 0x65, 0x46, 0x77, 0x30, 0x79, 0x4e,
	      0x54, 0x41, 0x7a, 0x4d, 0x54, 0x45, 0x78, 0x4d, 0x54, 0x45,
	      0x33, 0x4d, 0x44, 0x42, 0x61, 0x46, 0x77, 0x30, 0x79, 0x4e,
	      0x54, 0x41, 0x30, 0x4d, 0x54, 0x41, 0x78, 0x4d, 0x54, 0x45,
	      0x33, 0x4d, 0x44, 0x42, 0x61, 0x4d, 0x42, 0x41, 0x78, 0x44,
	      0x6a, 0x41, 0x4d, 0x42, 0x67, 0x4e, 0x56, 0x42, 0x41, 0x4d,
	      0x4d, 0x42, 0x58, 0x52, 0x6c, 0x0a, 0x63, 0x33, 0x51, 0x78,
	      0x4d, 0x46, 0x77, 0x77, 0x44, 0x51, 0x59, 0x4a, 0x4b, 0x6f,
	      0x5a, 0x49, 0x68, 0x76, 0x63, 0x4e, 0x41, 0x51, 0x45, 0x42,
	      0x42, 0x51, 0x41, 0x44, 0x53, 0x77, 0x41, 0x77, 0x53, 0x41,
	      0x4a, 0x42, 0x41, 0x4e, 0x4d, 0x56, 0x4c, 0x35, 0x67, 0x78,
	      0x76, 0x6c, 0x35, 0x31, 0x30, 0x32, 0x42, 0x4c, 0x6c, 0x31,
	      0x78, 0x79, 0x7a, 0x56, 0x44, 0x6c, 0x4c, 0x77, 0x63, 0x62,
	      0x0a, 0x59, 0x72, 0x6e, 0x52, 0x4e, 0x76, 0x53, 0x72, 0x68,
	      0x6f, 0x2f, 0x59, 0x61, 0x31, 0x6f, 0x63, 0x31, 0x71, 0x76,
	      0x73, 0x75, 0x34, 0x72, 0x71, 0x43, 0x64, 0x2f, 0x30, 0x68,
	      0x65, 0x6a, 0x55, 0x6a, 0x4e, 0x66, 0x71, 0x4b, 0x47, 0x64,
	      0x79, 0x57, 0x61, 0x49, 0x67, 0x43, 0x45, 0x38, 0x71, 0x78,
	      0x4e, 0x50, 0x34, 0x68, 0x32, 0x64, 0x37, 0x4e, 0x72, 0x45,
	      0x43, 0x41, 0x77, 0x45, 0x41, 0x0a, 0x41, 0x61, 0x4e, 0x54,
	      0x4d, 0x46, 0x45, 0x77, 0x48, 0x51, 0x59, 0x44, 0x56, 0x52,
	      0x30, 0x4f, 0x42, 0x42, 0x59, 0x45, 0x46, 0x47, 0x38, 0x46,
	      0x4d, 0x78, 0x52, 0x6e, 0x53, 0x6b, 0x36, 0x34, 0x65, 0x79,
	      0x42, 0x69, 0x56, 0x43, 0x35, 0x75, 0x67, 0x73, 0x35, 0x63,
	      0x4f, 0x77, 0x38, 0x6a, 0x4d, 0x42, 0x38, 0x47, 0x41, 0x31,
	      0x55, 0x64, 0x49, 0x77, 0x51, 0x59, 0x4d, 0x42, 0x61, 0x41,
	      0x0a, 0x46, 0x47, 0x38, 0x46, 0x4d, 0x78, 0x52, 0x6e, 0x53,
	      0x6b, 0x36, 0x34, 0x65, 0x79, 0x42, 0x69, 0x56, 0x43, 0x35,
	      0x75, 0x67, 0x73, 0x35, 0x63, 0x4f, 0x77, 0x38, 0x6a, 0x4d,
	      0x41, 0x38, 0x47, 0x41, 0x31, 0x55, 0x64, 0x45, 0x77, 0x45,
	      0x42, 0x2f, 0x77, 0x51, 0x46, 0x4d, 0x41, 0x4d, 0x42, 0x41,
	      0x66, 0x38, 0x77, 0x44, 0x51, 0x59, 0x4a, 0x4b, 0x6f, 0x5a,
	      0x49, 0x68, 0x76, 0x63, 0x4e, 0x0a, 0x41, 0x51, 0x45, 0x4c,
	      0x42, 0x51, 0x41, 0x44, 0x51, 0x51, 0x41, 0x4a, 0x4d, 0x54,
	      0x78, 0x6c, 0x62, 0x4e, 0x43, 0x58, 0x62, 0x6b, 0x2f, 0x73,
	      0x6a, 0x79, 0x67, 0x4b, 0x30, 0x39, 0x58, 0x68, 0x50, 0x38,
	      0x48, 0x74, 0x4c, 0x6b, 0x45, 0x2b, 0x34, 0x33, 0x6e, 0x61,
	      0x67, 0x44, 0x39, 0x4b, 0x52, 0x48, 0x35, 0x53, 0x52, 0x47,
	      0x6b, 0x68, 0x45, 0x43, 0x34, 0x50, 0x7a, 0x68, 0x53, 0x31,
	      0x0a, 0x52, 0x76, 0x65, 0x34, 0x79, 0x4a, 0x35, 0x50, 0x2b,
	      0x4b, 0x4a, 0x74, 0x36, 0x4d, 0x65, 0x78, 0x38, 0x4c, 0x48,
	      0x37, 0x79, 0x2b, 0x74, 0x38, 0x61, 0x42, 0x62, 0x79, 0x68,
	      0x56, 0x30, 0x47, 0x0a, 0x2d, 0x2d, 0x2d, 0x2d, 0x2d, 0x45,
	      0x4e, 0x44, 0x20, 0x43, 0x45, 0x52, 0x54, 0x49, 0x46, 0x49,
	      0x43, 0x41, 0x54, 0x45, 0x2d, 0x2d, 0x2d, 0x2d, 0x2d, 0x0a ),
       DIGEST ( 0x87, 0x95, 0x3b, 0x90, 0xb5, 0x5c, 0xb6, 0x7b, 0xc3, 0xfb,
		0xcb, 0x2c, 0x72, 0xbd, 0x4c, 0x2d, 0xb9, 0x9f, 0x10, 0xda ),
       DIGEST ( 0x9b, 0x08, 0xa2, 0x7d, 0x53, 0x35, 0x0a, 0xeb, 0x53, 0xca,
		0x50, 0x66, 0xc0, 0xfd, 0xbd, 0x70, 0x78, 0xf2, 0xa0, 0xc9 ) );

/**
 * Perform EFI signature list self-test
 *
 */
static void efisig_test_exec ( void ) {

	/* Perform tests */
	asn1_ok ( &efisecdb );
}

/** EFI signature list self-test */
struct self_test efisig_test __self_test = {
	.name = "efisig",
	.exec = efisig_test_exec,
};
