# -*- coding: utf-8 -*-
#
# EusLisp documentation build configuration file, created by
# sphinx-quickstart on Mon Jun 10 14:01:34 2019.
#
# This file is execfile()d with the current directory set to its
# containing dir.
#
# Note that not all possible configuration values are present in this
# autogenerated file.
#
# All configuration values have a default; values that are commented out
# serve to show the default.

# If extensions (or modules to document with autodoc) are in another directory,
# add these directories to sys.path here. If the directory is relative to the
# documentation root, use os.path.abspath to make it absolute, like shown here.
#
# import os
# import sys
# sys.path.insert(0, os.path.abspath('.'))

import subprocess, os, sys
def sh(command):
    print("+ {}".format(command))
    print(subprocess.check_output(command, shell=True))

on_rtd = os.environ.get('READTHEDOCS') == 'True'
if on_rtd:
    # run make rst
    sh("lsb_release -a")
    sh("cd ..; make eus")
    sh("cd ../eus; git pull --unshallow; git fetch --all")
    sh("mkdir -p ../eus/Linux64/lib")
    sh("wget http://archive.ubuntu.com/ubuntu/pool/main/libg/libglvnd/libgl1_1.0.0-2ubuntu2.3_amd64.deb")
    sh("wget http://archive.ubuntu.com/ubuntu/pool/main/libg/libglvnd/libglvnd-dev_1.0.0-2ubuntu2.3_amd64.deb")
    sh("wget http://archive.ubuntu.com/ubuntu/pool/main/m/mesa/mesa-common-dev_20.0.8-0ubuntu1~18.04.1_amd64.deb")
    sh("wget http://archive.ubuntu.com/ubuntu/pool/main/libg/libglu/libglu1-mesa_9.0.0-2.1build1_amd64.deb")
    sh("wget http://archive.ubuntu.com/ubuntu/pool/main/libg/libglu/libglu1-mesa-dev_9.0.0-2.1build1_amd64.deb")
    sh("for deb in *.deb; do dpkg -x $deb .; done")
    sh("cp -r usr/include/* ../eus/lisp/c/")
    sh("cp usr/lib/*/* ../eus/Linux64/lib/ || echo OK")
    sh("cd ..; make")
    sh("rm -f /tmp/.python-version") ### HACK FOR RTD SERVER, which stop executing python3
    sh(". ../bashrc.eus; make rst")

# -- General configuration ------------------------------------------------

# If your documentation needs a minimal Sphinx version, state it here.
#
# needs_sphinx = '1.0'

# Add any Sphinx extension module names here, as strings. They can be
# extensions coming with Sphinx (named 'sphinx.ext.*') or your custom
# ones.
extensions = []

# Add any paths that contain templates here, relative to this directory.
templates_path = ['_templates']

# The suffix(es) of source filenames.
# You can specify multiple suffix as a list of string:
#
# source_suffix = ['.rst', '.md']
source_suffix = '.rst'

# The master toctree document.
master_doc = 'jmanual'

# General information about the project.
project = u'EusLisp / jskeus'
copyright = u'1984-2001, National Institute of Advanced Industrial Science and Technology (AIST), 2010-, JSK Robotics Laboratory, The University of Tokyo'
author = u'Toshihiro Matsui, JSK Robotics Laboratory'

# The version info for the project you're documenting, acts as replacement for
# |version| and |release|, also used in various other places throughout the
# built documents.
#
# The short X.Y version.

eusversion=str(subprocess.check_output(['git', 'describe', '--tags', subprocess.check_output(['git', 'rev-list', '--tags', '--max-count=1'], cwd='../eus').strip()], cwd='../eus').strip()).replace('EusLisp-','')
irtversion=str(subprocess.check_output(['git', 'describe', '--tags', subprocess.check_output(['git', 'rev-list', '--tags', '--max-count=1']).strip()]).strip())
version = u'{} / {}'.format(eusversion,irtversion)
# The full version, including alpha/beta/rc tags.
release = irtversion


# The language for content autogenerated by Sphinx. Refer to documentation
# for a list of supported languages.
#
# This is also used if you do content translation via gettext catalogs.
# Usually you set "language" from the command line for these cases.
language = None

# List of patterns, relative to source directory, that match files and
# directories to ignore when looking for source files.
# This patterns also effect to html_static_path and html_extra_path
exclude_patterns = ['_build', 'Thumbs.db', '.DS_Store']

# The name of the Pygments (syntax highlighting) style to use.
pygments_style = 'sphinx'

# If true, `todo` and `todoList` produce output, else they produce nothing.
todo_include_todos = False


# -- Options for HTML output ----------------------------------------------

# The theme to use for HTML and HTML Help pages.  See the documentation for
# a list of builtin themes.
#
html_theme = 'sphinx_rtd_theme'

# Theme options are theme-specific and customize the look and feel of a theme
# further.  For a list of options available for each theme, see the
# documentation.
#
# html_theme_options = {}

# Add any paths that contain custom static files (such as style sheets) here,
# relative to this directory. They are copied after the builtin static files,
# so a file named "default.css" will overwrite the builtin "default.css".
html_static_path = ['_static']

# Custom sidebar templates, must be a dictionary that maps document names
# to template names.
#
# This is required for the alabaster theme
# refs: http://alabaster.readthedocs.io/en/latest/installation.html#sidebars
html_sidebars = {
    '**': [
        'relations.html',  # needs 'show_related': True theme option to display
        'searchbox.html',
    ]
}

import sphinx_rtd_theme
if on_rtd:
    # The theme to use for HTML and HTML Help pages.  See the documentation for
    # a list of builtin themes.
    html_theme_path = [sphinx_rtd_theme.get_html_theme_path()]
    sh("sed -i 's@set suffix@set suffix_bak@' {}/sphinx_rtd_theme/breadcrumbs.html".format(html_theme_path[0]))

    # Add Edit on GitHub link
    html_context = {
        'suffix': '.tex',
    }

    sh("mkdir -p _build/html")
    sh("cd _build/html; ln -sf jmanual.html index.html; ls -al")
    sh("find _build/html -type f -a -name 'j*.html' -a ! -name 'jmanual.html' -a -exec sed -i 's@github.com/euslisp/jskeus/blob/\(.*\)/doc/@github.com/euslisp/EusLisp/blob/\1/doc/jlatex/@' {} \;")
    # sh("sed -i 's@github.com/euslisp/jskeus/blob/\(.*\)/doc/@github.com/euslisp/EusLisp/blob/\1/doc/jlatex/@' _build/html/j!(manual).html || echo OK")



# -- Options for HTMLHelp output ------------------------------------------

# Output file base name for HTML help builder.
htmlhelp_basename = 'EusLispdoc'


# -- Options for LaTeX output ---------------------------------------------

latex_elements = {
    # The paper size ('letterpaper' or 'a4paper').
    #
    # 'papersize': 'letterpaper',

    # The font size ('10pt', '11pt' or '12pt').
    #
    # 'pointsize': '10pt',

    # Additional stuff for the LaTeX preamble.
    #
    # 'preamble': '',

    # Latex figure (float) alignment
    #
    # 'figure_align': 'htbp',
}

# Grouping the document tree into LaTeX files. List of tuples
# (source start file, target name, title,
#  author, documentclass [howto, manual, or own class]).
latex_documents = [
    (master_doc, 'jskeus.tex', u'EusLisp/jskeus Documentation',
     u'Toshihiro Matsui / JSK Robotics Laboratory', 'jmanual'),
]


# -- Options for manual page output ---------------------------------------

# One entry per manual page. List of tuples
# (source start file, name, description, authors, manual section).
man_pages = [
    (master_doc, 'euslisp/jskeus', u'EusLisp/jskeus Documentation',
     [author], 1)
]


# -- Options for Texinfo output -------------------------------------------

# Grouping the document tree into Texinfo files. List of tuples
# (source start file, target name, title, author,
#  dir menu entry, description, category)
texinfo_documents = [
    (master_doc, 'EusLisp/jskeus', u'EusLisp/jskeus Documentation',
     author, 'EusLisp/jskeus', 'EusLisp is an integrated programming system for the research on intelligent robots based on Common Lisp and Object-Oriented programming.',
     'Miscellaneous'),
]

