The MDAnalysis *Code of Conduct* sets the rules for the behavior of
every member in the MDAnalysis community so that everyone can
experience a welcoming, supportive, and productive environment that is
free from harassment.

<!-- markdown-toc start - Don't edit this section. Run M-x markdown-toc-generate-toc again -->
**Table of Contents**

- [MDAnalysis Code of Conduct and Community Guidelines](#mdanalysis-code-of-conduct-and-community-guidelines)
- [Reporting](#reporting)
- [Enforcement](#enforcement)
- [Acknowledgment](#acknowledgment)

<!-- markdown-toc end -->
## MDAnalysis Code of Conduct and Community Guidelines

MDAnalysis is an engaged and respectful community made up of people from all
over the world. Your involvement helps us to further our mission and to create
an open platform that serves a broad range of communities, from research and
education to industry and beyond. This diversity is one of our biggest
strengths, but it can also lead to communication issues and conflicts.
Therefore, we have a few ground rules we ask that our community members adhere
to.

Fundamentally, we are committed to providing a productive,
harassment-free environment for everyone. Rather than considering this
code an exhaustive list of things that you can’t do, take it in the
spirit it is intended - a guide to make it easier to enrich all of us
and the communities in which we participate.

Importantly: as a member of our community, you are also a steward of these
values. Not all problems need to be resolved via formal processes, and often a
quick, friendly but clear word on an online forum or in person can help resolve
a misunderstanding and de-escalate things.

However, sometimes these informal processes may be inadequate: they fail to
work, there is urgency or risk to someone, nobody is intervening publicly and
you don't feel comfortable speaking in public, etc. For these or other reasons,
structured follow-up may be necessary and here we provide the means for that: we
welcome reports by
emailing [*Conduct-email*][conduct-mail] or
in anonymous by filling out [*this form*][conduct-form].

This code applies equally to founders, developers, mentors and new
community members, in all spaces managed by MDAnalysis. This
includes the mailing lists, our GitHub organizations, our chat rooms,
in-person events, and any other forums created by the project team. In
addition, violations of this code outside these spaces may affect a
person's ability to participate within them.

By embracing the following principles, guidelines and actions to follow or
avoid, you will help us make MDAnalysis a welcoming and productive community. If
that doesn't answer your questions, feel free to contact us
at our [*user-mailing-list*](mailto:mdnalysis-discussions@googlegroups.com).


1. **Be friendly and patient**.

2. **Be welcoming**. We strive to be a community that welcomes and supports
   people of all backgrounds and identities. This includes, but is not limited
   to, members of any race, ethnicity, culture, national origin, color,
   immigration status, social and economic class, educational level, sex, sexual
   orientation, gender identity and expression, age, physical appearance, family
   status, political belief, technological or professional choices, academic
   discipline, religion, mental ability, and physical ability.

3. **Be considerate**. Your work will be used by other people, and you in turn
   will depend on the work of others. Any decision you take will affect users
   and colleagues, and you should take those consequences into account when
   making decisions. Remember that we're a world-wide community. You may be
   communicating with someone with a different primary language or cultural
   background.

4. **Be respectful**. Not all of us will agree all the time, but disagreement is
   no excuse for poor behavior or poor manners. We might all experience some
   frustration now and then, but we cannot allow that frustration to turn into a
   personal attack. It’s important to remember that a community where people
   feel uncomfortable or threatened is not a productive one.

5. **Be careful in the words that you choose**. Be kind to others. Do not insult
   or put down other community members. Harassment and other exclusionary
   behavior are not acceptable. This includes, but is not limited to:
   * threats or violent language directed against another person
   * discriminatory jokes and language
   * posting sexually explicit or violent material
   * posting (or threatening to post) other people's personally identifying
     information ("doxing")
   * personal insults, especially those using racist or sexist terms
   * unwelcome sexual attention
   * advocating for, or encouraging, any of the above behavior
   * repeated harassment of others. In general, if someone asks you to stop,
     then stop

6. **Moderate your expectations**. Many in our community volunteer their time.
   They are probably not purposefully ignoring issues, refusing to engage in
   discussion, avoiding features, etc. but often just unavailable.

7. **When we disagree, try to understand why**. Disagreements, both social and
   technical, happen all the time and MDAnalysis is no exception. It is important
   that we resolve disagreements and differing views constructively. Remember
   that we’re different. The strength of MDAnalysis comes from its varied community
   that includes people from a wide range of backgrounds. Different people have
   different perspectives on issues. Being unable to understand why someone
   holds a viewpoint doesn’t mean they’re wrong. Don’t forget that it is human
   to err and blaming each other doesn’t get us anywhere. Instead, focus on
   helping to resolve issues and learning from mistakes.

8. **A simple apology can go a long way**. It can often de-escalate a situation,
   and telling someone that you are sorry is act of empathy that doesn’t
   automatically imply an admission of guilt.

## Reporting

If someone makes you or any other contributor feel unsafe or unwelcome, please
report this in a timely manner. Code of conduct violations reduce the value of
the community for everyone and we take them seriously. All complaints will be
reviewed and investigated and will result in a response that is deemed necessary
and appropriate to the circumstances.

You can file a report by emailing
the [*Conduct-mail*][conduct-mail] or by
filing out [this form][conduct-form]. The project team is obligated to maintain
confidentiality with regard to the reporter of an incident.

The online form gives you the option to keep your report anonymous or request
that we follow up with you directly. While we cannot follow up on an anonymous
report, we will take appropriate action.

## Enforcement

When a report is sent to us we will reply as soon as possible to confirm receipt;
we strive to answer in less than 24 hours. We will review the incident and
determine, to the best of our ability

- what happened
- whether this event constitutes a code of conduct violation
- who, if anyone, was at fault
- whether this is an ongoing situation

This information will be collected in writing. We strive to reach a resolution
within a week of confirmation. Once a resolution has been agreed upon, but before it is
enacted, we will contact the original reporter and any other affected parties
and explain the proposed resolution. We will ask if this resolution is
acceptable and note feedback for the record. We are, however, not required to act
on this feedback.


## Acknowledgment

Original text courtesy of
the
[*Speak Up!*](http://web.archive.org/web/20141109123859/http://speakup.io/coc.html),
[*Django*](https://www.djangoproject.com/conduct),
[*Contributor Covenant*](http://contributor-covenant.org/),
and
[*Jupyter*](https://github.com/jupyter/governance/blob/master/conduct/code_of_conduct.md) projects,
modified by MDAnalysis. We are grateful to those projects for contributing these
materials under open licensing terms for us to easily reuse.

All content on this page is licensed under a [*Creative Commons
Attribution*](http://creativecommons.org/licenses/by/3.0/) license. 

[conduct-mail]: mailto:mdnalysis-conduct@googlegroups.com
[conduct-form]: https://goo.gl/forms/w2IwBKkY3oT0aVEB3
