#!/usr/bin/perl

#
# Generate config/unconfig.h from config/config.h.in
#

use strict;
use File::Spec;

my($srcdir,$infile,$outfile) = @ARGV;

my $in;
if (!open($in, '<', $infile)) {
    open($in, '<', File::Spec->catfile($srcdir, $infile)) or
	die "$0: $infile not found\n";
}

open(my $out, '>', $outfile) or
    die "$0: $outfile: $!\n";

print $out "/* config/unconfig.h: autogenerated by tools/unconfig.pl */\n\n";
print $out "#ifndef CONFIG_UNCONFIG_H\n";
print $out "#define CONFIG_UNCONFIG_H\n";

my $o = 0;
while (defined(my $l = <$in>)) {
    print $out $l if ($o);
    $o |= ($l =~ m:/\*.*unconfig\.h.*\*/:);
}

close($in);

print $out "\n#endif /* CONFIG_UNCONFIG_H */\n";

close($out);
