/* This is a demonstration plugin for geng.  Its function is to remove
graphs containing an induced cycle of length 4.
A typical compilation command would be
   gcc -o no4holes -DMAXN=WORDSIZE -O3 -march=native -DPRUNE=no4holes \
        geng.c no4holes.c nauty1.a

PREPRUNE could be used in place of PRUNE -- adopt whichever is fastest.
The resulting executable will have all the features of geng but also graphs
without induced cycles of length 4 will be excluded. */

#include "gtools.h"

int
no4holes(graph *g, int n, int maxn)
/* n is the size of the current graph and maxn is the output size. The most
   recent vertex added was vertex n-1 and the graph without that vertex has
   already been tested. So all we need to do is look for induced cycles of
   length 4 which include vertex n-1. If we find one, we return 1 to make sure
   this graph and its descendants are not output. Otherwise, we return 0.
   Note that graphs generated by geng have at most WORDSIZE vertices, and
   so we can use a single setword to hold a set of vertices. */
{
    setword x,y,z;
    int i,j;

    x = g[n-1];             /* Neighbours of n-1 */
    while (x)
    {
        TAKEBIT(i,x);       /* i is next neighbour; remove it from x */
        y = x & ~g[i];      /* Later neighbours of n-1, not adjacent to i */
        z = g[i] & ~g[n-1] & ~bit[n-1];  /* Neighbours of i that are
                                             non-neighbours of n-1 */
        while (y)
        {
            TAKEBIT(j,y);   /* Second neighbour of n-1 */
            if ((g[j] & z)) return 1;  /* Found 4-hole */
        }
    }
    return 0;
}
