/*
 * Decompiled with CFR 0.152.
 */
package org.chefproject.service.component;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.Vector;
import javax.servlet.ServletConfig;
import org.apache.jetspeed.services.statemanager.SessionStateBindingListener;
import org.apache.turbine.services.InitializationException;
import org.apache.turbine.services.TurbineBaseService;
import org.apache.turbine.util.Log;
import org.apache.turbine.util.RunData;
import org.chefproject.core.Edit;
import org.chefproject.core.Event;
import org.chefproject.core.Realm;
import org.chefproject.core.RealmEdit;
import org.chefproject.core.Resource;
import org.chefproject.core.ResourceProperties;
import org.chefproject.core.ResourcePropertiesEdit;
import org.chefproject.core.Role;
import org.chefproject.core.RoleEdit;
import org.chefproject.core.StorageUser;
import org.chefproject.core.User;
import org.chefproject.core.component.BaseResourcePropertiesEdit;
import org.chefproject.exception.IdInvalidException;
import org.chefproject.exception.IdUnusedException;
import org.chefproject.exception.IdUsedException;
import org.chefproject.exception.InUseException;
import org.chefproject.exception.PermissionException;
import org.chefproject.plugin.RealmProvider;
import org.chefproject.service.EventTrackingService;
import org.chefproject.service.SecurityService;
import org.chefproject.service.ServerConfigurationService;
import org.chefproject.service.UsageSessionService;
import org.chefproject.service.UserDirectoryService;
import org.chefproject.service.generic.GenericRealmService;
import org.chefproject.util.Abilities;
import org.chefproject.util.Cache;
import org.chefproject.util.CacheRefresher;
import org.chefproject.util.SeriesIterator;
import org.chefproject.util.StringUtil;
import org.chefproject.util.Time;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class BaseRealmService
extends TurbineBaseService
implements GenericRealmService,
StorageUser,
CacheRefresher {
    protected Storage m_storage = null;
    protected Cache m_cache = null;
    protected String m_accessPoint = null;
    protected String m_relativeAccessPoint = null;
    protected RealmProvider m_provider = null;

    protected abstract Storage newStorage();

    protected String getAccessPoint(boolean relative) {
        return relative ? this.m_relativeAccessPoint : this.m_accessPoint;
    }

    protected String realmId(String ref) {
        String start = this.getAccessPoint(true) + "/";
        int i = ref.indexOf(start);
        if (i == -1) {
            return ref;
        }
        String id = ref.substring(i + start.length());
        return id;
    }

    protected boolean unlockCheck(String lock, String resource) {
        return SecurityService.unlock(lock, resource);
    }

    protected void unlock(String lock, String resource) throws PermissionException {
        if (!this.unlockCheck(lock, resource)) {
            throw new PermissionException(UsageSessionService.getSessionUser().getId(), lock, resource);
        }
    }

    protected void addLiveProperties(ResourcePropertiesEdit props) {
        String current = UsageSessionService.getSessionUser().getId();
        props.addProperty("CHEF:creator", current);
        props.addProperty("CHEF:modifiedby", current);
        String now = new Time().toString();
        props.addProperty("DAV:creationdate", now);
        props.addProperty("DAV:getlastmodified", now);
    }

    protected void addLiveUpdateProperties(ResourcePropertiesEdit props) {
        String current = UsageSessionService.getSessionUser().getId();
        props.addProperty("CHEF:modifiedby", current);
        props.addProperty("DAV:getlastmodified", new Time().toString());
    }

    public void init(ServletConfig config) throws InitializationException {
        super.init(config);
        Log.info("chef", this + ".init(ServletConfig)");
    }

    public void init(RunData data) throws InitializationException {
        this.m_relativeAccessPoint = "/realm";
        this.m_accessPoint = ServerConfigurationService.getAccessUrl() + this.m_relativeAccessPoint;
        Log.info("chef", this + ".init(RunData): access point: " + this.m_accessPoint);
        super.init(data);
        Log.info("chef", this + ".init(RunData): access point: " + this.m_accessPoint);
    }

    public void init() throws InitializationException {
        super.init();
        this.m_storage = this.newStorage();
        this.m_storage.open();
        this.m_cache = new Cache((CacheRefresher)this, this.realmReference(""));
        String providerClassName = this.getProperties().getProperty("provider");
        if (providerClassName != null) {
            try {
                this.m_provider = (RealmProvider)Class.forName(providerClassName).newInstance();
                Log.info("chef", this + ".init(): provider: " + providerClassName);
            }
            catch (Exception e) {
                Log.warn("chef", this + ".init(): trouble loading provider: " + e);
            }
        }
        Log.info("chef", this + ".init()");
    }

    public void shutdown() {
        this.m_cache.clear();
        this.m_cache = null;
        this.m_storage.close();
        this.m_storage = null;
        Log.info("chef", this + ".shutdown()");
        super.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getRealms() {
        List realms = new Vector();
        if (this.m_cache.disabled()) {
            realms = this.m_storage.getAll();
        } else if (this.m_cache.isComplete()) {
            realms = this.m_cache.getAll();
        } else {
            Cache cache = this.m_cache;
            synchronized (cache) {
                block9: {
                    if (!this.m_cache.isComplete()) break block9;
                    realms = this.m_cache.getAll();
                    List list = realms;
                    return list;
                }
                this.m_cache.holdEvents();
                realms = this.m_storage.getAll();
                int i = 0;
                while (i < realms.size()) {
                    Realm realm = (Realm)realms.get(i);
                    this.m_cache.put(realm.getReference(), realm);
                    ++i;
                }
                this.m_cache.setComplete();
                this.m_cache.processEvents();
            }
        }
        return realms;
    }

    public Realm getRealm(String id) throws IdUnusedException {
        if (id == null) {
            throw new IdUnusedException("<null>");
        }
        Realm realm = null;
        String key = this.realmReference(id);
        if (this.m_cache.containsKey(key)) {
            realm = (Realm)this.m_cache.get(key);
        } else {
            realm = this.m_storage.get(id);
            this.m_cache.put(key, realm);
        }
        if (realm == null) {
            throw new IdUnusedException(id);
        }
        return realm;
    }

    public boolean allowUpdateRealm(String id) {
        return this.unlockCheck("realm.upd", this.realmReference(id));
    }

    public RealmEdit editRealm(String id) throws IdUnusedException, PermissionException, InUseException {
        if (id == null) {
            throw new IdUnusedException("<null>");
        }
        this.unlock("realm.upd", this.realmReference(id));
        if (this.m_cache.get(this.realmReference(id)) == null && !this.m_storage.check(id)) {
            throw new IdUnusedException(id);
        }
        RealmEdit realm = this.m_storage.edit(id);
        if (realm == null) {
            throw new InUseException(id);
        }
        ((BaseRealmEdit)realm).setEvent("realm.upd");
        return realm;
    }

    public void commitEdit(RealmEdit realm) {
        if (!realm.isActiveEdit()) {
            try {
                throw new Exception();
            }
            catch (Exception e) {
                Log.warn("chef", this + ".commitEdit(): closed RealmEdit", (Throwable)e);
                return;
            }
        }
        this.addLiveUpdateProperties(realm.getPropertiesEdit());
        this.m_storage.commit(realm);
        EventTrackingService.post(EventTrackingService.newEvent(((BaseRealmEdit)realm).getEvent(), realm.getReference(), true));
        ((BaseRealmEdit)realm).closeEdit();
    }

    public void cancelEdit(RealmEdit realm) {
        if (!realm.isActiveEdit()) {
            try {
                throw new Exception();
            }
            catch (Exception e) {
                Log.warn("chef", this + ".cancelEdit(): closed RealmEdit", (Throwable)e);
                return;
            }
        }
        this.m_storage.cancel(realm);
        ((BaseRealmEdit)realm).closeEdit();
    }

    public boolean allowAddRealm(String id) {
        return this.unlockCheck("realm.add", this.realmReference(id));
    }

    public RealmEdit addRealm(String id) throws IdInvalidException, IdUsedException, PermissionException {
        this.unlock("realm.add", this.realmReference(id));
        RealmEdit realm = this.m_storage.put(id);
        if (realm == null) {
            throw new IdUsedException(id);
        }
        ((BaseRealmEdit)realm).setEvent("realm.add");
        return realm;
    }

    public RealmEdit addRealm(String id, Realm other) throws IdInvalidException, IdUsedException, PermissionException {
        RealmEdit edit = this.addRealm(id);
        ((BaseRealmEdit)edit).set(other);
        ((BaseRealmEdit)edit).m_id = id;
        return edit;
    }

    public boolean allowRemoveRealm(String id) {
        return this.unlockCheck("realm.del", this.realmReference(id));
    }

    public void removeRealm(RealmEdit realm) throws PermissionException {
        if (!realm.isActiveEdit()) {
            try {
                throw new Exception();
            }
            catch (Exception e) {
                Log.warn("chef", this + ".removeRealm(): closed RealmEdit", (Throwable)e);
                return;
            }
        }
        this.unlock("realm.del", realm.getReference());
        this.m_storage.remove(realm);
        EventTrackingService.post(EventTrackingService.newEvent("realm.del", realm.getReference(), true));
        ((BaseRealmEdit)realm).closeEdit();
    }

    public String realmReference(String id) {
        return this.getAccessPoint(true) + "/" + id;
    }

    public Resource newContainer(String ref) {
        return null;
    }

    public Resource newContainer(Element element) {
        return null;
    }

    public Resource newContainer(Resource other) {
        return null;
    }

    public Resource newResource(Resource container, String id, Object[] others) {
        return new BaseRealm(id);
    }

    public Resource newResource(Resource container, Element element) {
        return new BaseRealm(element);
    }

    public Resource newResource(Resource container, Resource other) {
        return new BaseRealm((Realm)other);
    }

    public Edit newContainerEdit(String ref) {
        return null;
    }

    public Edit newContainerEdit(Element element) {
        return null;
    }

    public Edit newContainerEdit(Resource other) {
        return null;
    }

    public Edit newResourceEdit(Resource container, String id, Object[] others) {
        BaseRealmEdit e = new BaseRealmEdit(id);
        e.activate();
        return e;
    }

    public Edit newResourceEdit(Resource container, Element element) {
        BaseRealmEdit e = new BaseRealmEdit(element);
        e.activate();
        return e;
    }

    public Edit newResourceEdit(Resource container, Resource other) {
        BaseRealmEdit e = new BaseRealmEdit((Realm)other);
        e.activate();
        return e;
    }

    public Object[] storageFields(Resource r) {
        return null;
    }

    public Object refresh(Object key, Object oldValue, Event event) {
        String id = this.realmId((String)key);
        Realm realm = this.m_storage.get(id);
        if (Log.getLogger("chef").isDebugEnabled()) {
            Log.debug("chef", this + ".refresh(): " + key + " : " + id);
        }
        return realm;
    }

    protected static interface Storage {
        public void open();

        public void close();

        public boolean check(String var1);

        public Realm get(String var1);

        public List getAll();

        public RealmEdit put(String var1);

        public RealmEdit edit(String var1);

        public void commit(RealmEdit var1);

        public void cancel(RealmEdit var1);

        public void remove(RealmEdit var1);
    }

    public class BaseRoleEdit
    implements RoleEdit {
        protected String m_id = null;
        protected Abilities m_abilities = null;
        protected boolean m_active = false;

        public BaseRoleEdit(String id) {
            this.m_id = id;
            this.m_abilities = new Abilities();
        }

        public BaseRoleEdit(String id, Role other) {
            this.m_id = id;
            this.m_abilities = new Abilities(((BaseRoleEdit)other).m_abilities);
        }

        public BaseRoleEdit(Element el, BaseRealm realm) {
            this.m_abilities = new Abilities();
            this.m_id = StringUtil.trimToNull(el.getAttribute("id"));
            NodeList children = el.getChildNodes();
            int length = children.getLength();
            int i = 0;
            while (i < length) {
                Element element;
                Node child = children.item(i);
                if (child.getNodeType() == 1 && (element = (Element)child).getTagName().equals("ability")) {
                    String role = StringUtil.trimToNull(element.getAttribute("role"));
                    String lock = StringUtil.trimToNull(element.getAttribute("lock"));
                    Object grant = null;
                    grant = role != null ? realm.getRole(role) : lock;
                    if (grant != null) {
                        this.m_abilities.add(grant);
                    } else {
                        Log.warn("chef", this + "el constructor: grant null: " + role + ", " + lock);
                    }
                }
                ++i;
            }
        }

        public Element toXml(Document doc, Stack stack) {
            Element role = doc.createElement("role");
            if (stack.isEmpty()) {
                doc.appendChild(role);
            } else {
                ((Element)stack.peek()).appendChild(role);
            }
            stack.push(role);
            role.setAttribute("id", this.getId());
            Iterator a = this.m_abilities.iterator();
            while (a.hasNext()) {
                Element element = doc.createElement("ability");
                role.appendChild(element);
                Object next = a.next();
                if (next instanceof String) {
                    element.setAttribute("lock", (String)next);
                    continue;
                }
                element.setAttribute("role", ((Role)next).getId());
            }
            stack.pop();
            return role;
        }

        protected void activate() {
            this.m_active = true;
        }

        public boolean isActiveEdit() {
            return this.m_active;
        }

        protected void closeEdit() {
            this.m_active = false;
        }

        public String getId() {
            return this.m_id;
        }

        public boolean unlock(String lock) {
            return this.m_abilities.unlock(lock, null);
        }

        public boolean hasRole(Role role) {
            return this.m_abilities.hasRole(role);
        }

        public Set collectLocks() {
            return this.m_abilities.collectLocks(null);
        }

        public Set collectRoles() {
            return this.m_abilities.collectRoles();
        }

        public Set getLocks() {
            return this.m_abilities.getLocks();
        }

        public Set getRoles() {
            return this.m_abilities.getRoles();
        }

        public void addLock(String lock) {
            this.m_abilities.add(lock);
        }

        public void removeLock(String lock) {
            this.m_abilities.remove(lock);
        }

        public void addRole(Role role) {
            this.m_abilities.add(role);
        }

        public void removeRole(Role role) {
            this.m_abilities.remove(role);
        }

        public void clear() {
            this.m_abilities.clear();
        }

        public int compareTo(Object obj) {
            if (!(obj instanceof Role)) {
                throw new ClassCastException();
            }
            if (obj == this) {
                return 0;
            }
            int compare = this.getId().compareTo(((Role)obj).getId());
            return compare;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Role)) {
                return false;
            }
            return ((Role)obj).getId().equals(this.getId());
        }
    }

    public class BaseRealmEdit
    extends BaseRealm
    implements RealmEdit,
    SessionStateBindingListener {
        protected String m_event = null;
        protected boolean m_active = false;

        public BaseRealmEdit(String id) {
            super(id);
        }

        public BaseRealmEdit(Element el) {
            super(el);
        }

        public BaseRealmEdit(Realm realm) {
            super(realm);
        }

        protected void finalize() {
            if (this.m_active) {
                BaseRealmService.this.cancelEdit(this);
            }
        }

        protected void set(Realm realm) {
            this.setAll(realm);
        }

        public void addUserRole(User user, Role role) {
            this.grant(user.getId(), role.getId(), null, null, null);
        }

        public void addAnonRole(Role role) {
            this.grant(null, role.getId(), null, "anon", null);
        }

        public void addAuthRole(Role role) {
            this.grant(null, role.getId(), null, null, "auth");
        }

        public void addUserLock(User user, String lock) {
            this.grant(user.getId(), null, lock, null, null);
        }

        public void addAnonLock(String lock) {
            this.grant(null, null, lock, "anon", null);
        }

        public void addAuthLock(String lock) {
            this.grant(null, null, lock, null, "auth");
        }

        public void removeUserRole(User user, Role role) {
            this.revoke(user.getId(), role.getId(), null, null, null);
        }

        public void removeAnonRole(Role role) {
            this.revoke(null, role.getId(), null, "anon", null);
        }

        public void removeAuthRole(Role role) {
            this.revoke(null, role.getId(), null, null, "auth");
        }

        public void removeUserLock(User user, String lock) {
            this.revoke(user.getId(), null, lock, null, null);
        }

        public void removeAnonLock(String lock) {
            this.revoke(null, null, lock, "anon", null);
        }

        public void removeAuthLock(String lock) {
            this.revoke(null, null, lock, null, "auth");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeUser(User user) {
            Map map = this.m_users;
            synchronized (map) {
                this.m_users.remove(user.getId());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeAnon() {
            Map map = this.m_users;
            synchronized (map) {
                this.m_anonAbilities.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeAuth() {
            Map map = this.m_users;
            synchronized (map) {
                this.m_authAbilities.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeUsers() {
            Map map = this.m_users;
            synchronized (map) {
                this.m_users.clear();
                this.m_anonAbilities.clear();
                this.m_authAbilities.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public RoleEdit addRole(String id) throws IdUsedException {
            Map map = this.m_users;
            synchronized (map) {
                RoleEdit role = (RoleEdit)this.m_roles.get(id);
                if (role != null) {
                    throw new IdUsedException(id);
                }
                role = new BaseRoleEdit(id);
                this.m_roles.put(role.getId(), role);
                RoleEdit roleEdit = role;
                return roleEdit;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public RoleEdit addRole(String id, Role other) throws IdUsedException {
            Map map = this.m_users;
            synchronized (map) {
                RoleEdit role = (RoleEdit)this.m_roles.get(id);
                if (role != null) {
                    throw new IdUsedException(id);
                }
                role = new BaseRoleEdit(id, other);
                this.m_roles.put(role.getId(), role);
                RoleEdit roleEdit = role;
                return roleEdit;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeRole(Role role) {
            Map map = this.m_users;
            synchronized (map) {
                Role r = (Role)this.m_roles.get(role.getId());
                if (r != null) {
                    this.m_roles.remove(role.getId());
                    Iterator it = this.m_users.entrySet().iterator();
                    while (it.hasNext()) {
                        Map.Entry entry = it.next();
                        Abilities abilities = (Abilities)entry.getValue();
                        String id = (String)entry.getKey();
                        if (!abilities.contains(r)) continue;
                        abilities.remove(r);
                        if (!abilities.isEmpty()) continue;
                        it.remove();
                    }
                    this.m_authAbilities.remove(r);
                    this.m_anonAbilities.remove(r);
                    Iterator it2 = this.m_roles.entrySet().iterator();
                    while (it2.hasNext()) {
                        Map.Entry entry = it2.next();
                        RoleEdit edit = (RoleEdit)entry.getValue();
                        String id = (String)entry.getKey();
                        if (!edit.getRoles().contains(r)) continue;
                        edit.removeRole(r);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void clearRoles() {
            Map map = this.m_users;
            synchronized (map) {
                this.m_roles.clear();
                Iterator it = this.m_users.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry entry = it.next();
                    Abilities abilities = (Abilities)entry.getValue();
                    String id = (String)entry.getKey();
                    Iterator ita = abilities.iterator();
                    while (ita.hasNext()) {
                        Object obj = ita.next();
                        if (!(obj instanceof Role)) continue;
                        ita.remove();
                    }
                    if (!abilities.isEmpty()) continue;
                    it.remove();
                }
                Iterator ita = this.m_authAbilities.iterator();
                while (ita.hasNext()) {
                    Object obj = ita.next();
                    if (!(obj instanceof Role)) continue;
                    ita.remove();
                }
                Iterator ita2 = this.m_anonAbilities.iterator();
                while (ita2.hasNext()) {
                    Object obj = ita2.next();
                    if (!(obj instanceof Role)) continue;
                    ita2.remove();
                }
            }
        }

        public RoleEdit getRoleEdit(String id) {
            BaseRoleEdit edit = (BaseRoleEdit)this.m_roles.get(id);
            if (edit != null) {
                edit.activate();
            }
            return edit;
        }

        public void setProviderRealmId(String id) {
            this.m_providerRealmId = id;
        }

        protected String getEvent() {
            return this.m_event;
        }

        protected void setEvent(String event) {
            this.m_event = event;
        }

        public ResourcePropertiesEdit getPropertiesEdit() {
            return this.m_properties;
        }

        protected void activate() {
            this.m_active = true;
        }

        public boolean isActiveEdit() {
            return this.m_active;
        }

        protected void closeEdit() {
            this.m_active = false;
        }

        public void valueBound(String sessionStateKey, String attributeName) {
        }

        public void valueUnbound(String sessionStateKey, String attributeName) {
            if (Log.getLogger("chef").isDebugEnabled()) {
                Log.debug("chef", this + ".valueUnbound()");
            }
            if (this.m_active) {
                BaseRealmService.this.cancelEdit(this);
            }
        }
    }

    public class BaseRealm
    implements Realm {
        protected String m_id = null;
        protected ResourcePropertiesEdit m_properties = null;
        protected Map m_users = null;
        protected Abilities m_authAbilities = null;
        protected Abilities m_anonAbilities = null;
        protected Map m_roles = null;
        protected String m_providerRealmId = null;

        public BaseRealm(String id) {
            this.m_id = id;
            BaseResourcePropertiesEdit props = new BaseResourcePropertiesEdit();
            this.m_properties = props;
            this.m_users = new HashMap();
            this.m_anonAbilities = new Abilities();
            this.m_authAbilities = new Abilities();
            this.m_roles = new HashMap();
            if (this.m_id != null) {
                BaseRealmService.this.addLiveProperties(props);
            }
        }

        public BaseRealm(Realm realm) {
            this.setAll(realm);
        }

        public BaseRealm(Element el) {
            this.m_users = new HashMap();
            this.m_anonAbilities = new Abilities();
            this.m_authAbilities = new Abilities();
            this.m_roles = new HashMap();
            this.m_properties = new BaseResourcePropertiesEdit();
            this.m_id = StringUtil.trimToNull(el.getAttribute("id"));
            this.m_providerRealmId = StringUtil.trimToNull(el.getAttribute("provider-id"));
            NodeList children = el.getChildNodes();
            int length = children.getLength();
            int i = 0;
            while (i < length) {
                Element element;
                Node child = children.item(i);
                if (child.getNodeType() == 1 && (element = (Element)child).getTagName().equals("role")) {
                    BaseRoleEdit role = new BaseRoleEdit(StringUtil.trimToNull(element.getAttribute("id")));
                    this.m_roles.put(role.getId(), role);
                }
                ++i;
            }
            int i2 = 0;
            while (i2 < length) {
                Node child = children.item(i2);
                if (child.getNodeType() == 1) {
                    Element element = (Element)child;
                    if (element.getTagName().equals("properties")) {
                        this.m_properties = new BaseResourcePropertiesEdit(element);
                    } else if (element.getTagName().equals("role")) {
                        BaseRoleEdit role = new BaseRoleEdit(element, this);
                        BaseRoleEdit already = (BaseRoleEdit)this.m_roles.get(role.getId());
                        already.m_abilities = role.m_abilities;
                    } else if (element.getTagName().equals("ability")) {
                        String user = StringUtil.trimToNull(element.getAttribute("user"));
                        String role = StringUtil.trimToNull(element.getAttribute("role"));
                        String lock = StringUtil.trimToNull(element.getAttribute("lock"));
                        String anon = StringUtil.trimToNull(element.getAttribute("anon"));
                        String auth = StringUtil.trimToNull(element.getAttribute("auth"));
                        this.grant(user, role, lock, anon, auth);
                    }
                }
                ++i2;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void grant(String user, String roleId, String lock, String anon, String auth) {
            String grant = null;
            grant = roleId != null ? this.m_roles.get(roleId) : lock;
            if (grant == null) {
                Log.warn("chef", this + ".grant: grant null: " + roleId + ", " + lock);
                return;
            }
            if (user != null) {
                Map map = this.m_users;
                synchronized (map) {
                    Abilities abilities = (Abilities)this.m_users.get(user);
                    if (abilities == null) {
                        abilities = new Abilities();
                        this.m_users.put(user, abilities);
                    }
                    abilities.add(grant);
                }
            } else if (anon != null) {
                Map map = this.m_users;
                synchronized (map) {
                    this.m_anonAbilities.add(grant);
                }
            } else if (auth != null) {
                Map map = this.m_users;
                synchronized (map) {
                    this.m_authAbilities.add(grant);
                }
            } else {
                Log.warn("chef", this + ".grant: user/auth/anon all null");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void revoke(String user, String roleId, String lock, String anon, String auth) {
            String grant = null;
            grant = roleId != null ? this.m_roles.get(roleId) : lock;
            if (grant == null) {
                Log.warn("chef", this + ".revoke: grant null: " + roleId + ", " + lock);
                return;
            }
            if (user != null) {
                Map map = this.m_users;
                synchronized (map) {
                    Abilities abilities = (Abilities)this.m_users.get(user);
                    if (abilities != null) {
                        abilities.remove(grant);
                        if (abilities.isEmpty()) {
                            this.m_users.remove(user);
                        }
                    }
                }
            } else if (anon != null) {
                Map map = this.m_users;
                synchronized (map) {
                    this.m_anonAbilities.remove(grant);
                }
            } else if (auth != null) {
                Map map = this.m_users;
                synchronized (map) {
                    this.m_authAbilities.remove(grant);
                }
            } else {
                Log.warn("chef", this + ".revoke: user/auth/anon all null");
            }
        }

        protected void setAll(Realm realm) {
            this.m_id = ((BaseRealm)realm).m_id;
            this.m_providerRealmId = ((BaseRealm)realm).m_providerRealmId;
            this.m_roles = new HashMap();
            Iterator it = ((BaseRealm)realm).m_roles.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                BaseRoleEdit role = (BaseRoleEdit)entry.getValue();
                String id = (String)entry.getKey();
                this.m_roles.put(id, new BaseRoleEdit(id));
            }
            Iterator it2 = ((BaseRealm)realm).m_roles.entrySet().iterator();
            while (it2.hasNext()) {
                Map.Entry entry = it2.next();
                BaseRoleEdit role = (BaseRoleEdit)entry.getValue();
                String id = (String)entry.getKey();
                BaseRoleEdit myRole = (BaseRoleEdit)this.m_roles.get(id);
                Iterator ita = role.m_abilities.iterator();
                while (ita.hasNext()) {
                    Object obj = ita.next();
                    if (obj instanceof Role) {
                        obj = this.m_roles.get(((Role)obj).getId());
                    }
                    myRole.m_abilities.add(obj);
                }
            }
            this.m_anonAbilities = new Abilities();
            Iterator ita = ((BaseRealm)realm).m_anonAbilities.iterator();
            while (ita.hasNext()) {
                Object obj = ita.next();
                if (obj instanceof Role) {
                    obj = this.m_roles.get(((Role)obj).getId());
                }
                this.m_anonAbilities.add(obj);
            }
            this.m_authAbilities = new Abilities();
            Iterator ita2 = ((BaseRealm)realm).m_authAbilities.iterator();
            while (ita2.hasNext()) {
                Object obj = ita2.next();
                if (obj instanceof Role) {
                    obj = this.m_roles.get(((Role)obj).getId());
                }
                this.m_authAbilities.add(obj);
            }
            this.m_users = new HashMap();
            Iterator it3 = ((BaseRealm)realm).m_users.entrySet().iterator();
            while (it3.hasNext()) {
                Map.Entry entry = it3.next();
                Abilities abilities = (Abilities)entry.getValue();
                String id = (String)entry.getKey();
                Abilities a = new Abilities();
                this.m_users.put(id, a);
                Iterator ita3 = abilities.iterator();
                while (ita3.hasNext()) {
                    Object obj = ita3.next();
                    if (obj instanceof Role) {
                        obj = this.m_roles.get(((Role)obj).getId());
                    }
                    a.add(obj);
                }
            }
            this.m_properties = new BaseResourcePropertiesEdit();
            this.m_properties.addAll(((BaseRealm)realm).m_properties);
        }

        public Element toXml(Document doc, Stack stack) {
            Element realm = doc.createElement("realm");
            if (stack.isEmpty()) {
                doc.appendChild(realm);
            } else {
                ((Element)stack.peek()).appendChild(realm);
            }
            stack.push(realm);
            realm.setAttribute("id", this.getId());
            if (this.m_providerRealmId != null) {
                realm.setAttribute("provider-id", this.m_providerRealmId);
            }
            this.m_properties.toXml(doc, stack);
            Iterator i = this.m_roles.values().iterator();
            while (i.hasNext()) {
                BaseRoleEdit role = (BaseRoleEdit)i.next();
                role.toXml(doc, stack);
            }
            Iterator i2 = this.m_users.entrySet().iterator();
            while (i2.hasNext()) {
                Map.Entry entry = i2.next();
                Abilities abilities = (Abilities)entry.getValue();
                String user = (String)entry.getKey();
                Iterator a = abilities.iterator();
                while (a.hasNext()) {
                    Element element = doc.createElement("ability");
                    realm.appendChild(element);
                    element.setAttribute("user", user);
                    Object next = a.next();
                    if (next instanceof String) {
                        element.setAttribute("lock", (String)next);
                        continue;
                    }
                    element.setAttribute("role", ((Role)next).getId());
                }
            }
            Iterator a = this.m_anonAbilities.iterator();
            while (a.hasNext()) {
                Element element = doc.createElement("ability");
                realm.appendChild(element);
                element.setAttribute("anon", "anon");
                Object next = a.next();
                if (next instanceof String) {
                    element.setAttribute("lock", (String)next);
                    continue;
                }
                element.setAttribute("role", ((Role)next).getId());
            }
            Iterator a2 = this.m_authAbilities.iterator();
            while (a2.hasNext()) {
                Element element = doc.createElement("ability");
                realm.appendChild(element);
                element.setAttribute("auth", "auth");
                Object next = a2.next();
                if (next instanceof String) {
                    element.setAttribute("lock", (String)next);
                    continue;
                }
                element.setAttribute("role", ((Role)next).getId());
            }
            stack.pop();
            return realm;
        }

        public String getId() {
            if (this.m_id == null) {
                return "";
            }
            return this.m_id;
        }

        public String getUrl() {
            return BaseRealmService.this.getAccessPoint(false) + this.m_id;
        }

        public String getReference() {
            return BaseRealmService.this.realmReference(this.m_id);
        }

        public ResourceProperties getProperties() {
            return this.m_properties;
        }

        protected List findUserAbilities(User user) {
            Abilities providerAbilities;
            Vector<Abilities> rv = new Vector<Abilities>();
            boolean anon = false;
            Abilities abilities = (Abilities)this.m_users.get(user.getId());
            if (abilities != null) {
                rv.add(abilities);
                rv.add(this.m_authAbilities);
            } else {
                anon = user.equals(UserDirectoryService.getAnonymousUser());
                if (anon) {
                    rv.add(this.m_anonAbilities);
                } else {
                    rv.add(this.m_authAbilities);
                }
            }
            if (BaseRealmService.this.m_provider != null && this.m_providerRealmId != null && !anon && (providerAbilities = BaseRealmService.this.m_provider.getAbilities(this, this.m_providerRealmId, user.getId())) != null) {
                rv.add(providerAbilities);
            }
            return rv;
        }

        protected Iterator findUserAbilityMapEntries() {
            if (BaseRealmService.this.m_provider == null || this.m_providerRealmId == null) {
                return this.m_users.entrySet().iterator();
            }
            return new SeriesIterator(this.m_users.entrySet().iterator(), BaseRealmService.this.m_provider.getAbilities(this, this.m_providerRealmId).entrySet().iterator());
        }

        public boolean unlock(User user, String lock, List helperRealms) {
            List abilities = this.findUserAbilities(user);
            Iterator it = abilities.iterator();
            while (it.hasNext()) {
                Abilities a = (Abilities)it.next();
                if (!a.unlock(lock, helperRealms)) continue;
                return true;
            }
            return false;
        }

        public boolean hasRole(User user, Role role) {
            List abilities = this.findUserAbilities(user);
            Iterator it = abilities.iterator();
            while (it.hasNext()) {
                Abilities a = (Abilities)it.next();
                if (!a.hasRole(role)) continue;
                return true;
            }
            return false;
        }

        public Set collectUserLocks(User user, List helperRealms) {
            HashSet rv = new HashSet();
            List abilities = this.findUserAbilities(user);
            Iterator it = abilities.iterator();
            while (it.hasNext()) {
                Abilities a = (Abilities)it.next();
                rv.addAll(a.collectLocks(helperRealms));
            }
            return rv;
        }

        public Set collectUserRoles(User user) {
            HashSet rv = new HashSet();
            List abilities = this.findUserAbilities(user);
            Iterator it = abilities.iterator();
            while (it.hasNext()) {
                Abilities a = (Abilities)it.next();
                rv.addAll(a.collectRoles());
            }
            return rv;
        }

        public Set collectLockUsers(String lock, List helperRealms) {
            HashSet<User> rv = new HashSet<User>();
            Iterator it = this.findUserAbilityMapEntries();
            while (it.hasNext()) {
                Map.Entry entry = (Map.Entry)it.next();
                Abilities abilities = (Abilities)entry.getValue();
                String user = (String)entry.getKey();
                if (!abilities.unlock(lock, helperRealms)) continue;
                try {
                    rv.add(UserDirectoryService.getUser(user));
                }
                catch (IdUnusedException e) {
                    Log.warn("chef", this + ".collectLockUsers: unknown user: " + user);
                }
            }
            return rv;
        }

        public Set collectRoleUsers(Role role) {
            HashSet<User> rv = new HashSet<User>();
            Iterator it = this.findUserAbilityMapEntries();
            while (it.hasNext()) {
                Map.Entry entry = (Map.Entry)it.next();
                Abilities abilities = (Abilities)entry.getValue();
                String user = (String)entry.getKey();
                if (!abilities.hasRole(role)) continue;
                try {
                    rv.add(UserDirectoryService.getUser(user));
                }
                catch (IdUnusedException e) {
                    Log.warn("chef", this + ".collectRoleUsers: unknown user: " + user);
                }
            }
            return rv;
        }

        public Set collectUsers() {
            HashSet<User> rv = new HashSet<User>();
            Iterator it = this.findUserAbilityMapEntries();
            while (it.hasNext()) {
                Map.Entry entry = (Map.Entry)it.next();
                String user = (String)entry.getKey();
                try {
                    rv.add(UserDirectoryService.getUser(user));
                }
                catch (IdUnusedException e) {
                    Log.warn("chef", this + ".collectUsers: unknown user: " + user);
                }
            }
            return rv;
        }

        public Set getUsers() {
            HashSet<User> rv = new HashSet<User>();
            Iterator it = this.m_users.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                String user = (String)entry.getKey();
                try {
                    rv.add(UserDirectoryService.getUser(user));
                }
                catch (IdUnusedException e) {
                    Log.warn("chef", this + ".getUsers: unknown user: " + user);
                }
            }
            return rv;
        }

        public Set getUserLocks(User user) {
            Abilities abilities = (Abilities)this.m_users.get(user.getId());
            if (abilities == null) {
                return new HashSet();
            }
            return abilities.getLocks();
        }

        public Set getAuthLocks() {
            return this.m_authAbilities.getLocks();
        }

        public Set getAnonLocks() {
            return this.m_anonAbilities.getLocks();
        }

        public Set getUserRoles(User user) {
            Abilities abilities = (Abilities)this.m_users.get(user.getId());
            if (abilities == null) {
                return new HashSet();
            }
            return abilities.getRoles();
        }

        public Set getAuthRoles() {
            return this.m_authAbilities.getRoles();
        }

        public Set getAnonRoles() {
            return this.m_anonAbilities.getRoles();
        }

        public Set getRoles() {
            return new HashSet(this.m_roles.values());
        }

        public Role getRole(String id) {
            return (Role)this.m_roles.get(id);
        }

        public String getProviderRealmId() {
            return this.m_providerRealmId;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Realm)) {
                return false;
            }
            return ((Realm)obj).getId().equals(this.getId());
        }

        public int compareTo(Object obj) {
            if (!(obj instanceof Realm)) {
                throw new ClassCastException();
            }
            if (obj == this) {
                return 0;
            }
            int compare = this.getId().compareTo(((Realm)obj).getId());
            return compare;
        }
    }
}

