/*
 * Decompiled with CFR 0.152.
 */
package org.chefproject.util;

import java.util.Comparator;
import org.chefproject.core.ContentCollection;
import org.chefproject.core.ContentResource;
import org.chefproject.core.Resource;
import org.chefproject.util.Time;

public class ContentHostingComparator
implements Comparator {
    String m_property = null;
    boolean m_ascending = true;

    public ContentHostingComparator(String property, boolean ascending) {
        this.m_property = property;
        this.m_ascending = ascending;
    }

    public int compare(Object o1, Object o2) {
        if (o1 instanceof ContentCollection && o2 instanceof ContentResource) {
            return this.m_ascending ? -1 : 1;
        }
        if (o1 instanceof ContentResource && o2 instanceof ContentCollection) {
            return this.m_ascending ? 1 : -1;
        }
        try {
            int rv;
            long l1 = ((Resource)o1).getProperties().getLongProperty(this.m_property);
            long l2 = ((Resource)o2).getProperties().getLongProperty(this.m_property);
            int n = l1 < l2 ? -1 : (rv = l1 > l2 ? 1 : 0);
            if (!this.m_ascending) {
                rv = -rv;
            }
            return rv;
        }
        catch (Exception ignore) {
            try {
                Time t1 = ((Resource)o1).getProperties().getTimeProperty(this.m_property);
                Time t2 = ((Resource)o2).getProperties().getTimeProperty(this.m_property);
                int rv = t1.compareTo(t2);
                if (!this.m_ascending) {
                    rv = -rv;
                }
                return rv;
            }
            catch (Exception ignore2) {
                String s1 = ((Resource)o1).getProperties().getPropertyFormatted(this.m_property);
                String s2 = ((Resource)o2).getProperties().getPropertyFormatted(this.m_property);
                int rv = s1.compareToIgnoreCase(s2);
                if (!this.m_ascending) {
                    rv = -rv;
                }
                return rv;
            }
        }
    }
}

