/*
 * Copyright (c) 2022, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/* @test
 * @bug 8296900
 * @summary CertificateValidity fields are not be optional
 * @library /test/lib
 * @modules java.base/sun.security.x509
 */

import jdk.test.lib.Utils;
import sun.security.x509.CertificateValidity;

import java.util.Date;

public class NullName {

    public static void main(String[] argv) throws Exception {
        Date now = new Date();
        Utils.runAndCheckException(
                () -> new CertificateValidity(null, null),
                NullPointerException.class);
        Utils.runAndCheckException(
                () -> new CertificateValidity(now, null),
                NullPointerException.class);
        Utils.runAndCheckException(
                () -> new CertificateValidity(null, now),
                NullPointerException.class);
        new CertificateValidity(now, now);
    }
}
