/**********************************************************************
 * $my_strobe example -- C source code using TF PLI routines
 *
 * C source to synchronize to the end of a simulation time step before
 * printing the current logic value of a task/function argument.
 *
 * For the book, "The Verilog PLI Handbook" by Stuart Sutherland
 *  Book copyright 1999, Kluwer Academic Publishers, Norwell, MA, USA
 *   Contact: www.wkap.il
 *  Example copyright 1998, Sutherland HDL Inc, Portland, Oregon, USA
 *   Contact: www.sutherland.com or (503) 692-0898
 *
 * Usage:
 * ------
 *   $my_strobe(<signal_name>);
 *
 * Routine definitions for a veriusertfs array:
 *  /* routine prototypes -/
 *   extern int PLIbook_MyStrobe_checktf(),
 *              PLIbook_MyStrobe_calltf(),
 *              PLIbook_MyStrobe_misctf();
 *  /* table entries -/
 *   {usertask,                     /* type of PLI routine -/
 *     0,                           /* user_data value -/
 *     PLIbook_MyStrobe_checktf,    /* checktf routine -/
 *     0,                           /* sizetf routine -/
 *     PLIbook_MyStrobe_calltf,     /* calltf routine -/
 *     PLIbook_MyStrobe_misctf,     /* misctf routine -/
 *     "$my_strobe",                /* system task/function name -/
 *     1                            /* forward reference = true -/
 *   },
 *********************************************************************/

#include "veriuser.h"         /* IEEE 1364 PLI TF  routine library */

/**********************************************************************
 * checktf routine
 *********************************************************************/
int PLIbook_MyStrobe_checktf()
{
  if (tf_nump() != 1)
    tf_error("Usage: $my_strobe(<signal>);");
  else if (tf_typep(1) == TF_NULLPARAM)
    tf_error("Usage: $my_strobe(<signal>);");
  return(0);
}

/**********************************************************************
 * calltf routine
 *********************************************************************/
int PLIbook_MyStrobe_calltf() {
  tf_rosynchronize();
  return(0); 
}

/**********************************************************************
 * misctf routine
 *********************************************************************/
int PLIbook_MyStrobe_misctf(int user_data, int reason)
{
  if (reason == REASON_ROSYNCH) {
    io_printf("Status of tfarg 1 is %s:\n", tf_strgetp(1,'b')); 
  }
  return(0); 
}

/*********************************************************************/
