# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum
from six import with_metaclass
from azure.core import CaseInsensitiveEnumMeta


class BaseImageDependencyType(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """The type of the base image dependency.
    """

    BUILD_TIME = "BuildTime"
    RUN_TIME = "RunTime"

class BaseImageTriggerType(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """The type of the auto trigger for base image dependency updates.
    """

    ALL = "All"
    RUNTIME = "Runtime"
    NONE = "None"

class BuildArgumentType(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """The type of the argument.
    """

    DOCKER_BUILD_ARGUMENT = "DockerBuildArgument"

class BuildStatus(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """The current status of the build.
    """

    QUEUED = "Queued"
    STARTED = "Started"
    RUNNING = "Running"
    SUCCEEDED = "Succeeded"
    FAILED = "Failed"
    CANCELED = "Canceled"
    ERROR = "Error"
    TIMEOUT = "Timeout"

class BuildStepType(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """The type of the step.
    """

    DOCKER = "Docker"

class BuildTaskStatus(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """The current status of build task.
    """

    DISABLED = "Disabled"
    ENABLED = "Enabled"

class BuildType(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """The type of build.
    """

    AUTO_BUILD = "AutoBuild"
    QUICK_BUILD = "QuickBuild"

class OsType(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """The operating system type required for the build.
    """

    WINDOWS = "Windows"
    LINUX = "Linux"

class ProvisioningState(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """The provisioning state of a build.
    """

    CREATING = "Creating"
    UPDATING = "Updating"
    DELETING = "Deleting"
    SUCCEEDED = "Succeeded"
    FAILED = "Failed"
    CANCELED = "Canceled"

class SourceControlType(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """The type of source control service.
    """

    GITHUB = "Github"
    VISUAL_STUDIO_TEAM_SERVICE = "VisualStudioTeamService"

class TokenType(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """The type of Auth token.
    """

    PAT = "PAT"
    O_AUTH = "OAuth"
