// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files)
// DO NOT EDIT

use crate::Cancellable;
use glib::{prelude::*, translate::*};
use std::{fmt, ptr};

glib::wrapper! {
    #[doc(alias = "GSeekable")]
    pub struct Seekable(Interface<ffi::GSeekable, ffi::GSeekableIface>);

    match fn {
        type_ => || ffi::g_seekable_get_type(),
    }
}

impl Seekable {
    pub const NONE: Option<&'static Seekable> = None;
}

mod sealed {
    pub trait Sealed {}
    impl<T: super::IsA<super::Seekable>> Sealed for T {}
}

pub trait SeekableExt: IsA<Seekable> + sealed::Sealed + 'static {
    #[doc(alias = "g_seekable_can_seek")]
    fn can_seek(&self) -> bool {
        unsafe { from_glib(ffi::g_seekable_can_seek(self.as_ref().to_glib_none().0)) }
    }

    #[doc(alias = "g_seekable_can_truncate")]
    fn can_truncate(&self) -> bool {
        unsafe { from_glib(ffi::g_seekable_can_truncate(self.as_ref().to_glib_none().0)) }
    }

    #[doc(alias = "g_seekable_seek")]
    fn seek(
        &self,
        offset: i64,
        type_: glib::SeekType,
        cancellable: Option<&impl IsA<Cancellable>>,
    ) -> Result<(), glib::Error> {
        unsafe {
            let mut error = ptr::null_mut();
            let is_ok = ffi::g_seekable_seek(
                self.as_ref().to_glib_none().0,
                offset,
                type_.into_glib(),
                cancellable.map(|p| p.as_ref()).to_glib_none().0,
                &mut error,
            );
            debug_assert_eq!(is_ok == glib::ffi::GFALSE, !error.is_null());
            if error.is_null() {
                Ok(())
            } else {
                Err(from_glib_full(error))
            }
        }
    }

    #[doc(alias = "g_seekable_tell")]
    fn tell(&self) -> i64 {
        unsafe { ffi::g_seekable_tell(self.as_ref().to_glib_none().0) }
    }

    #[doc(alias = "g_seekable_truncate")]
    fn truncate(
        &self,
        offset: i64,
        cancellable: Option<&impl IsA<Cancellable>>,
    ) -> Result<(), glib::Error> {
        unsafe {
            let mut error = ptr::null_mut();
            let is_ok = ffi::g_seekable_truncate(
                self.as_ref().to_glib_none().0,
                offset,
                cancellable.map(|p| p.as_ref()).to_glib_none().0,
                &mut error,
            );
            debug_assert_eq!(is_ok == glib::ffi::GFALSE, !error.is_null());
            if error.is_null() {
                Ok(())
            } else {
                Err(from_glib_full(error))
            }
        }
    }
}

impl<O: IsA<Seekable>> SeekableExt for O {}

impl fmt::Display for Seekable {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        f.write_str("Seekable")
    }
}
