% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualize.R
\name{TCGAvisualize_Heatmap}
\alias{TCGAvisualize_Heatmap}
\title{Heatmap with more sensible behavior using heatmap.plus}
\usage{
TCGAvisualize_Heatmap(
  data,
  col.metadata,
  row.metadata,
  col.colors = NULL,
  row.colors = NULL,
  show_column_names = FALSE,
  show_row_names = FALSE,
  cluster_rows = FALSE,
  cluster_columns = FALSE,
  sortCol,
  extremes = NULL,
  rownames.size = 12,
  title = NULL,
  color.levels = NULL,
  values.label = NULL,
  filename = "heatmap.pdf",
  width = 10,
  height = 10,
  type = "expression",
  scale = "none",
  heatmap.legend.color.bar = "continuous"
)
}
\arguments{
\item{data}{The object to with the heatmap data (expression, methylation)}

\item{col.metadata}{Metadata for the columns (samples). It should have on of the following columns:
barcode (28 characters)  column to match with the samples. It will also work with
"bcr_patient_barcode"(12 chars),"patient"(12 chars),"sample"(16 chars) columns but as one patient might
have more than one sample, this coul lead to errors in the annotation.
The code will throw a warning in case two samples are from the same patient.}

\item{row.metadata}{Metadata for the rows  genes (expression) or probes (methylation)}

\item{col.colors}{A list of names colors}

\item{row.colors}{A list of named colors}

\item{show_column_names}{Show column names names? Default: FALSE}

\item{show_row_names}{Show row names? Default: FALSE}

\item{cluster_rows}{Cluster rows ? Default: FALSE}

\item{cluster_columns}{Cluster columns ? Default: FALSE}

\item{sortCol}{Name of the column to be used to sort the columns}

\item{extremes}{Extremes of colors (vector of 3 values)}

\item{rownames.size}{Rownames size}

\item{title}{Title of the plot}

\item{color.levels}{A vector with the colors (low level, middle level, high level)}

\item{values.label}{Text of the levels in the heatmap}

\item{filename}{Filename to save the heatmap. Default: heatmap.png}

\item{width}{figure width}

\item{height}{figure height}

\item{type}{Select the colors of the heatmap values. Possible values are
"expression" (default), "methylation"}

\item{scale}{Use z-score to make the heatmap?
If we want to show differences between genes, it is good to make Z-score by samples
(force each sample to have zero mean and standard deviation=1).
If we want to show differences between samples, it is good to make Z-score by genes
(force each gene to have zero mean and standard deviation=1).
Possibilities: "row", "col". Default "none"}

\item{heatmap.legend.color.bar}{Heatmap legends values type.
Options: "continuous", "discrete"}
}
\value{
Heatmap plotted in the device
}
\description{
Heatmap with more sensible behavior using heatmap.plus
}
\examples{
 row.mdat <- matrix(c("FALSE","FALSE",
                     "TRUE","TRUE",
                     "FALSE","FALSE",
                     "TRUE","FALSE",
                     "FALSE","TRUE"
                ),
              nrow = 5, ncol = 2, byrow = TRUE,
              dimnames = list(
                  c("probe1", "probe2","probe3","probe4","probe5"),
                  c("duplicated", "Enhancer region")))
dat <- matrix(c(0.3,0.2,0.3,1,1,0.1,1,1,0, 0.8,1,0.7,0.7,0.3,1),
             nrow = 5, ncol = 3, byrow = TRUE,
               dimnames = list(
               c("probe1", "probe2","probe3","probe4","probe5"),
               c("TCGA-DU-6410",
                 "TCGA-DU-A5TS",
                 "TCGA-HT-7688")))

mdat <- data.frame(patient=c("TCGA-DU-6410","TCGA-DU-A5TS","TCGA-HT-7688"),
                   Sex=c("Male","Female","Male"),
                   COCCluster=c("coc1","coc1","coc1"),
                   IDHtype=c("IDHwt","IDHMut-cod","IDHMut-noncod"))

TCGAvisualize_Heatmap(dat,
                    col.metadata = mdat,
                    row.metadata = row.mdat,
                    row.colors = list(duplicated = c("FALSE" = "pink",
                                                     "TRUE"="green"),
                                     "Enhancer region" = c("FALSE" = "purple",
                                                            "TRUE"="grey")),
                    col.colors = list(Sex = c("Male" = "blue", "Female"="red"),
                                      COCCluster=c("coc1"="grey"),
                                      IDHtype=c("IDHwt"="cyan",
                                      "IDHMut-cod"="tomato"
                                      ,"IDHMut-noncod"="gold")),
                    type = "methylation",
                    show_row_names=TRUE)
}
