% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/q.soft.R
\name{q.soft}
\alias{q.soft}
\title{Quantile of soft-thresholding Fisher's p-value combination statistic under the null hypothesis.}
\usage{
q.soft(p, n, tau1, M = NULL)
}
\arguments{
\item{p}{-  a scalar left probability that defines the quantile.}

\item{n}{- dimension parameter, i.e. the number of input p-values.}

\item{tau1}{- truncation parameter=normalization parameter. tau1 > 0.}

\item{M}{- correlation matrix of the input statistics. Default = NULL assumes independence.}
}
\value{
Quantile of soft-thresholding Fisher's p-value combination statistic.
}
\description{
Quantile of soft-thresholding Fisher's p-value combination statistic under the null hypothesis.
}
\examples{
## The 0.05 critical value of soft-thresholding statistic when n = 10:
q.soft(p=.99, n=20, tau1 = 0.05)
M = matrix(0.9,20,20) + diag(1-0.9,20)
q.soft(p=.99, n=20, tau1 = 0.05, M=M)
}
\references{
1. Hong Zhang and Zheyang Wu. "TFisher Tests: Optimal and Adaptive Thresholding for Combining p-Values", submitted.
}
\seealso{
\code{\link{stat.soft}} for the definition of the statistic.
}
