; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -verify-machineinstrs -mtriple=powerpc64-unknown-unknown \
; RUN:  -ppc-asm-full-reg-names < %s  | FileCheck %s
; RUN: llc -verify-machineinstrs -mtriple=powerpc64le-unknown-unknown \
; RUN:  -ppc-asm-full-reg-names < %s  | FileCheck %s

define zeroext i1 @eq1(i1 zeroext %x, i1 zeroext %y) {
; CHECK-LABEL: eq1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    add r3, r4, r3
; CHECK-NEXT:    cntlzw r3, r3
; CHECK-NEXT:    srwi r3, r3, 5
; CHECK-NEXT:    blr
  %sub = sext i1 %x to i32
  %conv3 = zext i1 %y to i32
  %cmp = icmp eq i32 %sub, %conv3
  ret i1 %cmp
}

define zeroext i8 @eq2(i8 zeroext %x, i8 zeroext %y) {
; CHECK-LABEL: eq2:
; CHECK:       # %bb.0:
; CHECK-NEXT:    add r3, r4, r3
; CHECK-NEXT:    cntlzw r3, r3
; CHECK-NEXT:    srwi r3, r3, 5
; CHECK-NEXT:    blr
  %conv = zext i8 %x to i32
  %sub = sub nsw i32 0, %conv
  %conv1 = zext i8 %y to i32
  %cmp = icmp eq i32 %sub, %conv1
  %conv3 = zext i1 %cmp to i8
  ret i8 %conv3
}

define signext i16 @eq3(i16 signext %x, i16 signext %y) {
; CHECK-LABEL: eq3:
; CHECK:       # %bb.0:
; CHECK-NEXT:    add r3, r4, r3
; CHECK-NEXT:    cntlzw r3, r3
; CHECK-NEXT:    srwi r3, r3, 5
; CHECK-NEXT:    blr
  %conv = sext i16 %x to i32
  %sub = sub nsw i32 0, %conv
  %conv1 = sext i16 %y to i32
  %cmp = icmp eq i32 %sub, %conv1
  %conv3 = zext i1 %cmp to i16
  ret i16 %conv3
}

define zeroext i16 @eq4(i16 zeroext %x, i16 zeroext %y) {
; CHECK-LABEL: eq4:
; CHECK:       # %bb.0:
; CHECK-NEXT:    add r3, r4, r3
; CHECK-NEXT:    cntlzw r3, r3
; CHECK-NEXT:    srwi r3, r3, 5
; CHECK-NEXT:    blr
  %conv = zext i16 %x to i32
  %sub = sub nsw i32 0, %conv
  %conv1 = zext i16 %y to i32
  %cmp = icmp eq i32 %sub, %conv1
  %conv3 = zext i1 %cmp to i16
  ret i16 %conv3
}

define signext i32 @eq5(i32 signext %x, i32 signext %y) {
; CHECK-LABEL: eq5:
; CHECK:       # %bb.0:
; CHECK-NEXT:    add r3, r4, r3
; CHECK-NEXT:    cntlzw r3, r3
; CHECK-NEXT:    srwi r3, r3, 5
; CHECK-NEXT:    blr
  %sub = sub nsw i32 0, %x
  %cmp = icmp eq i32 %sub, %y
  %conv = zext i1 %cmp to i32
  ret i32 %conv
}

define zeroext i32 @eq6(i32 zeroext %x, i32 zeroext %y) {
; CHECK-LABEL: eq6:
; CHECK:       # %bb.0:
; CHECK-NEXT:    add r3, r4, r3
; CHECK-NEXT:    cntlzw r3, r3
; CHECK-NEXT:    srwi r3, r3, 5
; CHECK-NEXT:    blr
  %sub = sub i32 0, %x
  %cmp = icmp eq i32 %sub, %y
  %conv = zext i1 %cmp to i32
  ret i32 %conv
}

define i64 @eq7(i64 %x, i64 %y) {
; CHECK-LABEL: eq7:
; CHECK:       # %bb.0:
; CHECK-NEXT:    add r3, r4, r3
; CHECK-NEXT:    cntlzd r3, r3
; CHECK-NEXT:    rldicl r3, r3, 58, 63
; CHECK-NEXT:    blr
  %sub = sub nsw i64 0, %x
  %cmp = icmp eq i64 %sub, %y
  %zext = zext i1 %cmp to i64
  ret i64 %zext
}

define zeroext i1 @eq8(i1 zeroext %x, i1 zeroext %y) {
; CHECK-LABEL: eq8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    add r3, r4, r3
; CHECK-NEXT:    cntlzw r3, r3
; CHECK-NEXT:    srwi r3, r3, 5
; CHECK-NEXT:    blr
  %conv = zext i1 %y to i32
  %sub = sext i1 %x to i32
  %cmp = icmp eq i32 %conv, %sub
  ret i1 %cmp
}

define zeroext i8 @eq9(i8 zeroext %x, i8 zeroext %y) {
; CHECK-LABEL: eq9:
; CHECK:       # %bb.0:
; CHECK-NEXT:    add r3, r3, r4
; CHECK-NEXT:    cntlzw r3, r3
; CHECK-NEXT:    srwi r3, r3, 5
; CHECK-NEXT:    blr
  %conv = zext i8 %x to i32
  %conv1 = zext i8 %y to i32
  %sub = sub nsw i32 0, %conv1
  %cmp = icmp eq i32 %conv, %sub
  %conv3 = zext i1 %cmp to i8
  ret i8 %conv3
}

define signext i16 @eq10(i16 signext %x, i16 signext %y) {
; CHECK-LABEL: eq10:
; CHECK:       # %bb.0:
; CHECK-NEXT:    add r3, r3, r4
; CHECK-NEXT:    cntlzw r3, r3
; CHECK-NEXT:    srwi r3, r3, 5
; CHECK-NEXT:    blr
  %conv = sext i16 %x to i32
  %conv1 = sext i16 %y to i32
  %sub = sub nsw i32 0, %conv1
  %cmp = icmp eq i32 %conv, %sub
  %conv3 = zext i1 %cmp to i16
  ret i16 %conv3
}

define zeroext i16 @eq11(i16 zeroext %x, i16 zeroext %y) {
; CHECK-LABEL: eq11:
; CHECK:       # %bb.0:
; CHECK-NEXT:    add r3, r3, r4
; CHECK-NEXT:    cntlzw r3, r3
; CHECK-NEXT:    srwi r3, r3, 5
; CHECK-NEXT:    blr
  %conv = zext i16 %x to i32
  %conv1 = zext i16 %y to i32
  %sub = sub nsw i32 0, %conv1
  %cmp = icmp eq i32 %conv, %sub
  %conv3 = zext i1 %cmp to i16
  ret i16 %conv3
}

define signext i32 @eq12(i32 signext %x, i32 signext %y) {
; CHECK-LABEL: eq12:
; CHECK:       # %bb.0:
; CHECK-NEXT:    add r3, r3, r4
; CHECK-NEXT:    cntlzw r3, r3
; CHECK-NEXT:    srwi r3, r3, 5
; CHECK-NEXT:    blr
  %sub = sub nsw i32 0, %y
  %cmp = icmp eq i32 %sub, %x
  %conv = zext i1 %cmp to i32
  ret i32 %conv
}

define zeroext i32 @eq13(i32 zeroext %x, i32 zeroext %y) {
; CHECK-LABEL: eq13:
; CHECK:       # %bb.0:
; CHECK-NEXT:    add r3, r3, r4
; CHECK-NEXT:    cntlzw r3, r3
; CHECK-NEXT:    srwi r3, r3, 5
; CHECK-NEXT:    blr
  %sub = sub i32 0, %y
  %cmp = icmp eq i32 %sub, %x
  %conv = zext i1 %cmp to i32
  ret i32 %conv
}

define i64 @eq14(i64 %x, i64 %y) {
; CHECK-LABEL: eq14:
; CHECK:       # %bb.0:
; CHECK-NEXT:    add r3, r3, r4
; CHECK-NEXT:    cntlzd r3, r3
; CHECK-NEXT:    rldicl r3, r3, 58, 63
; CHECK-NEXT:    blr
  %sub = sub nsw i64 0, %y
  %cmp = icmp eq i64 %sub, %x
  %conv1 = zext i1 %cmp to i64
  ret i64 %conv1
}

define zeroext i1 @neq1(i1 zeroext %x, i1 zeroext %y) {
; CHECK-LABEL: neq1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    add r3, r4, r3
; CHECK-NEXT:    cntlzw r3, r3
; CHECK-NEXT:    srwi r3, r3, 5
; CHECK-NEXT:    xori r3, r3, 1
; CHECK-NEXT:    blr
  %sub = sext i1 %x to i32
  %conv3 = zext i1 %y to i32
  %cmp = icmp ne i32 %sub, %conv3
  ret i1 %cmp
}

define zeroext i8 @neq2(i8 zeroext %x, i8 zeroext %y) {
; CHECK-LABEL: neq2:
; CHECK:       # %bb.0:
; CHECK-NEXT:    add r3, r4, r3
; CHECK-NEXT:    cntlzw r3, r3
; CHECK-NEXT:    srwi r3, r3, 5
; CHECK-NEXT:    xori r3, r3, 1
; CHECK-NEXT:    blr
  %conv = zext i8 %x to i32
  %sub = sub nsw i32 0, %conv
  %conv1 = zext i8 %y to i32
  %cmp = icmp ne i32 %sub, %conv1
  %conv3 = zext i1 %cmp to i8
  ret i8 %conv3
}

define signext i16 @neq3(i16 signext %x, i16 signext %y) {
; CHECK-LABEL: neq3:
; CHECK:       # %bb.0:
; CHECK-NEXT:    add r3, r4, r3
; CHECK-NEXT:    cntlzw r3, r3
; CHECK-NEXT:    srwi r3, r3, 5
; CHECK-NEXT:    xori r3, r3, 1
; CHECK-NEXT:    blr
  %conv = sext i16 %x to i32
  %sub = sub nsw i32 0, %conv
  %conv1 = sext i16 %y to i32
  %cmp = icmp ne i32 %sub, %conv1
  %conv3 = zext i1 %cmp to i16
  ret i16 %conv3
}

define zeroext i16 @neq4(i16 zeroext %x, i16 zeroext %y) {
; CHECK-LABEL: neq4:
; CHECK:       # %bb.0:
; CHECK-NEXT:    add r3, r4, r3
; CHECK-NEXT:    cntlzw r3, r3
; CHECK-NEXT:    srwi r3, r3, 5
; CHECK-NEXT:    xori r3, r3, 1
; CHECK-NEXT:    blr
  %conv = zext i16 %x to i32
  %sub = sub nsw i32 0, %conv
  %conv1 = zext i16 %y to i32
  %cmp = icmp ne i32 %sub, %conv1
  %conv3 = zext i1 %cmp to i16
  ret i16 %conv3
}

define signext i32 @neq5(i32 signext %x, i32 signext %y) {
; CHECK-LABEL: neq5:
; CHECK:       # %bb.0:
; CHECK-NEXT:    add r3, r4, r3
; CHECK-NEXT:    cntlzw r3, r3
; CHECK-NEXT:    srwi r3, r3, 5
; CHECK-NEXT:    xori r3, r3, 1
; CHECK-NEXT:    blr
  %sub = sub nsw i32 0, %x
  %cmp = icmp ne i32 %sub, %y
  %conv = zext i1 %cmp to i32
  ret i32 %conv
}

define zeroext i32 @neq6(i32 zeroext %x, i32 zeroext %y) {
; CHECK-LABEL: neq6:
; CHECK:       # %bb.0:
; CHECK-NEXT:    add r3, r4, r3
; CHECK-NEXT:    cntlzw r3, r3
; CHECK-NEXT:    srwi r3, r3, 5
; CHECK-NEXT:    xori r3, r3, 1
; CHECK-NEXT:    blr
  %sub = sub i32 0, %x
  %cmp = icmp ne i32 %sub, %y
  %conv = zext i1 %cmp to i32
  ret i32 %conv
}

define i64 @neq7(i64 %x, i64 %y) {
; CHECK-LABEL: neq7:
; CHECK:       # %bb.0:
; CHECK-NEXT:    add r3, r4, r3
; CHECK-NEXT:    addic r4, r3, -1
; CHECK-NEXT:    subfe r3, r4, r3
; CHECK-NEXT:    blr
  %sub = sub nsw i64 0, %x
  %cmp = icmp ne i64 %sub, %y
  %zext = zext i1 %cmp to i64
  ret i64 %zext
}

define zeroext i1 @neq8(i1 zeroext %x, i1 zeroext %y) {
; CHECK-LABEL: neq8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    add r3, r4, r3
; CHECK-NEXT:    cntlzw r3, r3
; CHECK-NEXT:    srwi r3, r3, 5
; CHECK-NEXT:    xori r3, r3, 1
; CHECK-NEXT:    blr
  %conv = zext i1 %y to i32
  %sub = sext i1 %x to i32
  %cmp = icmp ne i32 %conv, %sub
  ret i1 %cmp
}

define zeroext i8 @neq9(i8 zeroext %x, i8 zeroext %y) {
; CHECK-LABEL: neq9:
; CHECK:       # %bb.0:
; CHECK-NEXT:    add r3, r4, r3
; CHECK-NEXT:    cntlzw r3, r3
; CHECK-NEXT:    srwi r3, r3, 5
; CHECK-NEXT:    xori r3, r3, 1
; CHECK-NEXT:    blr
  %conv = zext i8 %y to i32
  %conv1 = zext i8 %x to i32
  %sub = sub nsw i32 0, %conv1
  %cmp = icmp ne i32 %conv, %sub
  %conv3 = zext i1 %cmp to i8
  ret i8 %conv3
}

define signext i16 @neq10(i16 signext %x, i16 signext %y) {
; CHECK-LABEL: neq10:
; CHECK:       # %bb.0:
; CHECK-NEXT:    add r3, r4, r3
; CHECK-NEXT:    cntlzw r3, r3
; CHECK-NEXT:    srwi r3, r3, 5
; CHECK-NEXT:    xori r3, r3, 1
; CHECK-NEXT:    blr
  %conv = sext i16 %y to i32
  %conv1 = sext i16 %x to i32
  %sub = sub nsw i32 0, %conv1
  %cmp = icmp ne i32 %conv, %sub
  %conv3 = zext i1 %cmp to i16
  ret i16 %conv3
}

define zeroext i16 @neq11(i16 zeroext %x, i16 zeroext %y) {
; CHECK-LABEL: neq11:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    add r3, r4, r3
; CHECK-NEXT:    cntlzw r3, r3
; CHECK-NEXT:    srwi r3, r3, 5
; CHECK-NEXT:    xori r3, r3, 1
; CHECK-NEXT:    blr
entry:
  %conv = zext i16 %y to i32
  %conv1 = zext i16 %x to i32
  %sub = sub nsw i32 0, %conv1
  %cmp = icmp ne i32 %conv, %sub
  %conv3 = zext i1 %cmp to i16
  ret i16 %conv3
}

define signext i32 @neq12(i32 signext %x, i32 signext %y) {
; CHECK-LABEL: neq12:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    add r3, r4, r3
; CHECK-NEXT:    cntlzw r3, r3
; CHECK-NEXT:    srwi r3, r3, 5
; CHECK-NEXT:    xori r3, r3, 1
; CHECK-NEXT:    blr
entry:
  %sub = sub nsw i32 0, %x
  %cmp = icmp ne i32 %sub, %y
  %conv = zext i1 %cmp to i32
  ret i32 %conv
}

define zeroext i32 @neq13(i32 zeroext %x, i32 zeroext %y) {
; CHECK-LABEL: neq13:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    add r3, r4, r3
; CHECK-NEXT:    cntlzw r3, r3
; CHECK-NEXT:    srwi r3, r3, 5
; CHECK-NEXT:    xori r3, r3, 1
; CHECK-NEXT:    blr
entry:
  %sub = sub i32 0, %x
  %cmp = icmp ne i32 %sub, %y
  %conv = zext i1 %cmp to i32
  ret i32 %conv
}

define i64 @neq14(i64 %x, i64 %y) {
; CHECK-LABEL: neq14:
; CHECK:       # %bb.0:
; CHECK-NEXT:    add r3, r4, r3
; CHECK-NEXT:    addic r4, r3, -1
; CHECK-NEXT:    subfe r3, r4, r3
; CHECK-NEXT:    blr
  %sub = sub nsw i64 0, %x
  %cmp = icmp ne i64 %y, %sub
  %zext = zext i1 %cmp to i64
  ret i64 %zext
}
