/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.tcode;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Delete;
import org.apache.tools.ant.taskdefs.Execute;
import org.apache.tools.ant.taskdefs.ExecuteStreamHandler;
import org.apache.tools.ant.taskdefs.LogStreamHandler;
import org.apache.tools.ant.types.Commandline;
import org.apache.tools.ant.util.GlobPatternMapper;

public class PdfLatex
extends Task {
    private File latexFile;

    public File getLatexfile() {
        return this.latexFile;
    }

    public void setLatexfile(File file) {
        this.latexFile = file;
    }

    public void execute() throws BuildException {
        String string;
        BufferedReader bufferedReader;
        if (this.latexFile == null) {
            throw new BuildException("No LaTeX file given", this.getLocation());
        }
        if (!this.latexFile.exists()) {
            throw new BuildException("Given LaTeX file " + this.latexFile.getAbsoluteFile() + " does not exist", this.getLocation());
        }
        boolean bl = false;
        GlobPatternMapper globPatternMapper = new GlobPatternMapper();
        globPatternMapper.setFrom("*.tex");
        globPatternMapper.setTo("*.pdf");
        File file = new File(this.latexFile.getParentFile(), globPatternMapper.mapFileName(this.latexFile.getName())[0]);
        if (this.latexFile.lastModified() > file.lastModified()) {
            bl = true;
        }
        try {
            bufferedReader = new BufferedReader(new FileReader(this.latexFile));
            string = null;
            while ((string = bufferedReader.readLine()) != null && !bl) {
                String string2 = null;
                int n = string.indexOf(37);
                if (n != -1) {
                    string = string.substring(0, n);
                }
                if ((n = string.indexOf("\\include")) != -1 && !Character.isLetter(string.charAt(n + "\\include".length()))) {
                    n += "\\include".length();
                    while (n < string.length() && Character.isWhitespace(string.charAt(n))) {
                        ++n;
                    }
                    if (n == string.length()) {
                        this.log("Could not find argument to \\include command", 1);
                    }
                    if (string.charAt(n) == '{') {
                        int n2;
                        for (n2 = n + 1; n2 < string.length() && string.charAt(n2) != '}'; ++n2) {
                        }
                        if (n2 == string.length()) {
                            this.log("Could not find matching brace for \\include command", 1);
                        } else {
                            string2 = string.substring(n + 1, n2).trim();
                        }
                    } else {
                        string2 = string.substring(n, n + 1);
                    }
                }
                if (string2 == null) continue;
                File file2 = new File(this.latexFile.getParentFile(), string2 + ".tex");
                if (!file2.exists()) {
                    this.log("The included file " + file2.getAbsolutePath() + " could not be found", 1);
                    continue;
                }
                if (file2.lastModified() <= file.lastModified()) continue;
                bl = true;
            }
            bufferedReader.close();
        }
        catch (IOException iOException) {
            throw new BuildException("Cannot open the input LaTeX file", (Throwable)iOException, this.getLocation());
        }
        if (!bl) {
            return;
        }
        bufferedReader = new Execute((ExecuteStreamHandler)new LogStreamHandler((Task)this, 3, 1));
        bufferedReader.setAntRun(this.getProject());
        bufferedReader.setWorkingDirectory(this.latexFile.getParentFile());
        string = new Delete();
        string.setDir(this.latexFile.getParentFile());
        string.setIncludes("*.aux");
        for (int i = 0; i < 3; ++i) {
            if (i == 0) {
                this.log("Initial run of pdfLaTeX on " + this.latexFile.getAbsoluteFile());
            } else if (i == 1) {
                this.log("Reference updating run of pdfLaTeX on " + this.latexFile.getAbsoluteFile());
            } else {
                this.log("Updating toc run of pdfLaTeX on " + this.latexFile.getAbsoluteFile());
            }
            Commandline commandline = new Commandline();
            commandline.setExecutable("pdflatex");
            commandline.createArgument().setValue("-interaction");
            commandline.createArgument().setValue("nonstopmode");
            commandline.createArgument().setFile(this.latexFile);
            bufferedReader.setCommandline(commandline.getCommandline());
            try {
                bufferedReader.execute();
            }
            catch (IOException iOException) {
                throw new BuildException("Error executing pdfLaTeX", (Throwable)iOException, this.getLocation());
            }
            if (bufferedReader.getExitValue() != 0) {
                throw new BuildException("Could not execute pdfLaTeX", this.getLocation());
            }
            if (i != 0) continue;
            this.log("Running bibTeX on " + this.latexFile.getAbsoluteFile());
            commandline = new Commandline();
            commandline.setExecutable("bibtex");
            globPatternMapper.setTo("*");
            commandline.createArgument().setFile(new File(this.latexFile.getParentFile(), globPatternMapper.mapFileName(this.latexFile.getName())[0]));
            bufferedReader.setCommandline(commandline.getCommandline());
            try {
                bufferedReader.execute();
            }
            catch (IOException iOException) {
                throw new BuildException("Error executing bibTeX", (Throwable)iOException, this.getLocation());
            }
            if (bufferedReader.getExitValue() == 0) continue;
            this.log("Could not execute bibTeX");
        }
    }
}

