/*
 * Author:      William Chia-Wei Cheng (bill.cheng@acm.org)
 *
 * Copyright (C) 2001-2009, William Chia-Wei Cheng.
 *
 * This file may be distributed under the terms of the Q Public License
 * as defined by Trolltech AS of Norway and appearing in the file
 * LICENSE.QPL included in the packaging of this file.
 *
 * THIS FILE IS PROVIDED AS IS WITH NO WARRANTY OF ANY KIND, INCLUDING
 * THE WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE.  IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING
 * FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
 * NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION
 * WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 * @(#)$Header: /mm2/home/cvs/bc-src/tgif/cmdids.h,v 1.35 2011/06/09 15:55:15 cvsps Exp $
 */

#ifndef _CMDIDS_H_
#define _CMDIDS_H_

#define TG_COMMAND ((short)0x8001)

#define CMDID_BASE 100

#define CMDID_SELECTALL     100
#define CMDID_BACK          101
#define CMDID_CHANGEDOMAIN  102
#define CMDID_DUPLICATE     103
#define CMDID_PUSHCURCHOICE 104
#define CMDID_FRONT         105
#define CMDID_GROUP         106
#define CMDID_INSTANTIATE   107
#define CMDID_POP           108
#define CMDID_ALIGNOBJS     109
#define CMDID_NEW           110
#define CMDID_OPEN          111
#define CMDID_PRINT         112
#define CMDID_QUIT          113
#define CMDID_REDRAW        114
#define CMDID_SAVE          115
#define CMDID_ALIGNTOGRID   116
#define CMDID_UNGROUP       117
#define CMDID_PUSH          118
#define CMDID_DRAWTEXT      119
#define CMDID_DELETE        120
#define CMDID_COPY          121
#define CMDID_ANIMATE       122
#define CMDID_SCROLLLEFT    123
#define CMDID_SCROLLRIGHT   124

#define CMDID_PRINTWITHCMD     125
#define CMDID_ATTACHATTRS      126
#define CMDID_PROBE            127
#define CMDID_ROTATECOUNTER    128
#define CMDID_DECGRID          129
#define CMDID_ANIMATESEND      130
#define CMDID_ANIMATEFLASH     131
#define CMDID_TOGGLEGRID       132
#define CMDID_FLIPHORIZONTAL   133
#define CMDID_INCGRID          134
#define CMDID_HIDEATTRNAME     135
#define CMDID_SELECTMODE       136
#define CMDID_DISTRIBUTEOBJS   137
#define CMDID_MOVEJUSTIFYATTR  138
#define CMDID_SHOWATTRNAME     139
#define CMDID_ZOOMOUT          140
#define CMDID_IMPORT           141
#define CMDID_DRAWPOLY         142
#define CMDID_DRAWBOX          143
#define CMDID_SOLVE            144
#define CMDID_DETACHATTRS      145
#define CMDID_UNDO             146
#define CMDID_FLIPVERTICAL     147
#define CMDID_ROTATECLOCKWISE  148
#define CMDID_ESCAPE           149

#define CMDID_SIMULATE         150
#define CMDID_ZOOMIN           151
#define CMDID_SPECIFYANARC     152
#define CMDID_UPDATE           153
#define CMDID_SCROLLUP         154
#define CMDID_SCROLLDOWN       155
#define CMDID_SHOWATTR         156
#define CMDID_ALIGNOBJSTOP     157
#define CMDID_ALIGNOBJSMIDDLE  158
#define CMDID_ALIGNOBJSBOTTOM  159
#define CMDID_ALIGNOBJSLEFT    160
#define CMDID_ALIGNOBJSCENTER  161
#define CMDID_ALIGNOBJSRIGHT   162
#define CMDID_MAKEREGPOLYGON   163
#define CMDID_SETREDUCTION     164
#define CMDID_DEFAULTZOOM      165
#define CMDID_ZOOMWAYOUT       166
#define CMDID_SAVENEW          167
#define CMDID_CUTBITPIXMAP     168
#define CMDID_ABUTHORIZONTAL   169
#define CMDID_ABUTVERTICAL     170
#define CMDID_BREAKUPTEXT      171
#define CMDID_SCROLLTOORIG     172
#define CMDID_TOGGLEMOVEMODE   173
#define CMDID_SELECTVERTEXMODE 174

#define CMDID_ALIGNTOPAGE      175
#define CMDID_REDO             176
#define CMDID_IMPORTEPSFILE    177
#define CMDID_PRECISESCALE     178
#define CMDID_LOCK             179
#define CMDID_UNLOCK           180
#define CMDID_ADDPOINT         181
#define CMDID_BOLD             182
#define CMDID_CENTER           183
#define CMDID_DELETEPOINT      184
#define CMDID_DRAWRCBOX        185
#define CMDID_INVERTXBITMAP    186
#define CMDID_TOGGLESNAP       187
#define CMDID_HIDEATTR         188
#define CMDID_MAKEICONIC       189
#define CMDID_UNMAKEICONIC     190
#define CMDID_TOGGLEBWCOLORPS  191
#define CMDID_LEFT             192
#define CMDID_MAKESYMBOLIC     193
#define CMDID_UNMAKESYMBOLIC   194
#define CMDID_ROMAN            195
#define CMDID_BOLDITALIC       196
#define CMDID_DRAWPOLYGON      197
#define CMDID_RIGHT            198
#define CMDID_SAVESELECTEDAS   199

#define CMDID_ITALIC             200
#define CMDID_UPDATESYMBOLS      201
#define CMDID_DRAWOVAL           202
#define CMDID_TOGGLELINETYPE     203
#define CMDID_CYCLEPRINFORMAT    204
#define CMDID_PASTE              205
#define CMDID_DRAWARC            206
#define CMDID_IMPORTXBITMAP      207
#define CMDID_IMPORTXPIXMAP      208
#define CMDID_TOGGLEGRIDSYSTEM   209
#define CMDID_DRAWCORNEROVAL     210
#define CMDID_DRAWCENTEROVAL     211
#define CMDID_DRAWEDGEOVAL       212
#define CMDID_SCROLLPAGEUP       213
#define CMDID_SCROLLPAGEDOWN     214
#define CMDID_SCROLLPAGELEFT     215
#define CMDID_SCROLLPAGERIGHT    216
#define CMDID_FLUSHUNDOBUFFER    217
#define CMDID_PRINTMSGBUFFER     218
#define CMDID_SAVEORIGIN         219
#define CMDID_RESTOREIMAGEWH     220
#define CMDID_UPDATEEPS          221
#define CMDID_TOGGLEMAPSHOWN     222
#define CMDID_TOGGLEUSEGRAYSCALE 223
#define CMDID_FREEHANDMODE       224

#define CMDID_SAVESYMINLIBRARY      225
#define CMDID_CENTERANENDPOINT      226
#define CMDID_CENTERAVERTEX         227
#define CMDID_NEXTPAGE              228
#define CMDID_PREVPAGE              229
#define CMDID_NAMEPAGES             230
#define CMDID_GOTOPAGE              231
#define CMDID_ADDPAGEBEFORE         232
#define CMDID_ADDPAGEAFTER          233
#define CMDID_DELETECURPAGE         234
#define CMDID_TOGGLEPAGELINESHOWN   235
#define CMDID_SPECIFYDRAWINGSIZE    236
#define CMDID_PRINTONEPAGE          237
#define CMDID_ATTACHFILEATTRS       238
#define CMDID_DETACHFILEATTRS       239
#define CMDID_EDITFILEATTRS         240
#define CMDID_PRINTSELECTEDOBJS     241
#define CMDID_INPUTPOLYPTS          242
#define CMDID_INPUTPOLYGONPTS       243
#define CMDID_EDITATTRS             244
#define CMDID_CONVERTINTSPLINE      245
#define CMDID_PASTEFROMFILE         246
#define CMDID_TOGGLESHOWMEASUREMENT 247
#define CMDID_SETMEASUREUNIT        248
#define CMDID_CUT                   249

#define CMDID_TOGGLESMOOTHHINGE      250
#define CMDID_TOGGLESHOWMENUBAR      251
#define CMDID_TOGGLESHOWSTATUS       252
#define CMDID_BROWSEXBITMAP          253
#define CMDID_BROWSEXPIXMAP          254
#define CMDID_SPECIFYPAPERSIZE       255
#define CMDID_TOGGLEONEMOTIONSELMOVE 256
#define CMDID_GOBACK                 257
#define CMDID_GOFORWARD              258
#define CMDID_REFRESHCURRENT         259
#define CMDID_HOTLIST                260
#define CMDID_ADDCURRENTTOHOTLIST    261
#define CMDID_SESSIONHISTORY         262
#define CMDID_TOGGLEHYPERSPACE       263
#define CMDID_EMBEDEPSFILE           264
#define CMDID_SETSELLINEWIDTH        265
#define CMDID_ADDCOLOR               266
#define CMDID_IMPORTATTRS            267
#define CMDID_EXPORTATTRS            268
#define CMDID_MERGEWITHTABLE         269
#define CMDID_EXPORTTOTABLE          270
#define CMDID_DELETEPAGES            271
#define CMDID_PRINTONEFILEPERPAGE    272
#define CMDID_IMPORTGIFFILE          273
#define CMDID_SETEXPORTPIXELTRIM     274

#define CMDID_WHITEBOARD             275
#define CMDID_TOGGLECOLORLAYERS      276
#define CMDID_TOGGLESTRETCHABLETEXT  277
#define CMDID_BREAKUPBITPIXMAP       278
#define CMDID_LAYOUTONARC            279
#define CMDID_PRECISEROTATE          280
#define CMDID_JOINPOLY               281
#define CMDID_CUTPOLY                282
#define CMDID_GETBOUNDINGBOX         283
#define CMDID_SETTEMPLATE            284
#define CMDID_MAKEGRAY               285
#define CMDID_INVERTCOLOR            286
#define CMDID_INTERPOLATECOLOR       287
#define CMDID_BRIGHTENDARKEN         288
#define CMDID_CHANGESATURATION       289
#define CMDID_CHANGEHUE              290
#define CMDID_CONTRASTENHANCE        291
#define CMDID_COLORBALANCE           292
#define CMDID_GAMMA                  293
#define CMDID_EDGEDETECT             294
#define CMDID_EMBOSS                 295
#define CMDID_REDUCECOLORS           296
#define CMDID_REDUCETOPIXMAPCOLORS   297
#define CMDID_SETDEFAULTCOLORLEVELS  298
#define CMDID_REDUCETODEFAULTCOLORs  299

#define CMDID_DEFAULTERRORDIFFUSE 300
#define CMDID_SPREAD              301
#define CMDID_SHARPEN             302
#define CMDID_BLUR3               303
#define CMDID_BLUR5               304
#define CMDID_BLUR7               305
#define CMDID_RUNBGGEN            306
#define CMDID_CIRCULARBGGEN       307
#define CMDID_SIMPLERECTBGGEN     308
#define CMDID_REGENERATEIMAGE     309
#define CMDID_CROPIMAGE           310
#define CMDID_GETCOLOR            311
#define CMDID_REPLACECOLOR        312
#define CMDID_FLOODFILL           313
#define CMDID_CREATECONTOUR       314
#define CMDID_SUBTRACT            315
#define CMDID_ALPHACOMBINE        316
#define CMDID_VECTORWARP          317
#define CMDID_XORCOLORS           318
#define CMDID_IMPORTOTHERFILE     319
#define CMDID_BROWSEOTHER         320
#define CMDID_TOGGLESHOWCROSSHAIR 321
#define CMDID_SETSHAPESHADOW      322
#define CMDID_NOTRANSFORM         323
#define CMDID_ABOUT               324

#define CMDID_COPYRIGHT             325
#define CMDID_SETSELFONTSIZE        326
#define CMDID_ZOOMINATCURSOR        327
#define CMDID_CENTERATCURSOR        328
#define CMDID_SETEDITTEXTSIZE       329
#define CMDID_SETTEXTROTATION       330
#define CMDID_SETROTATIONINCREMENT  331
#define CMDID_FINDCASESENSITIVE     332
#define CMDID_FINDNOCASE            333
#define CMDID_FINDAGAIN             334
#define CMDID_CURRENTVERSIONINFO    335
#define CMDID_LATESTRELEASEINFO     336
#define CMDID_CONNECTPINS           337
#define CMDID_PASTECOMPOUNDTEXT     338
#define CMDID_COPYPROPERTIES        339
#define CMDID_SAVEPROPERTIES        340
#define CMDID_PASTEPROPERTIES       341
#define CMDID_RESTOREPROPERTIES     342
#define CMDID_ROTATESHEARMODE       343
#define CMDID_CHANGEALLSELFILL      344
#define CMDID_CHANGEALLSELPEN       345
#define CMDID_CHANGEALLSELLINEWIDTH 346
#define CMDID_CHANGEALLSELLINESTYLE 347
#define CMDID_CHANGEALLSELLINETYPE  348
#define CMDID_CHANGEALLSELLINEDASH  349

#define CMDID_CHANGEALLSELFONT       350
#define CMDID_CHANGEALLSELFONTSIZE   351
#define CMDID_CHANGEALLSELFONTSTYLE  352
#define CMDID_CHANGEALLSELFONTJUST   353
#define CMDID_CHANGEALLSELCOLOR      354
#define CMDID_LANDSCAPEMODE          355
#define CMDID_PORTRAITMODE           356
#define CMDID_SETWHERETOPRINT        357
#define CMDID_SETHORIZONTALALIGN     358
#define CMDID_SETVERTICALALIGN       359
#define CMDID_SETMOVEMODE            360
#define CMDID_SETSTRETCHTEXTMODE     361
#define CMDID_CREATESHAPE            362
#define CMDID_SETPAGELAYOUTMODE      363
#define CMDID_SETTRANSPATMODE        364
#define CMDID_TOGGLESHOWMODE         365
#define CMDID_TOGGLESLIDESHOW        366
#define CMDID_SETSLIDESHOWBRDRCOLOR  367
#define CMDID_SETSLIDESHOWWINOFFSETS 368
#define CMDID_EXPORTXPMDECKTOGIF     369
#define CMDID_IMPORTGIFTOXPMDECK     370
#define CMDID_INSERTTHINSPACE        371
#define CMDID_INSERTVERTICALOFFSET   372
#define CMDID_REMOVEVERTICALOFFSET   373
#define CMDID_INSERTRIGHTSUPERSCRIPT 374
#define CMDID_INSERTRIGHTSUBSCRIPT   375

#define CMDID_INSERTLEFTSUPERSCRIPT   376
#define CMDID_INSERTLEFTSUBSCRIPT     377
#define CMDID_INSERTCENTERSUPERSCRIPT 378
#define CMDID_INSERTCENTERSUBSCRIPT   379
#define CMDID_SETSCRIPTFRACTION       380
#define CMDID_FAKEUSERAGENT           381
#define CMDID_FAKEREFERER             382
#define CMDID_TOGGLEKEEPALIVE         383
#define CMDID_SIZETOWIDEST            384
#define CMDID_SIZETONARROWEST         385
#define CMDID_SIZETOTALLEST           386
#define CMDID_SIZETOSHORTEST          387
#define CMDID_SIZETOGIVENWIDTHHEIGHT  388
#define CMDID_SIZETOGIVENWIDTH        389
#define CMDID_SIZETOGIVENHEIGHT       390
#define CMDID_EXECCMDSFROMFILE        391
#define CMDID_STARTEXECCMDSFROMFILE   392
#define CMDID_COPYPLAINTEXTASOBJECT   393
#define CMDID_SETTEXTFILLPATTERNCOLOR 394
#define CMDID_DRAWEDGEARC             395
#define CMDID_ALIGNDIRECT             396
#define CMDID_DISTRIBUTEDIRECT        397
#define CMDID_VISIBLEGRIDINSLIDESHOW  398
#define CMDID_CHANGESCROLLMODE        399

#define CMDID_SETALTEDITTEXTBGCOLOR        400
#define CMDID_SETALTEDITTEXTHIGHLIGHTCOLOR 401
#define CMDID_TOGGLEALTEDITTEXTBGCOLOR     402
#define CMDID_CHANGEALLSELFONTUNDERLINE    403
#define CMDID_EDITPAGEFILENAMES            404
#define CMDID_EXPORTHALFTONEBITMAP         405
#define CMDID_EXPORTTHRESHOLDBITMAP        406
#define CMDID_SETEXPORTBITMAPTHRESHOLD     407
#define CMDID_PRECISESCALEEVERYTHING       408
#define CMDID_SETPAPERCOLOR                409
#define CMDID_TOGGLEEQATTRSHOWN            410
#define CMDID_SCREENCAPTURE                411
#define CMDID_FULLSCREENCAPTURE            412
#define CMDID_DELAYEDFULLSCREENCAPTURE     413
#define CMDID_TOGGLEHIDEDURINGCAPTURE      414
#define CMDID_EDITDOMAINPATHS              415
#define CMDID_SELECTDEFAULTDOMAIN          416
#define CMDID_ADDADOMAIN                   417
#define CMDID_DELETEADOMAIN                418
#define CMDID_RELOADDOMAININFOFROMX        419
#define CMDID_IMPORTPNGFILE                420
#define CMDID_EDITATTRINEDITOR             421
#define CMDID_SETHTMLEXPORTTEMPLATE        422
#define CMDID_PRINTPAGES                   423
#define CMDID_GOHYPERSPACEINSLIDESHOW      424

#define CMDID_FREEHANDMODEINSLIDESHOW    425
#define CMDID_RECENTLYUSEDFILES          426
#define CMDID_MOVEEDITTEXTBOX            427
#define CMDID_GETPROPERTY                428
#define CMDID_REPLACEGRAPHIC             429
#define CMDID_TOGGLESHOWMEASUREMENTINTT  430
#define CMDID_IMPORTJPEGFILE             431
#define CMDID_TOGGLEAUTOEPSPREVIEWBITMAP 432
#define CMDID_CREATETHUMBNAILS           433
#define CMDID_CONNECT2PORTSBYWIRE        434
#define CMDID_RENAMESIGNAMEFORAPORT      435
#define CMDID_CLEARSIGNAMEFORAPORT       436
#define CMDID_TOGGLESHOWWIRESIGNALNAME   437
#define CMDID_TOGGLESHOWCHOICEBAR        438
#define CMDID_MERGEPORTSWITHANOBJECT     439
#define CMDID_RENUMBER_OBJECT_IDS        440
#define CMDID_REPEATCONNECT2PORTSBYWIRE  441
#define CMDID_CONNECTPORTSTOBROADCAST    442
#define CMDID_IMPORTMULTIPAGETEXTFILE    443
#define CMDID_SETMARGINSONIMPORTTEXT     444
#define CMDID_TOGGLEWORDWRAPONIMPORTTEXT 445
#define CMDID_DATA_IN_MBUFF              446
#define CMDID_BENCHMARK                  447
#define CMDID_CONVERTTOBEZIER            448
#define CMDID_SETBEZIERCONVERTNUMSEGS    449

#define CMDID_ADDSQUARETICKMARKS      450
#define CMDID_ADDTRIANGLETICKMARKS    451
#define CMDID_ADDCIRCLETICKMARKS      452
#define CMDID_ADDXTICKMARKS           453
#define CMDID_ADDDIAMONDTICKMARKS     454
#define CMDID_ADDBOWTIETICKMARKS      455
#define CMDID_ADDINVTRIANGLETICKMARKS 456
#define CMDID_ADDPLUSTICKMARKS        457
#define CMDID_ADDHOURGLASSTICKMARKS   458
#define CMDID_SETTICKMARKSIZE         459
#define CMDID_PEEKDIMENSION           460
#define CMDID_TOGGLESHOWCHAT          461
#define CMDID_SAVEPAGESAS             462
#define CMDID_IMPORTPPMFILE           463
#define CMDID_ADDPAGEBEFORECOPYALL    464
#define CMDID_ADDPAGEAFTERCOPYALL     465
#define CMDID_INSERTHEXOCTALCHAR      466
#define CMDID_RESETINMETHOD           467
#define CMDID_IMPORTPBMFILE           468
#define CMDID_IMPORTPGMFILE           469
#define CMDID_EDITATTRGROUPINEDITOR   470
#define CMDID_LINKEXTJPEGFILE         471
#define CMDID_NEXTSLIDE               472
#define CMDID_PREVSLIDE               473
#define CMDID_SETOBJSHADOWCOLOR       474
#define CMDID_SETOBJSHADOWOFFSETS     475
#define CMDID_ADDOBJSHADOW            476
#define CMDID_REMOVEOBJSHADOW         477
#define CMDID_COPYUTF8                478
#define CMDID_PASTEUTF8               479
#define CMDID_REDUCETOMOBILEWEBCOLORS 480
#define CMDID_CREATEPIXMAPFROMSEL     481
#define CMDID_TOGGLEROTATEPIVOT       482
#define CMDID_SPECIFYROTATEPIVOT      483
#define CMDID_RESETROTATEPIVOT        484
#define CMDID_NEXTPOLYROTATEPIVOT     485
#define CMDID_MOVEROTATEPIVOTARCCNTR  486
#define CMDID_MOVEROTATEPIVOTCENTER   487
#define CMDID_MOVEROTATEPIVOTLT       488
#define CMDID_MOVEROTATEPIVOTRT       489
#define CMDID_MOVEROTATEPIVOTLB       490
#define CMDID_MOVEROTATEPIVOTRB       491
#define CMDID_MOVEROTATEPIVOTLEFT     492
#define CMDID_MOVEROTATEPIVOTRIGHT    493
#define CMDID_MOVEROTATEPIVOTTOP      494
#define CMDID_MOVEROTATEPIVOTBOTTOM   495
#define CMDID_CHOOSEROTATEPIVOT       496
#define CMDID_COLORWHEEL              497
#define CMDID_EXTENDSEGMENT           498
#define CMDID_TOGGLETIGHTERSPLINES    499

#define CMDID_INSERTSYMBOL                  500
#define CMDID_TOGGLERIGHTMARGIN             501
#define CMDID_SPECIFYRIGHTMARGIN            502
#define CMDID_CHANGEALLSELFONTOVERLINE      503
#define CMDID_TOGGLEFLOODREPLACECOLORTHRESH 504
#define CMDID_SETFLOODREPLACECOLORTHRESH    505
#define CMDID_REMOVETRANSPIXEL              506
#define CMDID_REPLACECOLORWITHTRANS         507
#define CMDID_NEWRECTFROMBOUNDINGBOX        508
#define CMDID_NEWOVALFROMBOUNDINGBOX        509
#define CMDID_NEWRCBOXFROMBOUNDINGBOX       510

#define MAXCMDIDS 511

#endif /*_CMDIDS_H_*/
